/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.Size;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.transition.R;
import universum.studios.android.transition.util.AnimatorWrapper;
import universum.studios.android.transition.util.TransitionUtils;

@RequiresApi(value=21)
public class Reveal
extends Visibility {
    public static final int REVEAL = 1;
    public static final int CONCEAL = 2;
    private static final float CENTER_FRACTION = 0.5f;
    public static final TimeInterpolator INTERPOLATOR = new FastOutSlowInInterpolator();
    private final Info info = new Info();
    private int mode = 1;
    private Float centerX;
    private Float centerY;
    private float centerXFraction = 0.5f;
    private float centerYFraction = 0.5f;
    private Integer centerGravity;
    private int centerVerticalOffset;
    private int centerHorizontalOffset;
    private Float startRadius;
    private Float endRadius;
    private int startVisibility = 0;
    private int endVisibility = 0;
    private int appearVisibility = 0;
    private int disappearVisibility = 0;

    public Reveal() {
        this(1);
    }

    public Reveal(int mode) {
        this.setMode(mode);
    }

    public Reveal(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Transition_Reveal, 0, 0);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.Transition_Reveal_transitionRevealMode) {
                this.setMode(attributes.getInteger(attrIndex, 1));
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_transitionStartRadius) {
                this.startRadius = Float.valueOf(attributes.getDimensionPixelSize(attrIndex, 0));
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_transitionEndRadius) {
                this.endRadius = Float.valueOf(attributes.getDimensionPixelSize(attrIndex, 0));
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_transitionAppearVisibility) {
                this.appearVisibility = attributes.getInteger(attrIndex, this.appearVisibility);
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_transitionDisappearVisibility) {
                this.disappearVisibility = attributes.getInteger(attrIndex, this.disappearVisibility);
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_transitionStartVisibility) {
                this.startVisibility = attributes.getInteger(attrIndex, this.startVisibility);
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_transitionEndVisibility) {
                this.endVisibility = attributes.getInteger(attrIndex, this.endVisibility);
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_transitionCenterGravity) {
                this.centerGravity = attributes.getInteger(attrIndex, 0);
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_transitionCenterHorizontalOffset) {
                this.centerHorizontalOffset = attributes.getDimensionPixelSize(attrIndex, 0);
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_transitionCenterVerticalOffset) {
                this.centerVerticalOffset = attributes.getDimensionPixelSize(attrIndex, 0);
                continue;
            }
            if (attrIndex == R.styleable.Transition_Reveal_android_centerX) {
                this.centerXFraction = attributes.getFraction(attrIndex, 1, 1, this.centerXFraction);
                continue;
            }
            if (attrIndex != R.styleable.Transition_Reveal_android_centerY) continue;
            this.centerYFraction = attributes.getFraction(attrIndex, 1, 1, this.centerYFraction);
        }
        attributes.recycle();
    }

    @FloatRange(from=0.0)
    public static float calculateRadius(@NonNull View view) {
        return Reveal.calculateRadius(view.getWidth(), view.getHeight());
    }

    @FloatRange(from=0.0)
    public static float calculateRadius(@FloatRange(from=0.0) float width, @FloatRange(from=0.0) float height) {
        return (float)Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
    }

    @NonNull
    @Size(value=2L)
    public static float[] resolveCenterPosition(@NonNull View view) {
        return Reveal.resolveCenterPosition(view, 0.5f, 0.5f);
    }

    @NonNull
    @Size(value=2L)
    public static float[] resolveCenterPosition(@NonNull View view, @FloatRange(from=0.0, to=1.0) float centerXFraction, @FloatRange(from=0.0, to=1.0) float centerYFraction) {
        float[] center = Reveal.resolveCenter(view, centerXFraction, centerYFraction);
        return new float[]{view.getX() + center[0], view.getY() + center[1]};
    }

    @NonNull
    @Size(value=2L)
    public static float[] resolveCenter(@NonNull View view) {
        return Reveal.resolveCenter(view, 0.5f, 0.5f);
    }

    @NonNull
    @Size(value=2L)
    public static float[] resolveCenter(@NonNull View view, @FloatRange(from=0.0, to=1.0) float centerXFraction, @FloatRange(from=0.0, to=1.0) float centerYFraction) {
        return new float[]{(float)view.getWidth() * centerXFraction, (float)view.getHeight() * centerYFraction};
    }

    @UiThread
    @Nullable
    public static Animator createAnimator(@NonNull View view, @FloatRange(from=0.0) float radiusStart, @FloatRange(from=0.0) float radiusEnd) {
        float[] center = Reveal.resolveCenterPosition(view);
        return Reveal.createAnimator(view, Math.round(center[0]), Math.round(center[1]), radiusStart, radiusEnd);
    }

    @UiThread
    @Nullable
    public static Animator createAnimator(@NonNull View view, @IntRange(from=0L) int centerX, @IntRange(from=0L) int centerY, @FloatRange(from=0.0) float radiusStart, @FloatRange(from=0.0) float radiusEnd) {
        if (!TransitionUtils.isViewAttachedToWindow(view) || radiusStart == radiusEnd) {
            return null;
        }
        AnimatorWrapper animatorWrapper = new AnimatorWrapper(ViewAnimationUtils.createCircularReveal((View)view, (int)centerX, (int)centerY, (float)radiusStart, (float)radiusEnd));
        animatorWrapper.setInterpolator(INTERPOLATOR);
        animatorWrapper.removeFeature(6);
        return animatorWrapper;
    }

    public final void setMode(int mode) {
        this.mode = mode;
    }

    public final int getMode() {
        return this.mode;
    }

    public void setStartRadius(@Nullable Float radius) {
        this.startRadius = radius;
    }

    @Nullable
    public Float getStartRadius() {
        return this.startRadius;
    }

    public void setEndRadius(@Nullable Float radius) {
        this.endRadius = radius;
    }

    @Nullable
    public Float getEndRadius() {
        return this.endRadius;
    }

    public void setStartVisibility(int visibility) {
        this.startVisibility = visibility;
    }

    public int getStartVisibility() {
        return this.startVisibility;
    }

    public void setEndVisibility(int visibility) {
        this.endVisibility = visibility;
    }

    public int getEndVisibility() {
        return this.endVisibility;
    }

    public void setAppearVisibility(int visibility) {
        this.appearVisibility = visibility;
    }

    public int getAppearVisibility() {
        return this.appearVisibility;
    }

    public void setDisappearVisibility(int visibility) {
        this.disappearVisibility = visibility;
    }

    public int getDisappearVisibility() {
        return this.disappearVisibility;
    }

    public void setCenterGravity(@Nullable Integer gravity) {
        this.centerGravity = gravity;
    }

    @Nullable
    public Integer getCenterGravity() {
        return this.centerGravity;
    }

    public void setCenterHorizontalOffset(int offset) {
        this.centerHorizontalOffset = offset;
    }

    public int getCenterHorizontalOffset() {
        return this.centerHorizontalOffset;
    }

    public void setCenterVerticalOffset(int offset) {
        this.centerVerticalOffset = offset;
    }

    public int getCenterVerticalOffset() {
        return this.centerVerticalOffset;
    }

    public void setCenterX(@Nullable Float centerX) {
        this.centerX = centerX;
    }

    @Nullable
    public Float getCenterX() {
        return this.centerX;
    }

    public void setCenterY(@Nullable Float centerY) {
        this.centerY = centerY;
    }

    @Nullable
    public Float getCenterY() {
        return this.centerY;
    }

    public void setCenterXFraction(@FloatRange(from=0.0, to=1.0) float fractionX) {
        this.centerXFraction = Math.max(0.0f, Math.min(1.0f, fractionX));
    }

    @FloatRange(from=0.0, to=1.0)
    public float getCenterXFraction() {
        return this.centerXFraction;
    }

    public void setCenterYFraction(@FloatRange(from=0.0, to=1.0) float fractionY) {
        this.centerYFraction = Math.max(0.0f, Math.min(1.0f, fractionY));
    }

    @FloatRange(from=0.0, to=1.0)
    public float getCenterYFraction() {
        return this.centerYFraction;
    }

    @Nullable
    public Animator onAppear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        this.calculateTransitionProperties(view);
        Animator animator = this.createAnimatorFromInfo(view);
        if (animator == null) {
            return null;
        }
        animator.addListener((Animator.AnimatorListener)new TransitionAnimatorListener(view, this.startVisibility, this.endVisibility));
        view.setVisibility(this.appearVisibility);
        return animator;
    }

    @Nullable
    public Animator onDisappear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        this.calculateTransitionProperties(view);
        Animator animator = this.createAnimatorFromInfo(view);
        if (animator == null) {
            return null;
        }
        animator.addListener((Animator.AnimatorListener)new TransitionAnimatorListener(view, this.startVisibility, this.endVisibility));
        view.setVisibility(this.disappearVisibility);
        return animator;
    }

    @VisibleForTesting
    void calculateTransitionProperties(View view) {
        float[] center = this.centerGravity == null ? Reveal.resolveCenter(view, this.centerXFraction, this.centerYFraction) : this.resolveGravityCenter(view);
        float centerX = this.centerX == null ? center[0] : this.centerX.floatValue();
        float centerY = this.centerY == null ? center[1] : this.centerY.floatValue();
        this.info.centerX = centerX + (float)this.centerHorizontalOffset;
        this.info.centerY = centerY + (float)this.centerVerticalOffset;
        float[] radii = this.calculateTransitionRadii(view);
        this.info.startRadius = this.startRadius == null ? radii[0] : this.startRadius.floatValue();
        this.info.endRadius = this.endRadius == null ? radii[1] : this.endRadius.floatValue();
    }

    @VisibleForTesting
    @NonNull
    final Info getInfo() {
        return this.info;
    }

    @SuppressLint(value={"RtlHardcoded"})
    private float[] resolveGravityCenter(View view) {
        float[] center = new float[]{0.0f, 0.0f};
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        int layoutDirection = view.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity((int)this.centerGravity, (int)layoutDirection);
        int horizontalGravity = absoluteGravity & 7;
        int verticalGravity = this.centerGravity & 0x70;
        switch (horizontalGravity) {
            case 1: {
                center[0] = (float)viewWidth / 2.0f;
                break;
            }
            case 5: {
                center[0] = viewWidth;
                break;
            }
            default: {
                center[0] = 0.0f;
            }
        }
        switch (verticalGravity) {
            case 16: {
                center[1] = (float)viewHeight / 2.0f;
                break;
            }
            case 80: {
                center[1] = viewHeight;
                break;
            }
            default: {
                center[1] = 0.0f;
            }
        }
        return center;
    }

    private float[] calculateTransitionRadii(View view) {
        float endRadius;
        float startRadius;
        switch (this.mode) {
            case 2: {
                startRadius = this.calculateTransitionRadius(view);
                endRadius = 0.0f;
                break;
            }
            default: {
                startRadius = 0.0f;
                endRadius = this.calculateTransitionRadius(view);
            }
        }
        return new float[]{startRadius, endRadius};
    }

    private float calculateTransitionRadius(View view) {
        float centerX = this.info.centerX;
        float centerY = this.info.centerY;
        float viewWidth = view.getWidth();
        float viewHeight = view.getHeight();
        float[] viewCenter = Reveal.resolveCenter(view);
        float horizontalDistance = centerX >= viewCenter[0] ? centerX / viewWidth * viewWidth : (1.0f - centerX / viewWidth) * viewWidth;
        float verticalDistance = centerY >= viewCenter[1] ? centerY / viewHeight * viewHeight : (1.0f - centerY / viewHeight) * viewHeight;
        return Reveal.calculateRadius(horizontalDistance, verticalDistance);
    }

    @Nullable
    private Animator createAnimatorFromInfo(View view) {
        return Reveal.createAnimator(view, Math.round(this.info.centerX), Math.round(this.info.centerY), this.info.startRadius, this.info.endRadius);
    }

    @VisibleForTesting
    static final class TransitionAnimatorListener
    extends AnimatorListenerAdapter {
        private final View animatingView;
        private final int visibilityStart;
        private final int visibilityEnd;

        TransitionAnimatorListener(View animatingView, int visibilityStart, int visibilityEnd) {
            this.animatingView = animatingView;
            this.visibilityStart = visibilityStart;
            this.visibilityEnd = visibilityEnd;
        }

        public void onAnimationStart(@NonNull Animator animation) {
            this.animatingView.setVisibility(this.visibilityStart);
        }

        public void onAnimationEnd(@NonNull Animator animation) {
            this.animatingView.setVisibility(this.visibilityEnd);
        }
    }

    @VisibleForTesting
    static final class Info {
        float startRadius;
        float endRadius;
        float centerX;
        float centerY;

        Info() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RevealMode {
    }
}

