/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition.util;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.ArrayMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

@RequiresApi(value=11)
public class AnimatorWrapper
extends Animator {
    public static final int START = 1;
    public static final int PAUSE = 2;
    public static final int RESUME = 4;
    public static final int END = 8;
    public static final int CANCEL = 16;
    public static final int ALL = 31;
    private final Animator animator;
    private int features = 31;
    private ArrayMap<Animator.AnimatorListener, AnimatorListenerWrapper> listenerWrappers;
    private ArrayMap<Animator.AnimatorPauseListener, AnimatorPauseListenerWrapper> pauseListenerWrappers;

    public AnimatorWrapper(@NonNull Animator animator) {
        this.animator = animator;
    }

    @NonNull
    public final Animator getWrappedAnimator() {
        return this.animator;
    }

    public void requestFeatures(int features) {
        this.features = features;
    }

    public void requestFeature(int feature) {
        this.features |= feature;
    }

    public void removeFeature(int feature) {
        this.features &= ~feature;
    }

    public boolean hasFeature(int feature) {
        return (this.features & feature) != 0;
    }

    public void addListener(@NonNull Animator.AnimatorListener listener) {
        this.ensureListenerWrappers();
        if (!this.listenerWrappers.containsKey((Object)listener)) {
            AnimatorListenerWrapper wrapper = new AnimatorListenerWrapper(listener, (Animator)this);
            this.listenerWrappers.put((Object)listener, (Object)wrapper);
            this.animator.addListener((Animator.AnimatorListener)wrapper);
        }
    }

    public void removeListener(@NonNull Animator.AnimatorListener listener) {
        this.ensureListenerWrappers();
        AnimatorListenerWrapper wrapper = (AnimatorListenerWrapper)this.listenerWrappers.get((Object)listener);
        if (wrapper != null) {
            this.listenerWrappers.remove((Object)listener);
            this.animator.removeListener((Animator.AnimatorListener)wrapper);
        }
    }

    private void ensureListenerWrappers() {
        if (this.listenerWrappers == null) {
            this.listenerWrappers = new ArrayMap(1);
        }
    }

    public void addPauseListener(@NonNull Animator.AnimatorPauseListener listener) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.hasFeature(2) || this.hasFeature(4)) {
            if (this.pauseListenerWrappers == null) {
                this.pauseListenerWrappers = new ArrayMap(1);
            }
            if (!this.pauseListenerWrappers.containsKey((Object)listener)) {
                AnimatorPauseListenerWrapper wrapper = new AnimatorPauseListenerWrapper(listener, (Animator)this);
                this.pauseListenerWrappers.put((Object)listener, (Object)wrapper);
                this.animator.addPauseListener((Animator.AnimatorPauseListener)wrapper);
            }
        }
    }

    public void removePauseListener(@NonNull Animator.AnimatorPauseListener listener) {
        AnimatorPauseListenerWrapper wrapper;
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.pauseListenerWrappers != null && (wrapper = (AnimatorPauseListenerWrapper)this.pauseListenerWrappers.get((Object)listener)) != null) {
            this.pauseListenerWrappers.remove((Object)listener);
            this.animator.removePauseListener((Animator.AnimatorPauseListener)wrapper);
        }
    }

    @NonNull
    public ArrayList<Animator.AnimatorListener> getListeners() {
        return this.listenerWrappers == null ? new ArrayList<Animator.AnimatorListener>(0) : new ArrayList(this.listenerWrappers.keySet());
    }

    public void removeAllListeners() {
        if (this.listenerWrappers != null) {
            this.listenerWrappers.clear();
            this.listenerWrappers = null;
        }
        if (this.pauseListenerWrappers != null) {
            this.pauseListenerWrappers.clear();
            this.pauseListenerWrappers = null;
        }
        this.animator.removeAllListeners();
    }

    public void setStartDelay(long startDelay) {
        this.animator.setStartDelay(startDelay);
    }

    public long getStartDelay() {
        return this.animator.getStartDelay();
    }

    public Animator setDuration(long duration) {
        this.animator.setDuration(duration);
        return this;
    }

    public long getDuration() {
        return this.animator.getDuration();
    }

    public void setInterpolator(@Nullable TimeInterpolator interpolator) {
        this.animator.setInterpolator(interpolator);
    }

    @RequiresApi(value=18)
    public TimeInterpolator getInterpolator() {
        return Build.VERSION.SDK_INT >= 18 ? this.animator.getInterpolator() : null;
    }

    public void setTarget(@Nullable Object target) {
        this.animator.setTarget(target);
    }

    public void start() {
        if (this.hasFeature(1)) {
            this.animator.start();
        }
    }

    public boolean isStarted() {
        return Build.VERSION.SDK_INT >= 14 && this.animator.isStarted();
    }

    public void pause() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.hasFeature(2)) {
            this.animator.pause();
        }
    }

    public boolean isPaused() {
        return Build.VERSION.SDK_INT >= 19 && this.animator.isPaused();
    }

    public void resume() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.hasFeature(2) || this.hasFeature(4)) {
            this.animator.resume();
        }
    }

    public void end() {
        if (this.hasFeature(1) || this.hasFeature(8)) {
            this.animator.end();
        }
    }

    public void cancel() {
        if (this.hasFeature(1) || this.hasFeature(16)) {
            this.animator.cancel();
        }
    }

    public boolean isRunning() {
        return this.animator.isRunning();
    }

    @RequiresApi(value=19)
    @VisibleForTesting
    static final class AnimatorPauseListenerWrapper
    extends BaseAnimatorListenerWrapper<Animator.AnimatorPauseListener>
    implements Animator.AnimatorPauseListener {
        AnimatorPauseListenerWrapper(Animator.AnimatorPauseListener listener, Animator animatorWrapper) {
            super(listener, animatorWrapper);
        }

        public void onAnimationPause(@NonNull Animator animation) {
            ((Animator.AnimatorPauseListener)this.listener).onAnimationPause(this.animatorWrapper);
        }

        public void onAnimationResume(@NonNull Animator animation) {
            ((Animator.AnimatorPauseListener)this.listener).onAnimationResume(this.animatorWrapper);
        }
    }

    @VisibleForTesting
    static final class AnimatorListenerWrapper
    extends BaseAnimatorListenerWrapper<Animator.AnimatorListener>
    implements Animator.AnimatorListener {
        AnimatorListenerWrapper(Animator.AnimatorListener listener, Animator animatorWrapper) {
            super(listener, animatorWrapper);
        }

        public void onAnimationStart(@NonNull Animator animation) {
            ((Animator.AnimatorListener)this.listener).onAnimationStart(this.animatorWrapper);
        }

        public void onAnimationEnd(@NonNull Animator animation) {
            ((Animator.AnimatorListener)this.listener).onAnimationEnd(this.animatorWrapper);
        }

        public void onAnimationCancel(@NonNull Animator animation) {
            ((Animator.AnimatorListener)this.listener).onAnimationCancel(this.animatorWrapper);
        }

        public void onAnimationRepeat(@NonNull Animator animation) {
            ((Animator.AnimatorListener)this.listener).onAnimationRepeat(this.animatorWrapper);
        }
    }

    private static class BaseAnimatorListenerWrapper<L> {
        final L listener;
        final Animator animatorWrapper;

        BaseAnimatorListenerWrapper(L listener, Animator animatorWrapper) {
            this.listener = listener;
            this.animatorWrapper = animatorWrapper;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WrapperFeatures {
    }
}

