/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.transition.R;
import universum.studios.android.transition.util.TransitionUtils;

@RequiresApi(value=21)
public class Scale
extends Visibility {
    public static final float MIN = 0.0f;
    public static final float MAX = 1.0f;
    public static final String PROPERTY_SCALE_X = "scaleX";
    public static final String PROPERTY_SCALE_Y = "scaleY";
    private static final float SCALE_FRACTION = 0.5f;
    private static final float START_SCALE_ON_APPEAR = 0.0f;
    private static final float START_SCALE_ON_DISAPPEAR = 1.0f;
    @VisibleForTesting
    static final String PROPERTY_TRANSITION_SCALE_X = Scale.class.getName() + ":transition.scaleX";
    @VisibleForTesting
    static final String PROPERTY_TRANSITION_SCALE_Y = Scale.class.getName() + ":transition.scaleY";
    public static final TimeInterpolator INTERPOLATOR = new FastOutSlowInInterpolator();
    private final Info info = new Info();
    private Float pivotX;
    private Float pivotY;
    private float pivotXFraction = 0.5f;
    private float pivotYFraction = 0.5f;

    public Scale() {
        this(3);
    }

    public Scale(int mode) {
        this.setMode(mode);
    }

    public Scale(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Transition_Scale, 0, 0);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.Transition_Scale_android_pivotX) {
                this.pivotXFraction = attributes.getFraction(attrIndex, 1, 1, this.pivotXFraction);
                continue;
            }
            if (attrIndex == R.styleable.Transition_Scale_android_pivotY) {
                this.pivotYFraction = attributes.getFraction(attrIndex, 1, 1, this.pivotYFraction);
                continue;
            }
            if (attrIndex == R.styleable.Transition_Scale_android_transformPivotX) {
                this.pivotX = Float.valueOf(attributes.getDimensionPixelSize(attrIndex, 0));
                continue;
            }
            if (attrIndex != R.styleable.Transition_Scale_android_transformPivotY) continue;
            this.pivotY = Float.valueOf(attributes.getDimensionPixelSize(attrIndex, 0));
        }
        attributes.recycle();
    }

    @Nullable
    public static Animator createAnimator(@NonNull View view, @FloatRange(from=0.0, to=1.0) float startScale, @FloatRange(from=0.0, to=1.0) float endScale) {
        return Scale.createAnimator(view, startScale, startScale, endScale, endScale);
    }

    @Nullable
    public static Animator createAnimator(@NonNull View view, @FloatRange(from=0.0, to=1.0) float startScaleX, @FloatRange(from=0.0, to=1.0) float startScaleY, @FloatRange(from=0.0, to=1.0) float endScaleX, @FloatRange(from=0.0, to=1.0) float endScaleY) {
        if (!TransitionUtils.isViewAttachedToWindow(view)) {
            return null;
        }
        float startX = Math.max(0.0f, Math.min(1.0f, startScaleX));
        float startY = Math.max(0.0f, Math.min(1.0f, startScaleY));
        float endX = Math.max(0.0f, Math.min(1.0f, endScaleX));
        float endY = Math.max(0.0f, Math.min(1.0f, endScaleY));
        if (startX == endX && startY == endY) {
            return null;
        }
        view.setScaleX(startX);
        view.setScaleY(startY);
        ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)PROPERTY_SCALE_X, (float[])new float[]{startX, endX}), PropertyValuesHolder.ofFloat((String)PROPERTY_SCALE_Y, (float[])new float[]{startY, endY})});
        animator.setInterpolator(INTERPOLATOR);
        return animator;
    }

    public void setPivotX(@Nullable Float pivotX) {
        this.pivotX = pivotX;
    }

    @Nullable
    public Float getPivotX() {
        return this.pivotX;
    }

    public void setPivotY(@Nullable Float pivotY) {
        this.pivotY = pivotY;
    }

    @Nullable
    public Float getPivotY() {
        return this.pivotY;
    }

    public void setPivotXFraction(@FloatRange(from=0.0, to=1.0) float fractionX) {
        this.pivotXFraction = Math.max(0.0f, Math.min(1.0f, fractionX));
    }

    @FloatRange(from=0.0, to=1.0)
    public float getPivotXFraction() {
        return this.pivotXFraction;
    }

    public void setPivotYFraction(@FloatRange(from=0.0, to=1.0) float fractionY) {
        this.pivotYFraction = Math.max(0.0f, Math.min(1.0f, fractionY));
    }

    @FloatRange(from=0.0, to=1.0)
    public float getPivotYFraction() {
        return this.pivotYFraction;
    }

    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        transitionValues.values.put(PROPERTY_TRANSITION_SCALE_X, Float.valueOf(transitionValues.view.getScaleX()));
        transitionValues.values.put(PROPERTY_TRANSITION_SCALE_Y, Float.valueOf(transitionValues.view.getScaleY()));
    }

    @VisibleForTesting
    @Size(value=2L)
    static float[] obtainStartScales(TransitionValues startValues, float defaultStartX, float defaultStartY) {
        Float startY;
        float[] startScales = new float[]{defaultStartX, defaultStartY};
        if (startValues == null) {
            return startScales;
        }
        Float startX = (Float)startValues.values.get(PROPERTY_TRANSITION_SCALE_X);
        if (startX != null) {
            startScales[0] = startX.floatValue();
        }
        if ((startY = (Float)startValues.values.get(PROPERTY_TRANSITION_SCALE_Y)) != null) {
            startScales[1] = startY.floatValue();
        }
        return startScales;
    }

    @Nullable
    public Animator onAppear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        this.calculateTransitionProperties(view);
        view.setPivotX(this.info.pivotX);
        view.setPivotY(this.info.pivotY);
        float[] startScales = Scale.obtainStartScales(startValues, 0.0f, 0.0f);
        return Scale.createAnimator(view, startScales[0] == 1.0f ? 0.0f : startScales[0], startScales[1] == 1.0f ? 0.0f : startScales[1], 1.0f, 1.0f);
    }

    @Nullable
    public Animator onDisappear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        this.calculateTransitionProperties(view);
        view.setPivotX(this.info.pivotX);
        view.setPivotY(this.info.pivotY);
        float[] startScales = Scale.obtainStartScales(startValues, 1.0f, 1.0f);
        return Scale.createAnimator(view, startScales[0], startScales[1], 0.0f, 0.0f);
    }

    @VisibleForTesting
    void calculateTransitionProperties(View view) {
        this.info.pivotX = this.pivotX == null ? (float)view.getWidth() * this.pivotXFraction : this.pivotX.floatValue();
        this.info.pivotY = this.pivotY == null ? (float)view.getHeight() * this.pivotYFraction : this.pivotY.floatValue();
    }

    @VisibleForTesting
    @NonNull
    final Info getInfo() {
        return this.info;
    }

    @VisibleForTesting
    static final class Info {
        float pivotX;
        float pivotY;

        Info() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScaleMode {
    }
}

