/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition;

import android.app.Activity;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.AnimRes;
import android.support.annotation.NonNull;
import universum.studios.android.transition.WindowTransition;

public class BasicWindowTransition
implements WindowTransition {
    public static final Parcelable.Creator<BasicWindowTransition> CREATOR = new Parcelable.Creator<BasicWindowTransition>(){

        public BasicWindowTransition createFromParcel(@NonNull Parcel source) {
            return new BasicWindowTransition(source);
        }

        public BasicWindowTransition[] newArray(int size) {
            return new BasicWindowTransition[size];
        }
    };
    private final int startEnterAnimRes;
    private final int startExitAnimRes;
    private final int finishEnterAnimRes;
    private final int finishExitAnimRes;
    private final String name;

    public BasicWindowTransition(@AnimRes int enterAnim, @AnimRes int exitAnim) {
        this(enterAnim, exitAnim, 0, 0);
    }

    public BasicWindowTransition(@AnimRes int startEnterAnim, @AnimRes int startExitAnim, @AnimRes int finishEnterAnim, @AnimRes int finishExitAnim) {
        this(startEnterAnim, startExitAnim, finishEnterAnim, finishExitAnim, "UNSPECIFIED");
    }

    public BasicWindowTransition(@AnimRes int startEnterAnim, @AnimRes int startExitAnim, @AnimRes int finishEnterAnim, @AnimRes int finishExitAnim, @NonNull String name) {
        this.startEnterAnimRes = startEnterAnim;
        this.startExitAnimRes = startExitAnim;
        this.finishEnterAnimRes = finishEnterAnim;
        this.finishExitAnimRes = finishExitAnim;
        this.name = name;
    }

    protected BasicWindowTransition(@NonNull Parcel source) {
        this.startEnterAnimRes = source.readInt();
        this.startExitAnimRes = source.readInt();
        this.finishEnterAnimRes = source.readInt();
        this.finishExitAnimRes = source.readInt();
        this.name = source.readString();
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.startEnterAnimRes);
        dest.writeInt(this.startExitAnimRes);
        dest.writeInt(this.finishEnterAnimRes);
        dest.writeInt(this.finishExitAnimRes);
        dest.writeString(this.name);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    @AnimRes
    public int getStartEnterAnimation() {
        return this.startEnterAnimRes;
    }

    @Override
    @AnimRes
    public int getStartExitAnimation() {
        return this.startExitAnimRes;
    }

    @Override
    @AnimRes
    public int getFinishEnterAnimation() {
        return this.finishEnterAnimRes;
    }

    @Override
    @AnimRes
    public int getFinishExitAnimation() {
        return this.finishExitAnimRes;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public void overrideStart(@NonNull Activity activity) {
        activity.overridePendingTransition(this.startEnterAnimRes, this.startExitAnimRes);
    }

    @Override
    public void overrideFinish(@NonNull Activity activity) {
        activity.overridePendingTransition(this.finishEnterAnimRes, this.finishExitAnimRes);
    }
}

