/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.transition.Transition;
import android.transition.TransitionInflater;
import android.transition.TransitionManager;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BaseNavigationalTransition<T extends BaseNavigationalTransition> {
    public static final boolean MATERIAL_SUPPORT = Build.VERSION.SDK_INT >= 21;
    public static final int RC_NONE = -1;
    private static final int TRANSITION_ENTER = 1;
    private static final int TRANSITION_REENTER = 2;
    private static final int TRANSITION_RETURN = 4;
    private static final int TRANSITION_EXIT = 8;
    private static final int TRANSITION_SHARED_ELEMENT_ENTER = 16;
    private static final int TRANSITION_SHARED_ELEMENT_REENTER = 32;
    private static final int TRANSITION_SHARED_ELEMENT_RETURN = 64;
    private static final int TRANSITION_SHARED_ELEMENT_EXIT = 128;
    private final Class<? extends Activity> classOfTransitionActivity;
    private Bundle intentExtras;
    int requestCode = -1;
    private Transition enterTransition;
    private Transition reenterTransition;
    private Transition returnTransition;
    private Transition exitTransition;
    private Transition sharedElementEnterTransition;
    private Transition sharedElementReenterTransition;
    private Transition sharedElementReturnTransition;
    private Transition sharedElementExitTransition;
    private int specifiedTransitions;
    private Boolean allowEnterTransitionOverlap;
    private Boolean allowReturnTransitionOverlap;
    private List<Pair<View, String>> sharedElements;
    private Boolean sharedElementUseOverlay;
    private TransitionInflater transitionInflater;

    public BaseNavigationalTransition() {
        this.classOfTransitionActivity = null;
    }

    public BaseNavigationalTransition(@NonNull Class<? extends Activity> classOfTransitionActivity) {
        this.classOfTransitionActivity = classOfTransitionActivity;
    }

    @Nullable
    public final Class<? extends Activity> getActivityClass() {
        return this.classOfTransitionActivity;
    }

    public T intentExtras(@Nullable Bundle extras) {
        this.intentExtras = extras;
        return (T)this;
    }

    @NonNull
    public Bundle intentExtras() {
        return this.intentExtras == null ? (this.intentExtras = new Bundle()) : this.intentExtras;
    }

    public T requestCode(@IntRange(from=-1L) int requestCode) {
        this.requestCode = requestCode;
        return (T)this;
    }

    @IntRange(from=-1L)
    public int requestCode() {
        return this.requestCode;
    }

    public T enterTransition(@Nullable Transition transition) {
        this.specifiedTransitions |= 1;
        this.enterTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition enterTransition() {
        return this.enterTransition;
    }

    public T reenterTransition(@Nullable Transition transition) {
        this.specifiedTransitions |= 2;
        this.reenterTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition reenterTransition() {
        return this.reenterTransition;
    }

    public T returnTransition(@Nullable Transition transition) {
        this.specifiedTransitions |= 4;
        this.returnTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition returnTransition() {
        return this.returnTransition;
    }

    public T exitTransition(@Nullable Transition transition) {
        this.specifiedTransitions |= 8;
        this.exitTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition exitTransition() {
        return this.exitTransition;
    }

    public T allowEnterTransitionOverlap(boolean allow) {
        this.allowEnterTransitionOverlap = allow;
        return (T)this;
    }

    public boolean allowEnterTransitionOverlap() {
        return this.allowEnterTransitionOverlap == null || this.allowEnterTransitionOverlap != false;
    }

    public T allowReturnTransitionOverlap(boolean allow) {
        this.allowReturnTransitionOverlap = allow;
        return (T)this;
    }

    public boolean allowReturnTransitionOverlap() {
        return this.allowReturnTransitionOverlap == null || this.allowReturnTransitionOverlap != false;
    }

    public T sharedElementEnterTransition(@Nullable Transition transition) {
        this.specifiedTransitions |= 0x10;
        this.sharedElementEnterTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition sharedElementEnterTransition() {
        return this.sharedElementEnterTransition;
    }

    public T sharedElementReenterTransition(@Nullable Transition transition) {
        this.specifiedTransitions |= 0x20;
        this.sharedElementReenterTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition sharedElementReenterTransition() {
        return this.sharedElementReenterTransition;
    }

    public T sharedElementReturnTransition(@Nullable Transition transition) {
        this.specifiedTransitions |= 0x40;
        this.sharedElementReturnTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition sharedElementReturnTransition() {
        return this.sharedElementReturnTransition;
    }

    public T sharedElementExitTransition(@Nullable Transition transition) {
        this.specifiedTransitions |= 0x80;
        this.sharedElementExitTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition sharedElementExitTransition() {
        return this.sharedElementExitTransition;
    }

    public T sharedElementsUseOverlay(boolean useOverlay) {
        this.sharedElementUseOverlay = useOverlay;
        return (T)this;
    }

    public boolean sharedElementsUseOverlay() {
        return this.sharedElementUseOverlay == null || this.sharedElementUseOverlay != false;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public Transition inflateTransition(@NonNull Context context, int resource) {
        if (MATERIAL_SUPPORT) {
            if (this.transitionInflater == null) {
                this.transitionInflater = TransitionInflater.from((Context)context);
            }
            return this.transitionInflater.inflateTransition(resource);
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public TransitionManager inflateTransitionManager(@NonNull Context context, int resource, @NonNull ViewGroup sceneRoot) {
        if (MATERIAL_SUPPORT) {
            if (this.transitionInflater == null) {
                this.transitionInflater = TransitionInflater.from((Context)context);
            }
            return this.transitionInflater.inflateTransitionManager(resource, sceneRoot);
        }
        return null;
    }

    @SafeVarargs
    public final T sharedElements(Pair<View, String> ... elements) {
        if (this.sharedElements == null) {
            this.sharedElements = new ArrayList<Pair<View, String>>(1);
        }
        this.sharedElements.addAll(Arrays.asList(elements));
        return (T)this;
    }

    public T sharedElement(@NonNull View element, @NonNull String elementName) {
        if (this.sharedElements == null) {
            this.sharedElements = new ArrayList<Pair<View, String>>(1);
        }
        this.sharedElements.add((Pair<View, String>)new Pair((Object)element, (Object)elementName));
        return (T)this;
    }

    @Nullable
    public List<Pair<View, String>> sharedElements() {
        return this.sharedElements;
    }

    @Nullable
    public Pair<View, String> singleSharedElement() {
        return this.sharedElements == null || this.sharedElements.isEmpty() ? null : this.sharedElements.get(0);
    }

    public void start(@NonNull Activity caller) {
        this.configureOutgoingTransitions(caller);
        this.onStart(caller);
    }

    @SuppressLint(value={"NewApi"})
    protected void onStart(@NonNull Activity caller) {
        Intent intent = this.createIntent(caller);
        if (MATERIAL_SUPPORT) {
            Bundle options = this.makeSceneTransitionAnimation(caller).toBundle();
            if (this.requestCode == -1) {
                caller.startActivity(intent, options);
            } else {
                caller.startActivityForResult(intent, this.requestCode, options);
            }
        } else if (this.requestCode == -1) {
            caller.startActivity(intent);
        } else {
            caller.startActivityForResult(intent, this.requestCode);
        }
    }

    protected void finishCallerDelayed(final @NonNull Activity caller, @IntRange(from=0L) long delay) {
        View decorView = caller.getWindow().getDecorView();
        if (decorView != null) {
            decorView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 17 && caller.isDestroyed()) {
                        return;
                    }
                    if (caller.isFinishing()) {
                        return;
                    }
                    BaseNavigationalTransition.this.onFinishCaller(caller);
                }
            }, delay);
        }
    }

    protected void finishCaller(@NonNull Activity caller) {
        this.onFinishCaller(caller);
    }

    @SuppressLint(value={"NewApi"})
    protected void onFinishCaller(@NonNull Activity caller) {
        if (MATERIAL_SUPPORT) {
            caller.finishAfterTransition();
        } else {
            caller.finish();
        }
    }

    public void configureTransitions(@NonNull Activity activity) {
        this.configureIncomingTransitions(activity);
        this.configureOutgoingTransitions(activity);
    }

    public void configureIncomingTransitions(@NonNull Activity activity) {
        if (MATERIAL_SUPPORT) {
            Window window = activity.getWindow();
            if ((this.specifiedTransitions & 1) != 0) {
                window.setEnterTransition(this.enterTransition);
            }
            if ((this.specifiedTransitions & 4) != 0) {
                window.setReturnTransition(this.returnTransition);
            }
            if ((this.specifiedTransitions & 0x10) != 0) {
                window.setSharedElementEnterTransition(this.sharedElementEnterTransition);
            }
            if ((this.specifiedTransitions & 0x40) != 0) {
                window.setSharedElementReturnTransition(this.sharedElementReturnTransition);
            }
            if (this.allowEnterTransitionOverlap != null) {
                window.setAllowEnterTransitionOverlap(this.allowEnterTransitionOverlap.booleanValue());
            }
            if (this.allowReturnTransitionOverlap != null) {
                window.setAllowReturnTransitionOverlap(this.allowReturnTransitionOverlap.booleanValue());
            }
            if (this.sharedElementUseOverlay != null) {
                window.setSharedElementsUseOverlay(this.sharedElementUseOverlay.booleanValue());
            }
        }
    }

    public void configureOutgoingTransitions(@NonNull Activity activity) {
        if (MATERIAL_SUPPORT) {
            Window window = activity.getWindow();
            if ((this.specifiedTransitions & 2) != 0) {
                window.setReenterTransition(this.reenterTransition);
            }
            if ((this.specifiedTransitions & 8) != 0) {
                window.setExitTransition(this.exitTransition);
            }
            if ((this.specifiedTransitions & 0x20) != 0) {
                window.setSharedElementReenterTransition(this.sharedElementReenterTransition);
            }
            if ((this.specifiedTransitions & 0x80) != 0) {
                window.setSharedElementExitTransition(this.sharedElementExitTransition);
            }
            if (this.sharedElementUseOverlay != null) {
                window.setSharedElementsUseOverlay(this.sharedElementUseOverlay.booleanValue());
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public ActivityOptions makeSceneTransitionAnimation(@NonNull Activity caller) {
        if (MATERIAL_SUPPORT) {
            if (this.sharedElements != null && !this.sharedElements.isEmpty()) {
                Pair[] pairs = new Pair[this.sharedElements.size()];
                this.sharedElements.toArray(pairs);
                return ActivityOptions.makeSceneTransitionAnimation((Activity)caller, (Pair[])pairs);
            }
            return ActivityOptions.makeSceneTransitionAnimation((Activity)caller, (Pair[])new Pair[0]);
        }
        return null;
    }

    @NonNull
    public Intent createIntent(@NonNull Activity caller) {
        if (this.classOfTransitionActivity == null) {
            throw new UnsupportedOperationException("Navigational transition(" + this.getClass().getSimpleName() + ") does not have any class of intended activity specified.");
        }
        Intent intent = new Intent((Context)caller, this.classOfTransitionActivity);
        if (this.intentExtras != null) {
            intent.putExtras(this.intentExtras);
        }
        return intent;
    }

    public void finish(@NonNull Activity caller) {
        this.onFinish(caller);
    }

    @SuppressLint(value={"NewApi"})
    protected void onFinish(@NonNull Activity caller) {
        if (MATERIAL_SUPPORT) {
            caller.finishAfterTransition();
        } else {
            caller.finish();
        }
    }
}

