/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.transition.R;
import universum.studios.android.transition.util.TransitionUtils;

@RequiresApi(value=21)
public class Translate
extends Visibility {
    @VisibleForTesting
    static final String PROPERTY_TRANSITION_LOCATION_ON_SCREEN = Translate.class.getName() + ":transition.locationOnScreen";
    public static final TimeInterpolator INTERPOLATOR = new FastOutSlowInInterpolator();
    public static final DeltaResolver DELTA_RESOLVER = new DeltaResolver(){

        @Override
        public float resolveDeltaX(@NonNull ViewGroup sceneRoot, @NonNull View view, int valueRelativity, float value) {
            return this.resolveDelta(valueRelativity, value, sceneRoot.getWidth(), view.getWidth());
        }

        @Override
        public float resolveDeltaY(@NonNull ViewGroup sceneRoot, @NonNull View view, int valueRelativity, float value) {
            return this.resolveDelta(valueRelativity, value, sceneRoot.getHeight(), view.getHeight());
        }

        private float resolveDelta(int valueRelativity, float value, int sceneSize, int viewSize) {
            switch (valueRelativity) {
                case 1: {
                    return value * (float)viewSize;
                }
                case 2: {
                    return value * (float)sceneSize;
                }
            }
            return value;
        }
    };
    private float mTranslationXDelta;
    private float mTranslationYDelta;
    private int mTranslationXRelativity = 0;
    private int mTranslationYRelativity = 0;

    public Translate() {
    }

    public Translate(int mode) {
        this.setMode(mode);
    }

    public Translate(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        Resources resources = context.getResources();
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Ui_Transition_Translate, 0, 0);
        for (int i = 0; i < attributes.getIndexCount(); ++i) {
            Description description;
            int index = attributes.getIndex(i);
            if (index == R.styleable.Ui_Transition_Translate_uiTranslationXDelta) {
                description = Description.parseValue(resources, attributes.peekValue(index));
                this.mTranslationXRelativity = description.valueRelativity;
                this.mTranslationXDelta = description.value;
                continue;
            }
            if (index != R.styleable.Ui_Transition_Translate_uiTranslationYDelta) continue;
            description = Description.parseValue(resources, attributes.peekValue(index));
            this.mTranslationYRelativity = description.valueRelativity;
            this.mTranslationYDelta = description.value;
        }
        attributes.recycle();
    }

    @Nullable
    public static Animator createAnimator(@NonNull Transition transition, @NonNull View view, @NonNull TransitionValues transitionValues, int viewX, int viewY, float startX, float startY, float endX, float endY) {
        if (!TransitionUtils.isViewAttachedToWindow(view)) {
            return null;
        }
        float animationStartX = startX;
        float animationStartY = startY;
        float animationEndX = endX;
        float animationEndY = endY;
        float viewEndX = view.getTranslationX();
        float viewEndY = view.getTranslationY();
        int[] startPosition = (int[])transitionValues.view.getTag(R.id.ui_transition_tag_position);
        if (startPosition != null) {
            animationStartX = (float)(startPosition[0] - viewX) + viewEndX;
            animationStartY = (float)(startPosition[1] - viewY) + viewEndY;
        }
        if (animationStartX == animationEndX && animationStartY == animationEndY) {
            return null;
        }
        view.setTranslationX(animationStartX);
        view.setTranslationY(animationStartY);
        int viewStartX = viewX + Math.round(startX - viewEndX);
        int viewStartY = viewY + Math.round(startY - viewEndY);
        Path path = new Path();
        path.moveTo(animationStartX, animationStartY);
        path.lineTo(animationEndX, animationEndY);
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (Property)View.TRANSLATION_X, (Property)View.TRANSLATION_Y, (Path)path);
        TransitionAnimatorListener listener = new TransitionAnimatorListener(view, transitionValues.view, viewStartX, viewStartY, viewEndX, viewEndY);
        transition.addListener((Transition.TransitionListener)listener);
        animator.addListener((Animator.AnimatorListener)listener);
        animator.addPauseListener((Animator.AnimatorPauseListener)listener);
        animator.setInterpolator(INTERPOLATOR);
        return animator;
    }

    public void setTranslationXDelta(float xDelta) {
        this.mTranslationXDelta = xDelta;
    }

    public float getTranslationXDelta() {
        return this.mTranslationXDelta;
    }

    public void setTranslationYDelta(float yDelta) {
        this.mTranslationYDelta = yDelta;
    }

    public float getTranslationYDelta() {
        return this.mTranslationYDelta;
    }

    public void setTranslationXRelativity(int xRelativity) {
        this.mTranslationXRelativity = xRelativity;
    }

    public int getTranslationXRelativity() {
        return this.mTranslationXRelativity;
    }

    public void setTranslationYRelativity(int yRelativity) {
        this.mTranslationYRelativity = yRelativity;
    }

    public int getTranslationYRelativity() {
        return this.mTranslationYRelativity;
    }

    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    public void captureEndValues(@NonNull TransitionValues transitionValues) {
        super.captureEndValues(transitionValues);
        this.captureValues(transitionValues);
    }

    private void captureValues(TransitionValues values) {
        int[] locationOnScreen = new int[2];
        values.view.getLocationOnScreen(locationOnScreen);
        values.values.put(PROPERTY_TRANSITION_LOCATION_ON_SCREEN, locationOnScreen);
    }

    @Nullable
    public Animator onAppear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        if (endValues == null) {
            return null;
        }
        int[] locationOnScreen = (int[])endValues.values.get(PROPERTY_TRANSITION_LOCATION_ON_SCREEN);
        if (locationOnScreen == null) {
            return null;
        }
        float endX = view.getTranslationX();
        float endY = view.getTranslationY();
        float startX = endX + DELTA_RESOLVER.resolveDeltaX(sceneRoot, view, this.mTranslationXRelativity, this.mTranslationXDelta);
        float startY = endY + DELTA_RESOLVER.resolveDeltaY(sceneRoot, view, this.mTranslationYRelativity, this.mTranslationYDelta);
        return Translate.createAnimator((Transition)this, view, endValues, locationOnScreen[0], locationOnScreen[1], startX, startY, endX, endY);
    }

    @Nullable
    public Animator onDisappear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        if (startValues == null) {
            return null;
        }
        int[] locationOnScreen = (int[])startValues.values.get(PROPERTY_TRANSITION_LOCATION_ON_SCREEN);
        if (locationOnScreen == null) {
            return null;
        }
        float startX = view.getTranslationX();
        float startY = view.getTranslationY();
        float endX = startX + DELTA_RESOLVER.resolveDeltaX(sceneRoot, view, this.mTranslationXRelativity, this.mTranslationXDelta);
        float endY = startY + DELTA_RESOLVER.resolveDeltaY(sceneRoot, view, this.mTranslationYRelativity, this.mTranslationYDelta);
        return Translate.createAnimator((Transition)this, view, startValues, locationOnScreen[0], locationOnScreen[1], startX, startY, endX, endY);
    }

    @VisibleForTesting
    static final class TransitionAnimatorListener
    extends AnimatorListenerAdapter
    implements Transition.TransitionListener {
        private final View animatingView;
        private final View staticView;
        private int[] animationPosition;
        private final float startX;
        private final float startY;
        private float pausedX;
        private float pausedY;
        private final float endX;
        private final float endY;

        TransitionAnimatorListener(View animatingView, View staticView, float startX, float startY, float endX, float endY) {
            this.animatingView = animatingView;
            this.staticView = staticView;
            this.startX = startX - (float)Math.round(animatingView.getTranslationX());
            this.startY = startY - (float)Math.round(animatingView.getTranslationY());
            this.endX = endX;
            this.endY = endY;
            this.animationPosition = (int[])staticView.getTag(R.id.ui_transition_tag_position);
            if (this.animationPosition != null) {
                staticView.setTag(R.id.ui_transition_tag_position, null);
            }
        }

        public void onAnimationCancel(Animator animation) {
            if (this.animationPosition == null) {
                this.animationPosition = new int[2];
            }
            this.animationPosition[0] = Math.round(this.startX + this.animatingView.getTranslationX());
            this.animationPosition[1] = Math.round(this.startY + this.animatingView.getTranslationY());
            this.staticView.setTag(R.id.ui_transition_tag_position, (Object)this.animationPosition);
        }

        public void onAnimationPause(Animator animation) {
            this.pausedX = this.animatingView.getTranslationX();
            this.pausedY = this.animatingView.getTranslationY();
            this.animatingView.setTranslationX(this.endX);
            this.animatingView.setTranslationY(this.endY);
        }

        public void onAnimationResume(Animator animation) {
            this.animatingView.setTranslationX(this.pausedX);
            this.animatingView.setTranslationY(this.pausedY);
        }

        public void onTransitionStart(@NonNull Transition transition) {
        }

        public void onTransitionEnd(@NonNull Transition transition) {
            this.animatingView.setTranslationX(this.endX);
            this.animatingView.setTranslationY(this.endY);
        }

        public void onTransitionCancel(@NonNull Transition transition) {
        }

        public void onTransitionPause(@NonNull Transition transition) {
        }

        public void onTransitionResume(@NonNull Transition transition) {
        }
    }

    public static final class Description {
        public static final int NONE = 0;
        public static final int RELATIVE_TO_TARGET = 1;
        public static final int RELATIVE_TO_SCENE = 2;
        public final int valueRelativity;
        public final float value;

        private Description(int valueRelativity, float value) {
            this.valueRelativity = valueRelativity;
            this.value = value;
        }

        @NonNull
        public static Description parseValue(@NonNull Resources resources, @Nullable TypedValue typedValue) {
            int valueRelativity = 0;
            float value = 0.0f;
            if (typedValue != null) {
                switch (typedValue.type) {
                    case 4: {
                        value = typedValue.getFloat();
                        break;
                    }
                    case 5: {
                        value = TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)resources.getDisplayMetrics());
                        break;
                    }
                    case 6: {
                        valueRelativity = (typedValue.data & 0xF) == 1 ? 2 : 1;
                        value = TypedValue.complexToFloat((int)typedValue.data);
                        break;
                    }
                    default: {
                        if (typedValue.type < 16 || typedValue.type > 31) break;
                        value = typedValue.data;
                    }
                }
            }
            return new Description(valueRelativity, value);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ValueRelativity {
        }
    }

    public static interface DeltaResolver {
        public float resolveDeltaX(@NonNull ViewGroup var1, @NonNull View var2, int var3, float var4);

        public float resolveDeltaY(@NonNull ViewGroup var1, @NonNull View var2, int var3, float var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TranslateMode {
    }
}

