/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.transition.R;
import universum.studios.android.transition.util.AnimatorWrapper;
import universum.studios.android.transition.util.TransitionUtils;

@RequiresApi(value=21)
public class Reveal
extends Visibility {
    public static final int REVEAL = 1;
    public static final int CONCEAL = 2;
    private static final float CENTER_FRACTION = 0.5f;
    public static final TimeInterpolator INTERPOLATOR = new FastOutSlowInInterpolator();
    private final Info mInfo = new Info();
    private int mMode = 1;
    private Float mCenterX;
    private Float mCenterY;
    private float mCenterXFraction = 0.5f;
    private float mCenterYFraction = 0.5f;
    private Integer mCenterGravity;
    private int mCenterVerticalOffset;
    private int mCenterHorizontalOffset;
    private Float mStartRadius;
    private Float mEndRadius;
    private int mStartVisibility = 0;
    private int mEndVisibility = 0;
    private int mAppearVisibility = 0;
    private int mDisappearVisibility = 0;

    public Reveal() {
        this(1);
    }

    public Reveal(int mode) {
        this.setMode(mode);
    }

    public Reveal(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Ui_Transition_Reveal, 0, 0);
        for (int i = 0; i < attributes.getIndexCount(); ++i) {
            int index = attributes.getIndex(i);
            if (index == R.styleable.Ui_Transition_Reveal_uiRevealMode) {
                this.setMode(attributes.getInteger(index, 1));
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_uiStartRadius) {
                this.mStartRadius = Float.valueOf(attributes.getDimensionPixelSize(index, 0));
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_uiEndRadius) {
                this.mEndRadius = Float.valueOf(attributes.getDimensionPixelSize(index, 0));
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_uiAppearVisibility) {
                this.mAppearVisibility = attributes.getInteger(index, this.mAppearVisibility);
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_uiDisappearVisibility) {
                this.mDisappearVisibility = attributes.getInteger(index, this.mDisappearVisibility);
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_uiStartVisibility) {
                this.mStartVisibility = attributes.getInteger(index, this.mStartVisibility);
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_uiEndVisibility) {
                this.mEndVisibility = attributes.getInteger(index, this.mEndVisibility);
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_uiCenterGravity) {
                this.mCenterGravity = attributes.getInteger(index, 0);
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_uiCenterVerticalOffset) {
                this.mCenterVerticalOffset = attributes.getDimensionPixelSize(index, 0);
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_uiCenterHorizontalOffset) {
                this.mCenterHorizontalOffset = attributes.getDimensionPixelSize(index, 0);
                continue;
            }
            if (index == R.styleable.Ui_Transition_Reveal_android_centerX) {
                this.mCenterXFraction = attributes.getFraction(index, 1, 1, this.mCenterXFraction);
                continue;
            }
            if (index != R.styleable.Ui_Transition_Reveal_android_centerY) continue;
            this.mCenterYFraction = attributes.getFraction(index, 1, 1, this.mCenterYFraction);
        }
        attributes.recycle();
    }

    @FloatRange(from=0.0)
    public static float calculateRadius(@NonNull View view) {
        return Reveal.calculateRadius(view.getWidth(), view.getHeight());
    }

    @FloatRange(from=0.0)
    public static float calculateRadius(@FloatRange(from=0.0) float width, @FloatRange(from=0.0) float height) {
        return (float)Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
    }

    @Size(value=2L)
    @NonNull
    public static float[] resolveCenterPosition(@NonNull View view) {
        return Reveal.resolveCenterPosition(view, 0.5f, 0.5f);
    }

    @Size(value=2L)
    @NonNull
    public static float[] resolveCenterPosition(@NonNull View view, @FloatRange(from=0.0, to=1.0) float centerXFraction, @FloatRange(from=0.0, to=1.0) float centerYFraction) {
        float[] center = Reveal.resolveCenter(view, centerXFraction, centerYFraction);
        return new float[]{view.getX() + center[0], view.getY() + center[1]};
    }

    @Size(value=2L)
    @NonNull
    public static float[] resolveCenter(@NonNull View view) {
        return Reveal.resolveCenter(view, 0.5f, 0.5f);
    }

    @Size(value=2L)
    @NonNull
    public static float[] resolveCenter(@NonNull View view, @FloatRange(from=0.0, to=1.0) float centerXFraction, @FloatRange(from=0.0, to=1.0) float centerYFraction) {
        return new float[]{(float)view.getWidth() * centerXFraction, (float)view.getHeight() * centerYFraction};
    }

    @UiThread
    @Nullable
    public static Animator createAnimator(@NonNull View view, @FloatRange(from=0.0) float radiusStart, @FloatRange(from=0.0) float radiusEnd) {
        float[] center = Reveal.resolveCenterPosition(view);
        return Reveal.createAnimator(view, Math.round(center[0]), Math.round(center[1]), radiusStart, radiusEnd);
    }

    @UiThread
    @Nullable
    public static Animator createAnimator(@NonNull View view, @IntRange(from=0L) int centerX, @IntRange(from=0L) int centerY, @FloatRange(from=0.0) float radiusStart, @FloatRange(from=0.0) float radiusEnd) {
        if (!TransitionUtils.isViewAttachedToWindow(view) || radiusStart == radiusEnd) {
            return null;
        }
        AnimatorWrapper animatorWrapper = new AnimatorWrapper(ViewAnimationUtils.createCircularReveal((View)view, (int)centerX, (int)centerY, (float)radiusStart, (float)radiusEnd));
        animatorWrapper.setInterpolator(INTERPOLATOR);
        animatorWrapper.removeFeature(6);
        return animatorWrapper;
    }

    public final void setMode(int mode) {
        this.mMode = mode;
    }

    public final int getMode() {
        return this.mMode;
    }

    public void setStartRadius(@Nullable Float radius) {
        this.mStartRadius = radius;
    }

    @Nullable
    public Float getStartRadius() {
        return this.mStartRadius;
    }

    public void setEndRadius(@Nullable Float radius) {
        this.mEndRadius = radius;
    }

    @Nullable
    public Float getEndRadius() {
        return this.mEndRadius;
    }

    public void setStartVisibility(int visibility) {
        this.mStartVisibility = visibility;
    }

    public int getStartVisibility() {
        return this.mStartVisibility;
    }

    public void setEndVisibility(int visibility) {
        this.mEndVisibility = visibility;
    }

    public int getEndVisibility() {
        return this.mEndVisibility;
    }

    public void setAppearVisibility(int visibility) {
        this.mAppearVisibility = visibility;
    }

    public int getAppearVisibility() {
        return this.mAppearVisibility;
    }

    public void setDisappearVisibility(int visibility) {
        this.mDisappearVisibility = visibility;
    }

    public int getDisappearVisibility() {
        return this.mDisappearVisibility;
    }

    public void setCenterGravity(@Nullable Integer gravity) {
        this.mCenterGravity = gravity;
    }

    @Nullable
    public Integer getCenterGravity() {
        return this.mCenterGravity;
    }

    public void setCenterHorizontalOffset(int offset) {
        this.mCenterHorizontalOffset = offset;
    }

    public int getCenterHorizontalOffset() {
        return this.mCenterHorizontalOffset;
    }

    public void setCenterVerticalOffset(int offset) {
        this.mCenterVerticalOffset = offset;
    }

    public int getCenterVerticalOffset() {
        return this.mCenterVerticalOffset;
    }

    public void setCenterX(@Nullable Float centerX) {
        this.mCenterX = centerX;
    }

    @Nullable
    public Float getCenterX() {
        return this.mCenterX;
    }

    public void setCenterY(@Nullable Float centerY) {
        this.mCenterY = centerY;
    }

    @Nullable
    public Float getCenterY() {
        return this.mCenterY;
    }

    public void setCenterXFraction(@FloatRange(from=0.0, to=1.0) float fractionX) {
        this.mCenterXFraction = Math.max(0.0f, Math.min(1.0f, fractionX));
    }

    @FloatRange(from=0.0, to=1.0)
    public float getCenterXFraction() {
        return this.mCenterXFraction;
    }

    public void setCenterYFraction(@FloatRange(from=0.0, to=1.0) float fractionY) {
        this.mCenterYFraction = Math.max(0.0f, Math.min(1.0f, fractionY));
    }

    @FloatRange(from=0.0, to=1.0)
    public float getCenterYFraction() {
        return this.mCenterYFraction;
    }

    @Nullable
    public Animator onAppear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        this.calculateTransitionProperties(view);
        Animator animator = this.createAnimatorFromInfo(view);
        if (animator == null) {
            return null;
        }
        animator.addListener((Animator.AnimatorListener)new TransitionAnimatorListener(view, this.mStartVisibility, this.mEndVisibility));
        view.setVisibility(this.mAppearVisibility);
        return animator;
    }

    @Nullable
    public Animator onDisappear(@NonNull ViewGroup sceneRoot, @NonNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        this.calculateTransitionProperties(view);
        Animator animator = this.createAnimatorFromInfo(view);
        if (animator == null) {
            return null;
        }
        animator.addListener((Animator.AnimatorListener)new TransitionAnimatorListener(view, this.mStartVisibility, this.mEndVisibility));
        view.setVisibility(this.mDisappearVisibility);
        return animator;
    }

    @VisibleForTesting
    void calculateTransitionProperties(View view) {
        float[] center = this.mCenterGravity == null ? Reveal.resolveCenter(view, this.mCenterXFraction, this.mCenterYFraction) : this.resolveGravityCenter(view);
        float centerX = this.mCenterX == null ? center[0] : this.mCenterX.floatValue();
        float centerY = this.mCenterY == null ? center[1] : this.mCenterY.floatValue();
        this.mInfo.centerX = centerX + (float)this.mCenterHorizontalOffset;
        this.mInfo.centerY = centerY + (float)this.mCenterVerticalOffset;
        float[] radii = this.calculateTransitionRadii(view);
        this.mInfo.startRadius = this.mStartRadius == null ? radii[0] : this.mStartRadius.floatValue();
        this.mInfo.endRadius = this.mEndRadius == null ? radii[1] : this.mEndRadius.floatValue();
    }

    @NonNull
    @VisibleForTesting
    final Info getInfo() {
        return this.mInfo;
    }

    @SuppressLint(value={"RtlHardcoded"})
    private float[] resolveGravityCenter(View view) {
        float[] center = new float[]{0.0f, 0.0f};
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        int layoutDirection = view.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity((int)this.mCenterGravity, (int)layoutDirection);
        int horizontalGravity = absoluteGravity & 7;
        int verticalGravity = this.mCenterGravity & 0x70;
        switch (horizontalGravity) {
            case 1: {
                center[0] = (float)viewWidth / 2.0f;
                break;
            }
            case 5: {
                center[0] = viewWidth;
                break;
            }
            default: {
                center[0] = 0.0f;
            }
        }
        switch (verticalGravity) {
            case 16: {
                center[1] = (float)viewHeight / 2.0f;
                break;
            }
            case 80: {
                center[1] = viewHeight;
                break;
            }
            default: {
                center[1] = 0.0f;
            }
        }
        return center;
    }

    private float[] calculateTransitionRadii(View view) {
        float endRadius;
        float startRadius;
        switch (this.mMode) {
            case 2: {
                startRadius = this.calculateTransitionRadius(view);
                endRadius = 0.0f;
                break;
            }
            default: {
                startRadius = 0.0f;
                endRadius = this.calculateTransitionRadius(view);
            }
        }
        return new float[]{startRadius, endRadius};
    }

    private float calculateTransitionRadius(View view) {
        float centerX = this.mInfo.centerX;
        float centerY = this.mInfo.centerY;
        float viewWidth = view.getWidth();
        float viewHeight = view.getHeight();
        float[] viewCenter = Reveal.resolveCenter(view);
        float horizontalDistance = centerX >= viewCenter[0] ? centerX / viewWidth * viewWidth : (1.0f - centerX / viewWidth) * viewWidth;
        float verticalDistance = centerY >= viewCenter[1] ? centerY / viewHeight * viewHeight : (1.0f - centerY / viewHeight) * viewHeight;
        return Reveal.calculateRadius(horizontalDistance, verticalDistance);
    }

    @Nullable
    private Animator createAnimatorFromInfo(View view) {
        return Reveal.createAnimator(view, Math.round(this.mInfo.centerX), Math.round(this.mInfo.centerY), this.mInfo.startRadius, this.mInfo.endRadius);
    }

    @VisibleForTesting
    static final class TransitionAnimatorListener
    extends AnimatorListenerAdapter {
        private final View animatingView;
        private final int visibilityStart;
        private final int visibilityEnd;

        TransitionAnimatorListener(View animatingView, int visibilityStart, int visibilityEnd) {
            this.animatingView = animatingView;
            this.visibilityStart = visibilityStart;
            this.visibilityEnd = visibilityEnd;
        }

        public void onAnimationStart(@NonNull Animator animation) {
            this.animatingView.setVisibility(this.visibilityStart);
        }

        public void onAnimationEnd(@NonNull Animator animation) {
            this.animatingView.setVisibility(this.visibilityEnd);
        }
    }

    @VisibleForTesting
    static final class Info {
        float startRadius;
        float endRadius;
        float centerX;
        float centerY;

        Info() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RevealMode {
    }
}

