/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.transition.Transition;
import android.transition.TransitionInflater;
import android.transition.TransitionManager;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BaseNavigationalTransition<T extends BaseNavigationalTransition> {
    public static final boolean MATERIAL_SUPPORT = Build.VERSION.SDK_INT >= 21;
    public static final int RC_NONE = -1;
    private static final int TRANSITION_ENTER = 1;
    private static final int TRANSITION_REENTER = 2;
    private static final int TRANSITION_RETURN = 4;
    private static final int TRANSITION_EXIT = 8;
    private static final int TRANSITION_SHARED_ELEMENT_ENTER = 16;
    private static final int TRANSITION_SHARED_ELEMENT_REENTER = 32;
    private static final int TRANSITION_SHARED_ELEMENT_RETURN = 64;
    private static final int TRANSITION_SHARED_ELEMENT_EXIT = 128;
    protected final Class<? extends Activity> mClassOfTransitionActivity;
    private Bundle mIntentExtras;
    int mRequestCode = -1;
    private Transition mEnterTransition;
    private Transition mReenterTransition;
    private Transition mReturnTransition;
    private Transition mExitTransition;
    private Transition mSharedElementEnterTransition;
    private Transition mSharedElementReenterTransition;
    private Transition mSharedElementReturnTransition;
    private Transition mSharedElementExitTransition;
    private int mSpecifiedTransitions;
    private Boolean mAllowEnterTransitionOverlap;
    private Boolean mAllowReturnTransitionOverlap;
    private List<Pair<View, String>> mSharedElements;
    private Boolean mSharedElementUseOverlay;
    private TransitionInflater mTransitionInflater;

    public BaseNavigationalTransition() {
        this.mClassOfTransitionActivity = null;
    }

    public BaseNavigationalTransition(@NonNull Class<? extends Activity> classOfTransitionActivity) {
        this.mClassOfTransitionActivity = classOfTransitionActivity;
    }

    @Nullable
    public final Class<? extends Activity> getActivityClass() {
        return this.mClassOfTransitionActivity;
    }

    public T intentExtras(@Nullable Bundle extras) {
        this.mIntentExtras = extras;
        return (T)this;
    }

    @NonNull
    public Bundle intentExtras() {
        return this.mIntentExtras == null ? (this.mIntentExtras = new Bundle()) : this.mIntentExtras;
    }

    public T requestCode(@IntRange(from=-1L) int requestCode) {
        this.mRequestCode = requestCode;
        return (T)this;
    }

    @IntRange(from=-1L)
    public int requestCode() {
        return this.mRequestCode;
    }

    public T enterTransition(@Nullable Transition transition) {
        this.mSpecifiedTransitions |= 1;
        this.mEnterTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition enterTransition() {
        return this.mEnterTransition;
    }

    public T reenterTransition(@Nullable Transition transition) {
        this.mSpecifiedTransitions |= 2;
        this.mReenterTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition reenterTransition() {
        return this.mReenterTransition;
    }

    public T returnTransition(@Nullable Transition transition) {
        this.mSpecifiedTransitions |= 4;
        this.mReturnTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition returnTransition() {
        return this.mReturnTransition;
    }

    public T exitTransition(@Nullable Transition transition) {
        this.mSpecifiedTransitions |= 8;
        this.mExitTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition exitTransition() {
        return this.mExitTransition;
    }

    public T allowEnterTransitionOverlap(boolean allow) {
        this.mAllowEnterTransitionOverlap = allow;
        return (T)this;
    }

    public boolean allowEnterTransitionOverlap() {
        return this.mAllowEnterTransitionOverlap == null || this.mAllowEnterTransitionOverlap != false;
    }

    public T allowReturnTransitionOverlap(boolean allow) {
        this.mAllowReturnTransitionOverlap = allow;
        return (T)this;
    }

    public boolean allowReturnTransitionOverlap() {
        return this.mAllowReturnTransitionOverlap == null || this.mAllowReturnTransitionOverlap != false;
    }

    public T sharedElementEnterTransition(@Nullable Transition transition) {
        this.mSpecifiedTransitions |= 0x10;
        this.mSharedElementEnterTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition sharedElementEnterTransition() {
        return this.mSharedElementEnterTransition;
    }

    public T sharedElementReenterTransition(@Nullable Transition transition) {
        this.mSpecifiedTransitions |= 0x20;
        this.mSharedElementReenterTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition sharedElementReenterTransition() {
        return this.mSharedElementReenterTransition;
    }

    public T sharedElementReturnTransition(@Nullable Transition transition) {
        this.mSpecifiedTransitions |= 0x40;
        this.mSharedElementReturnTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition sharedElementReturnTransition() {
        return this.mSharedElementReturnTransition;
    }

    public T sharedElementExitTransition(@Nullable Transition transition) {
        this.mSpecifiedTransitions |= 0x80;
        this.mSharedElementExitTransition = transition;
        return (T)this;
    }

    @Nullable
    public Transition sharedElementExitTransition() {
        return this.mSharedElementExitTransition;
    }

    public T sharedElementsUseOverlay(boolean useOverlay) {
        this.mSharedElementUseOverlay = useOverlay;
        return (T)this;
    }

    public boolean sharedElementsUseOverlay() {
        return this.mSharedElementUseOverlay == null || this.mSharedElementUseOverlay != false;
    }

    @Nullable
    @SuppressLint(value={"NewApi"})
    public Transition inflateTransition(@NonNull Context context, int resource) {
        if (MATERIAL_SUPPORT) {
            if (this.mTransitionInflater == null) {
                this.mTransitionInflater = TransitionInflater.from((Context)context);
            }
            return this.mTransitionInflater.inflateTransition(resource);
        }
        return null;
    }

    @Nullable
    @SuppressLint(value={"NewApi"})
    public TransitionManager inflateTransitionManager(@NonNull Context context, int resource, @NonNull ViewGroup sceneRoot) {
        if (MATERIAL_SUPPORT) {
            if (this.mTransitionInflater == null) {
                this.mTransitionInflater = TransitionInflater.from((Context)context);
            }
            return this.mTransitionInflater.inflateTransitionManager(resource, sceneRoot);
        }
        return null;
    }

    @SafeVarargs
    public final T sharedElements(Pair<View, String> ... elements) {
        if (this.mSharedElements == null) {
            this.mSharedElements = new ArrayList<Pair<View, String>>(1);
        }
        this.mSharedElements.addAll(Arrays.asList(elements));
        return (T)this;
    }

    public T sharedElement(@NonNull View element, @NonNull String elementName) {
        if (this.mSharedElements == null) {
            this.mSharedElements = new ArrayList<Pair<View, String>>(1);
        }
        this.mSharedElements.add((Pair<View, String>)new Pair((Object)element, (Object)elementName));
        return (T)this;
    }

    @Nullable
    public List<Pair<View, String>> sharedElements() {
        return this.mSharedElements;
    }

    @Nullable
    public Pair<View, String> singleSharedElement() {
        return this.mSharedElements == null || this.mSharedElements.isEmpty() ? null : this.mSharedElements.get(0);
    }

    public void start(@NonNull Activity caller) {
        this.configureOutgoingTransitions(caller);
        this.onStart(caller);
    }

    @SuppressLint(value={"NewApi"})
    protected void onStart(@NonNull Activity caller) {
        Intent intent = this.createIntent(caller);
        if (MATERIAL_SUPPORT) {
            Bundle options = this.makeSceneTransitionAnimation(caller).toBundle();
            if (this.mRequestCode == -1) {
                caller.startActivity(intent, options);
            } else {
                caller.startActivityForResult(intent, this.mRequestCode, options);
            }
        } else if (this.mRequestCode == -1) {
            caller.startActivity(intent);
        } else {
            caller.startActivityForResult(intent, this.mRequestCode);
        }
    }

    protected void finishCallerDelayed(final @NonNull Activity caller, @IntRange(from=0L) long delay) {
        View decorView = caller.getWindow().getDecorView();
        if (decorView != null) {
            decorView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 17 && caller.isDestroyed()) {
                        return;
                    }
                    if (caller.isFinishing()) {
                        return;
                    }
                    BaseNavigationalTransition.this.onFinishCaller(caller);
                }
            }, delay);
        }
    }

    protected void finishCaller(@NonNull Activity caller) {
        this.onFinishCaller(caller);
    }

    @SuppressLint(value={"NewApi"})
    protected void onFinishCaller(@NonNull Activity caller) {
        if (MATERIAL_SUPPORT) {
            caller.finishAfterTransition();
        } else {
            caller.finish();
        }
    }

    public void configureTransitions(@NonNull Activity activity) {
        this.configureIncomingTransitions(activity);
        this.configureOutgoingTransitions(activity);
    }

    public void configureIncomingTransitions(@NonNull Activity activity) {
        if (MATERIAL_SUPPORT) {
            Window window = activity.getWindow();
            if ((this.mSpecifiedTransitions & 1) != 0) {
                window.setEnterTransition(this.mEnterTransition);
            }
            if ((this.mSpecifiedTransitions & 4) != 0) {
                window.setReturnTransition(this.mReturnTransition);
            }
            if ((this.mSpecifiedTransitions & 0x10) != 0) {
                window.setSharedElementEnterTransition(this.mSharedElementEnterTransition);
            }
            if ((this.mSpecifiedTransitions & 0x40) != 0) {
                window.setSharedElementReturnTransition(this.mSharedElementReturnTransition);
            }
            if (this.mAllowEnterTransitionOverlap != null) {
                window.setAllowEnterTransitionOverlap(this.mAllowEnterTransitionOverlap.booleanValue());
            }
            if (this.mAllowReturnTransitionOverlap != null) {
                window.setAllowReturnTransitionOverlap(this.mAllowReturnTransitionOverlap.booleanValue());
            }
            if (this.mSharedElementUseOverlay != null) {
                window.setSharedElementsUseOverlay(this.mSharedElementUseOverlay.booleanValue());
            }
        }
    }

    public void configureOutgoingTransitions(@NonNull Activity activity) {
        if (MATERIAL_SUPPORT) {
            Window window = activity.getWindow();
            if ((this.mSpecifiedTransitions & 2) != 0) {
                window.setReenterTransition(this.mReenterTransition);
            }
            if ((this.mSpecifiedTransitions & 8) != 0) {
                window.setExitTransition(this.mExitTransition);
            }
            if ((this.mSpecifiedTransitions & 0x20) != 0) {
                window.setSharedElementReenterTransition(this.mSharedElementReenterTransition);
            }
            if ((this.mSpecifiedTransitions & 0x80) != 0) {
                window.setSharedElementExitTransition(this.mSharedElementExitTransition);
            }
            if (this.mSharedElementUseOverlay != null) {
                window.setSharedElementsUseOverlay(this.mSharedElementUseOverlay.booleanValue());
            }
        }
    }

    @Nullable
    @SuppressLint(value={"NewApi"})
    public ActivityOptions makeSceneTransitionAnimation(@NonNull Activity caller) {
        if (MATERIAL_SUPPORT) {
            if (this.mSharedElements != null && !this.mSharedElements.isEmpty()) {
                Pair[] pairs = new Pair[this.mSharedElements.size()];
                this.mSharedElements.toArray(pairs);
                return ActivityOptions.makeSceneTransitionAnimation((Activity)caller, (Pair[])pairs);
            }
            return ActivityOptions.makeSceneTransitionAnimation((Activity)caller, (Pair[])new Pair[0]);
        }
        return null;
    }

    @NonNull
    public Intent createIntent(@NonNull Activity caller) {
        if (this.mClassOfTransitionActivity == null) {
            throw new UnsupportedOperationException("Navigational transition(" + this.getClass().getSimpleName() + ") does not have any class of intended activity specified.");
        }
        Intent intent = new Intent((Context)caller, this.mClassOfTransitionActivity);
        if (this.mIntentExtras != null) {
            intent.putExtras(this.mIntentExtras);
        }
        return intent;
    }

    public void finish(@NonNull Activity caller) {
        this.onFinish(caller);
    }

    @SuppressLint(value={"NewApi"})
    protected void onFinish(@NonNull Activity caller) {
        if (MATERIAL_SUPPORT) {
            caller.finishAfterTransition();
        } else {
            caller.finish();
        }
    }
}

