/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition;

import android.app.Activity;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.AnimRes;
import android.support.annotation.NonNull;
import universum.studios.android.transition.WindowTransition;

public class BasicWindowTransition
implements WindowTransition {
    public static final Parcelable.Creator<BasicWindowTransition> CREATOR = new Parcelable.Creator<BasicWindowTransition>(){

        public BasicWindowTransition createFromParcel(@NonNull Parcel source) {
            return new BasicWindowTransition(source);
        }

        public BasicWindowTransition[] newArray(int size) {
            return new BasicWindowTransition[size];
        }
    };
    private final int mStartEnterAnimRes;
    private final int mStartExitAnimRes;
    private final int mFinishEnterAnimRes;
    private final int mFinishExitAnimRes;
    private final String mName;

    public BasicWindowTransition(@AnimRes int enterAnim, @AnimRes int exitAnim) {
        this(enterAnim, exitAnim, 0, 0);
    }

    public BasicWindowTransition(@AnimRes int startEnterAnim, @AnimRes int startExitAnim, @AnimRes int finishEnterAnim, @AnimRes int finishExitAnim) {
        this(startEnterAnim, startExitAnim, finishEnterAnim, finishExitAnim, "UNSPECIFIED");
    }

    public BasicWindowTransition(@AnimRes int startEnterAnim, @AnimRes int startExitAnim, @AnimRes int finishEnterAnim, @AnimRes int finishExitAnim, @NonNull String name) {
        this.mStartEnterAnimRes = startEnterAnim;
        this.mStartExitAnimRes = startExitAnim;
        this.mFinishEnterAnimRes = finishEnterAnim;
        this.mFinishExitAnimRes = finishExitAnim;
        this.mName = name;
    }

    protected BasicWindowTransition(@NonNull Parcel source) {
        this.mStartEnterAnimRes = source.readInt();
        this.mStartExitAnimRes = source.readInt();
        this.mFinishEnterAnimRes = source.readInt();
        this.mFinishExitAnimRes = source.readInt();
        this.mName = source.readString();
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mStartEnterAnimRes);
        dest.writeInt(this.mStartExitAnimRes);
        dest.writeInt(this.mFinishEnterAnimRes);
        dest.writeInt(this.mFinishExitAnimRes);
        dest.writeString(this.mName);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    @AnimRes
    public int getStartEnterAnimation() {
        return this.mStartEnterAnimRes;
    }

    @Override
    @AnimRes
    public int getStartExitAnimation() {
        return this.mStartExitAnimRes;
    }

    @Override
    @AnimRes
    public int getFinishEnterAnimation() {
        return this.mFinishEnterAnimRes;
    }

    @Override
    @AnimRes
    public int getFinishExitAnimation() {
        return this.mFinishExitAnimRes;
    }

    @Override
    @NonNull
    public String getName() {
        return this.mName;
    }

    @Override
    public void overrideStart(@NonNull Activity activity) {
        activity.overridePendingTransition(this.mStartEnterAnimRes, this.mStartExitAnimRes);
    }

    @Override
    public void overrideFinish(@NonNull Activity activity) {
        activity.overridePendingTransition(this.mFinishEnterAnimRes, this.mFinishExitAnimRes);
    }
}

