/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition.util;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

@TargetApi(value=11)
public class AnimatorWrapper
extends Animator {
    public static final int START = 1;
    public static final int PAUSE = 2;
    public static final int RESUME = 4;
    public static final int END = 8;
    public static final int CANCEL = 16;
    public static final int ALL = 31;
    protected final Animator mAnimator;
    private int mFeatures = 31;
    private ArrayMap<Animator.AnimatorListener, AnimatorListenerWrapper> mListenerWrappers;
    private ArrayMap<Animator.AnimatorPauseListener, AnimatorPauseListenerWrapper> mPauseListenerWrappers;

    public AnimatorWrapper(@NonNull Animator animator) {
        this.mAnimator = animator;
    }

    public void requestFeatures(int features) {
        this.mFeatures = features;
    }

    public void requestFeature(int feature) {
        this.mFeatures |= feature;
    }

    public void removeFeature(int feature) {
        this.mFeatures &= ~feature;
    }

    public boolean hasFeature(int feature) {
        return (this.mFeatures & feature) != 0;
    }

    public void addListener(Animator.AnimatorListener listener) {
        this.ensureListenerWrappers();
        if (!this.mListenerWrappers.containsKey((Object)listener)) {
            AnimatorListenerWrapper wrapper = new AnimatorListenerWrapper(listener, (Animator)this);
            this.mListenerWrappers.put((Object)listener, (Object)wrapper);
            this.mAnimator.addListener((Animator.AnimatorListener)wrapper);
        }
    }

    public void removeListener(Animator.AnimatorListener listener) {
        this.ensureListenerWrappers();
        AnimatorListenerWrapper wrapper = (AnimatorListenerWrapper)this.mListenerWrappers.get((Object)listener);
        if (wrapper != null) {
            this.mListenerWrappers.remove((Object)listener);
            this.mAnimator.removeListener((Animator.AnimatorListener)wrapper);
        }
    }

    private void ensureListenerWrappers() {
        if (this.mListenerWrappers == null) {
            this.mListenerWrappers = new ArrayMap(1);
        }
    }

    public void addPauseListener(Animator.AnimatorPauseListener listener) {
        if (!this.hasFeature(2) && !this.hasFeature(4)) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        this.ensurePauseListenerWrappers();
        if (!this.mPauseListenerWrappers.containsKey((Object)listener)) {
            AnimatorPauseListenerWrapper wrapper = new AnimatorPauseListenerWrapper(listener, (Animator)this);
            this.mPauseListenerWrappers.put((Object)listener, (Object)wrapper);
            this.mAnimator.addPauseListener((Animator.AnimatorPauseListener)wrapper);
        }
    }

    public void removePauseListener(Animator.AnimatorPauseListener listener) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        this.ensurePauseListenerWrappers();
        AnimatorPauseListenerWrapper wrapper = (AnimatorPauseListenerWrapper)this.mPauseListenerWrappers.get((Object)listener);
        if (wrapper != null) {
            this.mPauseListenerWrappers.remove((Object)listener);
            this.mAnimator.removePauseListener((Animator.AnimatorPauseListener)wrapper);
        }
    }

    private void ensurePauseListenerWrappers() {
        if (this.mPauseListenerWrappers == null) {
            this.mPauseListenerWrappers = new ArrayMap(1);
        }
    }

    public ArrayList<Animator.AnimatorListener> getListeners() {
        return this.mListenerWrappers != null ? new ArrayList(this.mListenerWrappers.keySet()) : new ArrayList(0);
    }

    public void removeAllListeners() {
        if (this.mListenerWrappers != null) {
            this.mListenerWrappers.clear();
            this.mListenerWrappers = null;
        }
        if (this.mPauseListenerWrappers != null) {
            this.mPauseListenerWrappers.clear();
            this.mPauseListenerWrappers = null;
        }
        this.mAnimator.removeAllListeners();
    }

    public void setStartDelay(long startDelay) {
        this.mAnimator.setStartDelay(startDelay);
    }

    public long getStartDelay() {
        return this.mAnimator.getStartDelay();
    }

    public Animator setDuration(long duration) {
        this.mAnimator.setDuration(duration);
        return this;
    }

    public long getDuration() {
        return this.mAnimator.getDuration();
    }

    public void setInterpolator(TimeInterpolator interpolator) {
        this.mAnimator.setInterpolator(interpolator);
    }

    @TargetApi(value=18)
    public TimeInterpolator getInterpolator() {
        return Build.VERSION.SDK_INT >= 18 ? this.mAnimator.getInterpolator() : null;
    }

    public void setTarget(Object target) {
        this.mAnimator.setTarget(target);
    }

    public void start() {
        if (!this.hasFeature(1)) {
            return;
        }
        this.mAnimator.start();
    }

    public boolean isStarted() {
        return Build.VERSION.SDK_INT >= 14 && this.mAnimator.isStarted();
    }

    public void pause() {
        if (!this.hasFeature(2)) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        this.mAnimator.pause();
    }

    public boolean isPaused() {
        return Build.VERSION.SDK_INT >= 19 && this.mAnimator.isPaused();
    }

    public void resume() {
        if (!this.hasFeature(2) && !this.hasFeature(4)) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        this.mAnimator.resume();
    }

    public void end() {
        if (!this.hasFeature(1) && !this.hasFeature(8)) {
            return;
        }
        this.mAnimator.end();
    }

    public void cancel() {
        if (!this.hasFeature(1) && !this.hasFeature(16)) {
            return;
        }
        this.mAnimator.cancel();
    }

    public boolean isRunning() {
        return this.mAnimator.isRunning();
    }

    @TargetApi(value=19)
    private static final class AnimatorPauseListenerWrapper
    extends BaseAnimatorListenerWrapper<Animator.AnimatorPauseListener>
    implements Animator.AnimatorPauseListener {
        AnimatorPauseListenerWrapper(Animator.AnimatorPauseListener listener, Animator animatorWrapper) {
            super(listener, animatorWrapper);
        }

        public void onAnimationPause(Animator animation) {
            ((Animator.AnimatorPauseListener)this.listener).onAnimationPause(this.animatorWrapper);
        }

        public void onAnimationResume(Animator animation) {
            ((Animator.AnimatorPauseListener)this.listener).onAnimationResume(this.animatorWrapper);
        }
    }

    private static final class AnimatorListenerWrapper
    extends BaseAnimatorListenerWrapper<Animator.AnimatorListener>
    implements Animator.AnimatorListener {
        AnimatorListenerWrapper(Animator.AnimatorListener listener, Animator animatorWrapper) {
            super(listener, animatorWrapper);
        }

        public void onAnimationStart(Animator animation) {
            ((Animator.AnimatorListener)this.listener).onAnimationStart(this.animatorWrapper);
        }

        public void onAnimationEnd(Animator animation) {
            ((Animator.AnimatorListener)this.listener).onAnimationEnd(this.animatorWrapper);
        }

        public void onAnimationCancel(Animator animation) {
            ((Animator.AnimatorListener)this.listener).onAnimationCancel(this.animatorWrapper);
        }

        public void onAnimationRepeat(Animator animation) {
            ((Animator.AnimatorListener)this.listener).onAnimationRepeat(this.animatorWrapper);
        }
    }

    private static abstract class BaseAnimatorListenerWrapper<L> {
        final L listener;
        final Animator animatorWrapper;

        BaseAnimatorListenerWrapper(L listener, Animator animatorWrapper) {
            this.listener = listener;
            this.animatorWrapper = animatorWrapper;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WrapperFeatures {
    }
}

