/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.transition.R;

@TargetApi(value=21)
public class Scale
extends Visibility {
    public static final String PROPERTY_SCALE_X = "scaleX";
    public static final String PROPERTY_SCALE_Y = "scaleY";
    private final Info mInfo = new Info();
    private Float mPivotX;
    private Float mPivotY;
    private float mPivotXFraction = 0.5f;
    private float mPivotYFraction = 0.5f;

    public Scale() {
        this(3);
    }

    public Scale(int mode) {
        this.setMode(mode);
    }

    public Scale(@NonNull Context context, @NonNull AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.Ui_Transition_Scale, 0, 0);
        int n = typedArray.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int index = typedArray.getIndex(i);
            if (index == R.styleable.Ui_Transition_Scale_android_pivotX) {
                this.mPivotXFraction = typedArray.getFraction(index, 1, 1, this.mPivotXFraction);
                continue;
            }
            if (index == R.styleable.Ui_Transition_Scale_android_pivotY) {
                this.mPivotYFraction = typedArray.getFraction(index, 1, 1, this.mPivotYFraction);
                continue;
            }
            if (index == R.styleable.Ui_Transition_Scale_android_transformPivotX) {
                this.mPivotX = Float.valueOf(typedArray.getDimensionPixelSize(index, 0));
                continue;
            }
            if (index != R.styleable.Ui_Transition_Scale_android_transformPivotY) continue;
            this.mPivotY = Float.valueOf(typedArray.getDimensionPixelSize(index, 0));
        }
        typedArray.recycle();
    }

    @NonNull
    public static Animator createAnimator(@NonNull View view, @FloatRange(from=0.0, to=1.0) float startScale, @FloatRange(from=0.0, to=1.0) float endScale) {
        return ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)PROPERTY_SCALE_X, (float[])new float[]{startScale, endScale}), PropertyValuesHolder.ofFloat((String)PROPERTY_SCALE_Y, (float[])new float[]{startScale, endScale})});
    }

    public void setPivotX(@Nullable Float pivotX) {
        this.mPivotX = pivotX;
    }

    @Nullable
    public Float getPivotX() {
        return this.mPivotX;
    }

    public void setPivotY(@Nullable Float pivotY) {
        this.mPivotY = pivotY;
    }

    @Nullable
    public Float getPivotY() {
        return this.mPivotY;
    }

    public void setPivotXFraction(@FloatRange(from=0.0, to=1.0) float fractionX) {
        this.mPivotXFraction = fractionX;
    }

    @FloatRange(from=0.0, to=1.0)
    public float getPivotXFraction() {
        return this.mPivotXFraction;
    }

    public void setPivotYFraction(@FloatRange(from=0.0, to=1.0) float fractionY) {
        this.mPivotYFraction = fractionY;
    }

    @FloatRange(from=0.0, to=1.0)
    public float getPivotYFraction() {
        return this.mPivotYFraction;
    }

    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        this.calculateTransitionProperties(view, 0.0f, 1.0f);
        view.setPivotX(this.mInfo.pivotX);
        view.setPivotY(this.mInfo.pivotY);
        view.setScaleX(this.mInfo.startScale);
        view.setScaleY(this.mInfo.startScale);
        return Scale.createAnimator(view, this.mInfo.startScale, this.mInfo.endScale);
    }

    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        this.calculateTransitionProperties(view, 1.0f, 0.0f);
        view.setPivotX(this.mInfo.pivotX);
        view.setPivotY(this.mInfo.pivotY);
        view.setScaleX(this.mInfo.startScale);
        view.setScaleY(this.mInfo.startScale);
        return Scale.createAnimator(view, this.mInfo.startScale, this.mInfo.endScale);
    }

    private void calculateTransitionProperties(View view, float startScale, float endScale) {
        this.mInfo.startScale = startScale;
        this.mInfo.endScale = endScale;
        this.mInfo.pivotX = this.mPivotX != null ? this.mPivotX.floatValue() : (float)view.getWidth() * this.mPivotXFraction;
        this.mInfo.pivotY = this.mPivotY != null ? this.mPivotY.floatValue() : (float)view.getHeight() * this.mPivotYFraction;
    }

    private static final class Info {
        float startScale;
        float endScale;
        float pivotX;
        float pivotY;

        private Info() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScaleMode {
    }
}

