/*
 * *************************************************************************************************
 *                                 Copyright 2019 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
package universum.studios.android.test.matcher

import androidx.annotation.NonNull
import org.hamcrest.Matcher

/**
 * Convenience factory that may be used to create **class declaration** related matchers.
 *
 * @author Martin Albedinsky
 * @since 1.1
 */
object DeclarationMatchers {

    /**
     * Creates a matcher that matches if examined object implements the specified interface [clazz].
     *
     * **Note that the specified [clazz] must be actually an interface and not a simple class,
     * otherwise an exception is thrown.**
     *
     * For example:
     *
     * `assertThat(object, implements(SomeInterface::class))`
     *
     * @param clazz The desired interface class to expect.
     * @param T Type of the object to be examined.
     * @return Matcher ready to be used.
     */
    @NonNull @JvmStatic
    fun <T> implements(@NonNull clazz: Class<*>): Matcher<T> = ImplementsMatcher.implements(clazz)
}