/*
 * *************************************************************************************************
 *                                 Copyright 2019 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
package universum.studios.android.test

import android.content.Context
import androidx.annotation.NonNull
import androidx.test.core.app.ApplicationProvider
import androidx.test.ext.junit.runners.AndroidJUnit4
import org.junit.runner.RunWith

/**
 * Test case class that may be used to group **suite of Android tests** that are to be executed
 * either on a local *JVM* with shadowed *Android environment* or on an emulated/real *Android Device*.
 *
 * **Default runner:** [AndroidJUnit4]
 *
 * @author Martin Albedinsky
 * @since 1.0
 */
@RunWith(AndroidJUnit4::class) abstract class AndroidTestCase : TestCase() {

    /**
     * Application context instance obtained via [ApplicationProvider.getApplicationContext].
     */
    private var context: Context? = null

    /**
     * Returns application context instance obtained via [ApplicationProvider.getApplicationContext].
     *
     * @return Application context ready to be used.
     */
    @NonNull protected fun context(): Context {
        if (this.context == null) {
            this.context = ApplicationProvider.getApplicationContext()
        }
        return context!!
    }
}