/*
 * *************************************************************************************************
 *                                 Copyright 2019 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
package universum.studios.android.test.util

import org.mockito.Mockito

/**
 * **This class has been deprecated and will be removed in the 1.2.0 release.**
 * <p>
 * Utility class providing *Kotlin* specific, or rather compatible, argument matchers.
 *
 * @author Martin Albedinsky
 * @since 1.0
 */
@Deprecated(
        "Use KotlinArgumentMatchers from ..test.kotlin package.",
        ReplaceWith("KotlinArgumentMatchers", imports = ["universum.studios.android.test.kotlin"])
)
class KotlinArgumentMatchers private constructor() {

    /**
     */
    @Suppress("UNCHECKED_CAST") companion object {

        /**
         * Delegates to [Mockito.any] and returns uninitialized instance of the desired type.
         *
         * @param T Desired type.
         * @return Uninitialized instance of the type.
         */
        fun <T> any(): T = universum.studios.android.test.kotlin.KotlinArgumentMatchers.any()

        /**
         * Delegates to [Mockito.any] and returns uninitialized instance of the desired type.
         *
         * @param T Desired type.
         * @return Uninitialized instance of the type.
         */
        fun <T> any(type: Class<T>): T = universum.studios.android.test.kotlin.KotlinArgumentMatchers.any(type)

        /**
         * Delegates to [Mockito.eq] and returns uninitialized instance of the desired type.
         *
         * @param T Desired type.
         * @return Uninitialized instance of the the type.
         */
        fun <T> eq(value: T): T = universum.studios.android.test.kotlin.KotlinArgumentMatchers.eq(value)
    }

    /**
     */
    init {
        // Not allowed to be instantiated publicly.
        throw UnsupportedOperationException()
    }
}