/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.pager.adapter;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.util.LongSparseArray;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import java.util.Set;
import universum.studios.android.support.pager.adapter.PagerAdapterHelper;
import universum.studios.android.support.pager.adapter.PagerAdaptersLogging;

@SuppressLint(value={"LongLogTag"})
public abstract class FragmentStatePagerAdapter
extends PagerAdapter {
    private static final String TAG = "FragmentStatePagerAdapter";
    public static final int NO_POSITION = -1;
    public static final long NO_ID = -1L;
    @VisibleForTesting
    static final String STATE_FRAGMENT_STATES = FragmentStatePagerAdapter.class.getName() + ".STATE.FragmentStates";
    private final FragmentManager fragmentManager;
    private boolean makeItemTags = true;
    private FragmentTransaction pendingTransaction;
    private final LongSparseArray<Fragment> fragments = new LongSparseArray(5);
    private final LongSparseArray<Fragment.SavedState> savedStates = new LongSparseArray(5);
    private Fragment primaryItem;
    private int primaryPosition = -1;

    public FragmentStatePagerAdapter(@NonNull FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
    }

    public void startUpdate(@NonNull ViewGroup container) {
        if (container.getId() == -1) {
            throw new IllegalStateException("ViewPager with adapter " + (Object)((Object)this) + " requires a view id!");
        }
    }

    @SuppressLint(value={"CommitTransaction"})
    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        long itemId = this.getItemId(position);
        Fragment fragment = (Fragment)this.fragments.get(itemId);
        if (fragment != null) {
            return fragment;
        }
        if (this.pendingTransaction == null) {
            this.pendingTransaction = this.fragmentManager.beginTransaction();
        }
        fragment = this.getItem(position);
        Fragment.SavedState savedState = (Fragment.SavedState)this.savedStates.get(itemId);
        if (savedState != null) {
            fragment.setInitialSavedState(savedState);
        }
        fragment.setMenuVisibility(false);
        PagerAdapterHelper.setUserVisibleHint(fragment, false);
        this.fragments.put(itemId, (Object)fragment);
        PagerAdaptersLogging.d(TAG, "Adding item(id: " + itemId + ", fragment: " + fragment + ").");
        int containerId = container.getId();
        this.pendingTransaction.add(containerId, fragment, this.makeItemTag(containerId, itemId));
        return fragment;
    }

    protected final void setMakeItemTags(boolean makeItemTags) {
        this.makeItemTags = makeItemTags;
    }

    @Nullable
    protected String makeItemTag(@IdRes int containerId, long itemId) {
        return this.makeItemTags ? "android:pager:" + containerId + ":" + itemId : null;
    }

    public long getItemId(int position) {
        return position;
    }

    @NonNull
    public abstract Fragment getItem(int var1);

    public void setPrimaryItem(@NonNull ViewGroup container, int position, @Nullable Object object) {
        Fragment fragment = (Fragment)object;
        if (this.primaryItem != fragment) {
            this.primaryPosition = position;
            if (this.primaryItem != null) {
                this.primaryItem.setMenuVisibility(false);
                PagerAdapterHelper.setUserVisibleHint(this.primaryItem, false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                PagerAdapterHelper.setUserVisibleHint(fragment, true);
            }
            this.primaryItem = fragment;
        }
    }

    @Nullable
    public Fragment getPrimaryFragment() {
        return this.primaryItem;
    }

    @IntRange(from=-1L)
    public int getPrimaryPosition() {
        return this.primaryPosition;
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return ((Fragment)object).getView() == view;
    }

    @SuppressLint(value={"CommitTransaction"})
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        Fragment fragment;
        int itemIndex;
        if (this.pendingTransaction == null) {
            this.pendingTransaction = this.fragmentManager.beginTransaction();
        }
        if (position == this.primaryPosition) {
            this.primaryPosition = -1;
            this.primaryItem = null;
        }
        if ((itemIndex = this.fragments.indexOfValue((Object)(fragment = (Fragment)object))) >= 0) {
            long itemId = this.fragments.keyAt(itemIndex);
            PagerAdaptersLogging.d(TAG, "Removing item(id: " + itemId + ", fragment: " + fragment + ", view: " + fragment.getView() + ").");
            if (fragment.isAdded()) {
                this.savedStates.put(itemId, (Object)this.fragmentManager.saveFragmentInstanceState(fragment));
            } else {
                this.savedStates.remove(itemId);
            }
            this.fragments.remove(itemId);
        }
        this.pendingTransaction.remove(fragment);
    }

    public void finishUpdate(@NonNull ViewGroup container) {
        if (this.pendingTransaction != null) {
            PagerAdapterHelper.finishUpdate(this.fragmentManager, this.pendingTransaction);
            this.pendingTransaction = null;
        }
    }

    public Parcelable saveState() {
        Bundle state = null;
        int statesCount = this.savedStates.size();
        if (statesCount > 0) {
            state = new Bundle();
            long[] savedStateIds = new long[statesCount];
            for (int i = 0; i < statesCount; ++i) {
                long itemId;
                savedStateIds[i] = itemId = this.savedStates.keyAt(i);
                state.putParcelable("android:pager:fragment_state:" + itemId, (Parcelable)this.savedStates.valueAt(i));
            }
            state.putLongArray(STATE_FRAGMENT_STATES, savedStateIds);
        }
        for (int i = 0; i < this.fragments.size(); ++i) {
            long itemId = this.fragments.keyAt(i);
            Fragment fragment = (Fragment)this.fragments.get(itemId);
            if (!fragment.isAdded()) continue;
            if (state == null) {
                state = new Bundle();
            }
            this.fragmentManager.putFragment(state, "android:pager:fragment:" + itemId, fragment);
        }
        return state;
    }

    public void restoreState(@Nullable Parcelable state, @Nullable ClassLoader loader) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            bundle.setClassLoader(loader);
            long[] savedStateIds = bundle.getLongArray(STATE_FRAGMENT_STATES);
            this.savedStates.clear();
            this.fragments.clear();
            if (savedStateIds != null && savedStateIds.length > 0) {
                for (long itemId : savedStateIds) {
                    this.savedStates.put(itemId, (Object)bundle.getParcelable("android:pager:fragment_state:" + itemId));
                }
            }
            Set keys = bundle.keySet();
            for (String key : keys) {
                if (!key.startsWith("android:pager:fragment:")) continue;
                Fragment fragment = this.fragmentManager.getFragment(bundle, key);
                if (fragment == null) {
                    PagerAdaptersLogging.w(TAG, "Fragment not found for the key " + key + " when restoring adapter's state.");
                    continue;
                }
                fragment.setMenuVisibility(false);
                this.fragments.put(Long.parseLong(key.split(":")[3]), (Object)fragment);
            }
        }
    }
}

