/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.pager.adapter;

import android.annotation.SuppressLint;
import android.support.annotation.IdRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import universum.studios.android.support.pager.adapter.PagerAdapterHelper;
import universum.studios.android.support.pager.adapter.PagerAdaptersLogging;

public abstract class FragmentPagerAdapter
extends PagerAdapter {
    private static final String TAG = "FragmentPagerAdapter";
    public static final int NO_POSITION = -1;
    public static final long NO_ID = -1L;
    private final FragmentManager fragmentManager;
    private boolean makeItemTags = true;
    private FragmentTransaction pendingTransaction;
    private Fragment primaryItem;
    private int primaryPosition = -1;

    public FragmentPagerAdapter(@NonNull FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
    }

    public void startUpdate(@NonNull ViewGroup container) {
        if (container.getId() == -1) {
            throw new IllegalStateException("ViewPager with adapter " + (Object)((Object)this) + " requires a view id!");
        }
    }

    @SuppressLint(value={"CommitTransaction"})
    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        long itemId;
        int containerId;
        String tag;
        Fragment fragment;
        if (this.pendingTransaction == null) {
            this.pendingTransaction = this.fragmentManager.beginTransaction();
        }
        if ((fragment = this.fragmentManager.findFragmentByTag(tag = this.makeItemTag(containerId = container.getId(), itemId = this.getItemId(position)))) == null) {
            fragment = this.getItem(position);
            PagerAdaptersLogging.d(TAG, "Adding item(position: " + position + ", id: " + itemId + ", fragment: " + fragment + ").");
            this.pendingTransaction.add(containerId, fragment, tag);
        } else {
            PagerAdaptersLogging.d(TAG, "Attaching item(position: " + position + ", id: " + itemId + ", fragment: " + fragment + ").");
            this.pendingTransaction.attach(fragment);
        }
        if (!fragment.equals((Object)this.primaryItem)) {
            fragment.setMenuVisibility(false);
            PagerAdapterHelper.setUserVisibleHint(fragment, false);
        }
        return fragment;
    }

    protected final void setMakeItemTags(boolean makeItemTags) {
        this.makeItemTags = makeItemTags;
    }

    @Nullable
    protected String makeItemTag(@IdRes int containerId, long itemId) {
        return this.makeItemTags ? "android:pager:" + containerId + ":" + itemId : null;
    }

    public long getItemId(int position) {
        return position;
    }

    @NonNull
    public abstract Fragment getItem(int var1);

    public void setPrimaryItem(@NonNull ViewGroup container, int position, @Nullable Object object) {
        Fragment fragment = (Fragment)object;
        if (this.primaryItem != fragment) {
            this.primaryPosition = position;
            if (this.primaryItem != null) {
                this.primaryItem.setMenuVisibility(false);
                PagerAdapterHelper.setUserVisibleHint(this.primaryItem, false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                PagerAdapterHelper.setUserVisibleHint(fragment, true);
            }
            this.primaryItem = fragment;
        }
    }

    @Nullable
    public Fragment getPrimaryFragment() {
        return this.primaryItem;
    }

    @IntRange(from=-1L)
    public int getPrimaryPosition() {
        return this.primaryPosition;
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return ((Fragment)object).getView() == view;
    }

    @SuppressLint(value={"CommitTransaction"})
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        if (this.pendingTransaction == null) {
            this.pendingTransaction = this.fragmentManager.beginTransaction();
        }
        if (position == this.primaryPosition) {
            this.primaryPosition = -1;
            this.primaryItem = null;
        }
        PagerAdaptersLogging.d(TAG, "Detaching item(position: " + position + ", id: " + this.getItemId(position) + ", fragment: " + object + ", view: " + ((Fragment)object).getView() + ").");
        this.pendingTransaction.detach((Fragment)object);
    }

    public void finishUpdate(@NonNull ViewGroup container) {
        if (this.pendingTransaction != null) {
            PagerAdapterHelper.finishUpdate(this.fragmentManager, this.pendingTransaction);
            this.pendingTransaction = null;
        }
    }
}

