/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.support.pager.adapter;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;

/**
 * Helper class used by the Pager Adapters implementations.
 *
 * @author Martin Albedinsky
 */
final class PagerAdapterHelper {

	/**
	 * Sets a user visible hint for the given <var>fragment</var>.
	 *
	 * @param fragment Fragment for which to set user visible hint flag.
	 * @param visible  {@code True} to set user visible hint, {@code false} otherwise.
	 * @see Fragment#setUserVisibleHint(boolean)
	 */
	static void setUserVisibleHint(@NonNull Fragment fragment, boolean visible) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH_MR1) {
			fragment.setUserVisibleHint(visible);
		}
	}

	/**
	 * Finishes update for the given fragment <var>transaction</var>.
	 *
	 * @param transaction The fragment transaction to be committed in order to finish adapter's update.
	 * @see FragmentTransaction#commitNowAllowingStateLoss()
	 */
	static void finishUpdate(@NonNull FragmentTransaction transaction) {
		transaction.commitNowAllowingStateLoss();
	}

	/**
	 */
	private PagerAdapterHelper() {
		// Creation of instances of this class is not publicly allowed.
	}
}
