/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.pager.adapter;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.util.LongSparseArray;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.util.Set;
import universum.studios.android.support.pager.adapter.PagerAdapterHelper;
import universum.studios.android.support.pager.adapter.PagerAdaptersConfig;

@SuppressLint(value={"LongLogTag"})
public abstract class FragmentStatePagerAdapter
extends PagerAdapter {
    private static final String TAG = "FragmentStatePagerAdapter";
    private static final String STATE_FRAGMENT_STATES = FragmentStatePagerAdapter.class.getName() + ".STATE.FragmentStates";
    private final FragmentManager mFragmentManager;
    private boolean mMakeItemTags = true;
    private FragmentTransaction mPendingTransaction = null;
    private final LongSparseArray<Fragment> mFragments = new LongSparseArray(5);
    private final LongSparseArray<Fragment.SavedState> mSavedStates = new LongSparseArray(5);
    private Fragment mPrimaryItem = null;
    private int mPrimaryPosition = -1;

    public FragmentStatePagerAdapter(@NonNull FragmentManager fragmentManager) {
        this.mFragmentManager = fragmentManager;
    }

    public void startUpdate(ViewGroup container) {
        if (container.getId() == -1) {
            throw new IllegalStateException("ViewPager with adapter " + (Object)((Object)this) + " requires a view id!");
        }
    }

    @SuppressLint(value={"CommitTransaction"})
    public Object instantiateItem(ViewGroup container, int position) {
        long itemId = this.getItemId(position);
        Fragment fragment = (Fragment)this.mFragments.get(itemId);
        if (fragment != null) {
            return fragment;
        }
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        fragment = this.getItem(position);
        Fragment.SavedState savedState = (Fragment.SavedState)this.mSavedStates.get(itemId);
        if (savedState != null) {
            fragment.setInitialSavedState(savedState);
        }
        fragment.setMenuVisibility(false);
        PagerAdapterHelper.setUserVisibleHint(fragment, false);
        this.mFragments.put(itemId, (Object)fragment);
        if (PagerAdaptersConfig.DEBUG_LOG_ENABLED) {
            Log.v((String)TAG, (String)("Adding item(id: " + itemId + ", fragment: " + fragment + ")."));
        }
        int containerId = container.getId();
        this.mPendingTransaction.add(containerId, fragment, this.makeItemTag(containerId, itemId));
        return fragment;
    }

    protected final void setMakeItemTags(boolean makeItemTags) {
        this.mMakeItemTags = makeItemTags;
    }

    @Nullable
    protected String makeItemTag(@IdRes int containerId, long itemId) {
        return this.mMakeItemTags ? "android:pager:" + containerId + ":" + itemId : null;
    }

    public long getItemId(int position) {
        return position;
    }

    @NonNull
    public abstract Fragment getItem(int var1);

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (this.mPrimaryPosition != position && this.mPrimaryItem != fragment) {
            if (this.mPrimaryItem != null) {
                this.mPrimaryItem.setMenuVisibility(false);
                PagerAdapterHelper.setUserVisibleHint(this.mPrimaryItem, false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                PagerAdapterHelper.setUserVisibleHint(fragment, true);
            }
            this.mPrimaryItem = fragment;
        }
    }

    @Nullable
    public Fragment getPrimaryFragment() {
        return this.mPrimaryItem;
    }

    @IntRange(from=-1L)
    public int getPrimaryPosition() {
        return this.mPrimaryPosition;
    }

    public boolean isViewFromObject(View view, Object object) {
        return ((Fragment)object).getView() == view;
    }

    @SuppressLint(value={"CommitTransaction"})
    public void destroyItem(ViewGroup container, int position, Object object) {
        Fragment fragment;
        int itemIndex;
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        if ((itemIndex = this.mFragments.indexOfValue((Object)(fragment = (Fragment)object))) != -1) {
            long itemId = this.mFragments.keyAt(itemIndex);
            if (PagerAdaptersConfig.DEBUG_LOG_ENABLED) {
                Log.v((String)TAG, (String)("Removing item(id: " + itemId + ", fragment: " + fragment + ", view: " + fragment.getView() + ")."));
            }
            if (fragment.isAdded()) {
                this.mSavedStates.put(itemId, (Object)this.mFragmentManager.saveFragmentInstanceState(fragment));
            } else {
                this.mSavedStates.remove(itemId);
            }
            this.mFragments.remove(itemId);
        }
        this.mPendingTransaction.remove(fragment);
    }

    public void finishUpdate(ViewGroup container) {
        if (this.mPendingTransaction != null) {
            PagerAdapterHelper.finishUpdate(this.mPendingTransaction);
            this.mPendingTransaction = null;
        }
    }

    public Parcelable saveState() {
        Bundle state = null;
        int statesCount = this.mSavedStates.size();
        if (statesCount > 0) {
            state = new Bundle();
            long[] savedStateIds = new long[statesCount];
            for (int i = 0; i < statesCount; ++i) {
                Fragment.SavedState savedState = (Fragment.SavedState)this.mSavedStates.valueAt(i);
                savedStateIds[i] = this.mSavedStates.keyAt(i);
                state.putParcelable("android:pager:fragment:state:" + savedStateIds[i], (Parcelable)savedState);
            }
            state.putLongArray(STATE_FRAGMENT_STATES, savedStateIds);
        }
        for (int i = 0; i < this.mFragments.size(); ++i) {
            Fragment fragment = (Fragment)this.mFragments.get((long)i);
            if (fragment == null || !fragment.isAdded()) continue;
            if (state == null) {
                state = new Bundle();
            }
            this.mFragmentManager.putFragment(state, "android:pager:fragment:" + this.mFragments.keyAt(i), fragment);
        }
        return state;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        if (state != null) {
            Bundle bundle = (Bundle)state;
            bundle.setClassLoader(loader);
            long[] savedStateIds = bundle.getLongArray(STATE_FRAGMENT_STATES);
            this.mSavedStates.clear();
            this.mFragments.clear();
            if (savedStateIds != null && savedStateIds.length > 0) {
                for (long savedStateId : savedStateIds) {
                    this.mSavedStates.put(savedStateId, (Object)bundle.getParcelable("android:pager:fragment:state:" + savedStateId));
                }
            }
            Set keys = bundle.keySet();
            for (String key : keys) {
                if (!key.startsWith("android:pager:fragment:")) continue;
                Fragment fragment = this.mFragmentManager.getFragment(bundle, key);
                if (fragment != null) {
                    fragment.setMenuVisibility(false);
                    this.mFragments.put(Long.parseLong(key.split(":")[3]), (Object)fragment);
                    continue;
                }
                if (!PagerAdaptersConfig.LOG_ENABLED) continue;
                Log.w((String)TAG, (String)("Fragment not found for key " + key + " when restoring adapter's state."));
            }
        }
    }
}

