/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.pager.adapter;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import universum.studios.android.support.pager.adapter.FragmentPagerAdapter;
import universum.studios.android.support.pager.adapter.PagerAdaptersConfig;

@SuppressLint(value={"LongLogTag"})
public abstract class FragmentStatePagerAdapter
extends PagerAdapter {
    private static final String TAG = "FragmentStatePagerAdapter";
    private static final String BUNDLE_SAVED_STATES = "FragmentStatePagerAdapter.BUNDLE.SavedStates";
    private final FragmentManager mFragmentManager;
    private boolean mMakeItemTags = false;
    private FragmentTransaction mPendingTransaction = null;
    private final List<Fragment.SavedState> mSavedState = new ArrayList<Fragment.SavedState>(10);
    private final List<Fragment> mFragments = new ArrayList<Fragment>(10);
    Fragment mPrimaryItem = null;

    public FragmentStatePagerAdapter(@NonNull FragmentManager fragmentManager) {
        this.mFragmentManager = fragmentManager;
    }

    public void startUpdate(ViewGroup container) {
        if (container.getId() == -1) {
            throw new IllegalStateException("ViewPager with adapter " + (Object)((Object)this) + " requires a view id!");
        }
    }

    @SuppressLint(value={"CommitTransaction"})
    public Object instantiateItem(ViewGroup container, int position) {
        Fragment.SavedState fragmentSavedState;
        Fragment fragment;
        if (this.mFragments.size() > position && (fragment = this.mFragments.get(position)) != null) {
            return fragment;
        }
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        long itemId = this.getItemId(position);
        Fragment fragment2 = this.getItem(position);
        if (this.mSavedState.size() > position && (fragmentSavedState = this.mSavedState.get(position)) != null) {
            fragment2.setInitialSavedState(fragmentSavedState);
        }
        while (this.mFragments.size() <= position) {
            this.mFragments.add(null);
        }
        fragment2.setMenuVisibility(false);
        FragmentPagerAdapter.setUserVisibleHint(fragment2, false);
        this.mFragments.set(position, fragment2);
        if (PagerAdaptersConfig.DEBUG_LOG_ENABLED) {
            Log.v((String)TAG, (String)("Adding item(id: " + itemId + ", fragment: " + fragment2 + ")."));
        }
        int containerId = container.getId();
        this.mPendingTransaction.add(containerId, fragment2, this.makeItemTag(containerId, itemId));
        return fragment2;
    }

    protected final void setMakeItemTags(boolean makeItemTags) {
        this.mMakeItemTags = makeItemTags;
    }

    @Nullable
    protected String makeItemTag(@IdRes int containerId, long itemId) {
        return this.mMakeItemTags ? "android:pager:" + containerId + ":" + itemId : null;
    }

    public long getItemId(int position) {
        return position;
    }

    @NonNull
    public abstract Fragment getItem(int var1);

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (this.mPrimaryItem != fragment) {
            if (this.mPrimaryItem != null) {
                this.mPrimaryItem.setMenuVisibility(false);
                FragmentPagerAdapter.setUserVisibleHint(this.mPrimaryItem, false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                FragmentPagerAdapter.setUserVisibleHint(fragment, true);
            }
            this.mPrimaryItem = fragment;
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return ((Fragment)object).getView() == view;
    }

    @SuppressLint(value={"CommitTransaction"})
    public void destroyItem(ViewGroup container, int position, Object object) {
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        Fragment fragment = (Fragment)object;
        if (PagerAdaptersConfig.DEBUG_LOG_ENABLED) {
            Log.v((String)TAG, (String)("Removing item(id: " + this.getItemId(position) + ", fragment: " + fragment + ", view: " + fragment.getView() + ")."));
        }
        while (this.mSavedState.size() <= position) {
            this.mSavedState.add(null);
        }
        this.mSavedState.set(position, fragment.isAdded() ? this.mFragmentManager.saveFragmentInstanceState(fragment) : null);
        this.mFragments.set(position, null);
        this.mPendingTransaction.remove(fragment);
    }

    public void finishUpdate(ViewGroup container) {
        if (this.mPendingTransaction != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mPendingTransaction.commitNowAllowingStateLoss();
            } else {
                this.mPendingTransaction.commitAllowingStateLoss();
            }
            this.mPendingTransaction = null;
        }
    }

    public Parcelable saveState() {
        Bundle state = null;
        if (this.mSavedState.size() > 0) {
            state = new Bundle();
            Fragment.SavedState[] savedStates = new Fragment.SavedState[this.mSavedState.size()];
            this.mSavedState.toArray(savedStates);
            state.putParcelableArray(BUNDLE_SAVED_STATES, (Parcelable[])savedStates);
        }
        for (int i = 0; i < this.mFragments.size(); ++i) {
            Fragment fragment = this.mFragments.get(i);
            if (fragment == null || !fragment.isAdded()) continue;
            if (state == null) {
                state = new Bundle();
            }
            this.mFragmentManager.putFragment(state, "f" + i, fragment);
        }
        return state;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        if (state != null) {
            Bundle bundle = (Bundle)state;
            bundle.setClassLoader(loader);
            Parcelable[] savedStates = bundle.getParcelableArray(BUNDLE_SAVED_STATES);
            this.mSavedState.clear();
            this.mFragments.clear();
            if (savedStates != null && savedStates.length > 0) {
                for (Parcelable savedState : savedStates) {
                    this.mSavedState.add((Fragment.SavedState)savedState);
                }
            }
            Set keys = bundle.keySet();
            for (String key : keys) {
                if (!key.startsWith("f")) continue;
                int index = Integer.parseInt(key.substring(1));
                Fragment fragment = this.mFragmentManager.getFragment(bundle, key);
                if (fragment != null) {
                    while (this.mFragments.size() <= index) {
                        this.mFragments.add(null);
                    }
                    fragment.setMenuVisibility(false);
                    this.mFragments.set(index, fragment);
                    continue;
                }
                Log.w((String)TAG, (String)("Bad fragment at key " + key));
            }
        }
    }
}

