/*
 * =================================================================================================
 *                             Copyright (C) 2016 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.support.pager.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.ViewGroup;

/**
 * Extended version of {@link FragmentStatePagerAdapter}.
 *
 * @author Martin Albedinsky
 */
public abstract class BaseFragmentStatePagerAdapter extends FragmentStatePagerAdapter {

	/**
	 * Interface ===================================================================================
	 */

	/**
	 * Constants ===================================================================================
	 */

	/**
	 * Log TAG.
	 */
	// private static final String TAG = "BaseFragmentStatePagerAdapter";

	/**
	 * Static members ==============================================================================
	 */

	/**
	 * Members =====================================================================================
	 */

	/**
	 * Context in which is this adapter used. May be {@code null}.
	 */
	protected final Context mContext;

	/**
	 * Application resources.
	 */
	protected final Resources mResources;

	/**
	 * Position of the current primary item.
	 */
	private int mPrimaryPosition = -1;

	/**
	 * Constructors ================================================================================
	 */

	/**
	 * Same as {@link #BaseFragmentStatePagerAdapter(FragmentManager, Context)} with {@code null}
	 * context.
	 */
	public BaseFragmentStatePagerAdapter(@NonNull FragmentManager fragmentManager) {
		this(fragmentManager, null);
	}

	/**
	 * Creates a new instance of BaseFragmentStatePagerAdapter.
	 * <p>
	 * See {@link FragmentStatePagerAdapter#FragmentStatePagerAdapter(FragmentManager)} for more info.
	 *
	 * @param context Context in which will be the new adapter used. Maybe {@code null} if not needed.
	 */
	public BaseFragmentStatePagerAdapter(@NonNull FragmentManager fragmentManager, @Nullable Context context) {
		super(fragmentManager);
		this.mContext = context;
		this.mResources = context != null ? context.getResources() : null;
	}

	/**
	 * Methods =====================================================================================
	 */

	/**
	 */
	@Override
	public void setPrimaryItem(ViewGroup container, int position, Object object) {
		super.setPrimaryItem(container, position, object);
		this.mPrimaryPosition = position;
	}

	/**
	 * Returns the fragment instance that has been set as primary item via {@link #setPrimaryItem(ViewGroup, int, Object)}.
	 *
	 * @return Currently primary fragment. May be {@code null} if no primary item has been set yet.
	 * @see #getPrimaryPosition()
	 */
	@Nullable
	public Fragment getPrimaryFragment() {
		return mPrimaryItem;
	}

	/**
	 * Returns position of the current primary item.
	 *
	 * @return Primary item's position or {@code -1} if no primary item has been specified yet.
	 * @see #getPrimaryFragment()
	 * @see #setPrimaryItem(ViewGroup, int, Object)
	 */
	@IntRange(from = -1)
	public int getPrimaryPosition() {
		return mPrimaryPosition;
	}

	/**
	 * Inner classes ===============================================================================
	 */
}
