/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.support.fragment;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;

/**
 * Class that declares policies related to the Android {@code Fragments} API.
 *
 * @author Martin Albedinsky
 */
public final class FragmentPolicies {

	/**
	 * Flag indicating whether a transitions API for fragments is supported by the current version
	 * of the Android or not.
	 */
	public static final boolean TRANSITIONS_SUPPORTED = Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP;

	/**
	 */
	private FragmentPolicies() {
		// Not allowed to be instantiated publicly.
		throw new UnsupportedOperationException();
	}

	/**
	 * Checks whether the custom animations specified via {@link android.app.FragmentTransaction#setCustomAnimations(int, int, int, int)
	 * FragmentTransaction.setCustomAnimations(int, int, int, int)} will be actually played.
	 * <p>
	 * <b>This implementation always returns {@code true}</b>.
	 *
	 * @return {@code True} if animations will be played, {@code false} otherwise.
	 */
	@SuppressWarnings("deprecation")
	public static boolean willBeCustomAnimationsPlayed(@NonNull final Context context) {
		return true;
	}
}
