/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.fragment.manage;

import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.app.Fragment;
import android.support.v4.util.Pair;
import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import universum.studios.android.support.fragment.manage.FragmentController;
import universum.studios.android.support.fragment.manage.FragmentTransition;

public final class FragmentRequest {
    public static final int NO_ID = -1;
    public static final int NO_STYLE = -1;
    public static final int REPLACE = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int SHOW = 3;
    public static final int HIDE = 4;
    public static final int ATTACH = 5;
    public static final int DETACH = 6;
    static final int REPLACE_SAME = 1;
    static final int ADD_TO_BACK_STACK = 2;
    static final int EXECUTE_ALLOWING_STATE_LOSS = 16;
    static final int EXECUTE_IMMEDIATE = 32;
    static final int TRANSITION_ENTER = 1;
    static final int TRANSITION_EXIT = 2;
    static final int TRANSITION_REENTER = 4;
    static final int TRANSITION_RETURN = 8;
    static final int TRANSITION_SHARED_ELEMENT_ENTER = 16;
    static final int TRANSITION_SHARED_ELEMENT_RETURN = 32;
    final Fragment mFragment;
    private final FragmentController mController;
    private int mFragmentId = -1;
    private int mOutgoingFragmentId = -1;
    Bundle mArguments;
    int mTransaction = 0;
    String mTag;
    int mViewContainerId = -1;
    FragmentTransition mTransition;
    int mTransitionStyle = -1;
    Object mEnterTransition;
    Object mExitTransition;
    Object mReenterTransition;
    Object mReturnTransition;
    Object mSharedElementEnterTransition;
    Object mSharedElementReturnTransition;
    private int mSpecifiedTransitions;
    Boolean mAllowEnterTransitionOverlap;
    Boolean mAllowReturnTransitionOverlap;
    List<Pair<View, String>> mSharedElements;
    private int mFlags;
    private boolean mExecuted = false;

    FragmentRequest(Fragment fragment, FragmentController controller) {
        this.mFragment = fragment;
        this.mController = controller;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("FragmentRequest{fragmentId: ");
        builder.append(this.mFragmentId);
        builder.append(", outgoingFragmentId: ");
        builder.append(this.mOutgoingFragmentId);
        builder.append(", arguments: ");
        builder.append(this.mArguments);
        builder.append(", transactionType: ");
        builder.append(this.mTransition);
        builder.append(", tag: ");
        builder.append(this.mTag);
        builder.append(", viewContainerId: ");
        builder.append(this.mViewContainerId);
        builder.append(", transition: ");
        builder.append(this.mTransition != null ? this.mTransition.getName() : "null");
        builder.append(", transitionStyle: ");
        builder.append(this.mTransitionStyle);
        builder.append(", replaceSame: ");
        builder.append(this.hasFlag(1));
        builder.append(", addToBackStack: ");
        builder.append(this.hasFlag(2));
        builder.append(", executeAllowingStateLoss: ");
        builder.append(this.hasFlag(16));
        builder.append(", executeImmediate: ");
        builder.append(this.hasFlag(32));
        builder.append(", executed: ");
        builder.append(this.mExecuted);
        return builder.append("}").toString();
    }

    @NonNull
    public Fragment fragment() {
        return this.mFragment;
    }

    public FragmentRequest fragmentId(int fragmentId) {
        this.mFragmentId = fragmentId;
        return this;
    }

    public int fragmentId() {
        return this.mFragmentId;
    }

    public FragmentRequest outgoingFragmentId(int fragmentId) {
        this.mOutgoingFragmentId = fragmentId;
        return this;
    }

    public int outgoingFragmentId() {
        return this.mOutgoingFragmentId;
    }

    public FragmentRequest arguments(@Nullable Bundle arguments) {
        this.mArguments = arguments;
        return this;
    }

    @Nullable
    public final Bundle arguments() {
        return this.mArguments;
    }

    public FragmentRequest transaction(int transaction) {
        this.mTransaction = transaction;
        return this;
    }

    public int transaction() {
        return this.mTransaction;
    }

    public final FragmentRequest tag(@Nullable String fragmentTag) {
        this.mTag = fragmentTag;
        return this;
    }

    @Nullable
    public final String tag() {
        return this.mTag;
    }

    public FragmentRequest viewContainerId(@IdRes int containerId) {
        this.mViewContainerId = containerId;
        return this;
    }

    @IdRes
    public int viewContainerId() {
        return this.mViewContainerId;
    }

    public final FragmentRequest transition(@Nullable FragmentTransition transition) {
        this.mTransition = transition;
        return this;
    }

    @Nullable
    public final FragmentTransition transition() {
        return this.mTransition;
    }

    public final FragmentRequest transitionStyle(@StyleRes int transitionStyle) {
        this.mTransitionStyle = transitionStyle;
        return this;
    }

    @StyleRes
    public final int transitionStyle() {
        return this.mTransitionStyle;
    }

    public FragmentRequest enterTransition(@Nullable Object transition) {
        this.mSpecifiedTransitions |= 1;
        this.mEnterTransition = transition;
        return this;
    }

    @Nullable
    public Object enterTransition() {
        return this.mEnterTransition;
    }

    public FragmentRequest exitTransition(@Nullable Object transition) {
        this.mSpecifiedTransitions |= 2;
        this.mExitTransition = transition;
        return this;
    }

    @Nullable
    public Object exitTransition() {
        return this.mExitTransition;
    }

    public FragmentRequest reenterTransition(@Nullable Object transition) {
        this.mSpecifiedTransitions |= 4;
        this.mReenterTransition = transition;
        return this;
    }

    @Nullable
    public Object reenterTransition() {
        return this.mReenterTransition;
    }

    public FragmentRequest returnTransition(@Nullable Object transition) {
        this.mSpecifiedTransitions |= 8;
        this.mReturnTransition = transition;
        return this;
    }

    @Nullable
    public Object returnTransition() {
        return this.mReturnTransition;
    }

    public final FragmentRequest allowEnterTransitionOverlap(boolean allowOverlap) {
        this.mAllowEnterTransitionOverlap = allowOverlap;
        return this;
    }

    public final Boolean allowEnterTransitionOverlap() {
        return this.mAllowEnterTransitionOverlap;
    }

    public final FragmentRequest allowReturnTransitionOverlap(boolean allowOverlap) {
        this.mAllowReturnTransitionOverlap = allowOverlap;
        return this;
    }

    public final boolean allowReturnTransitionOverlap() {
        return this.mAllowReturnTransitionOverlap != null && this.mAllowReturnTransitionOverlap != false;
    }

    @SafeVarargs
    public final FragmentRequest sharedElements(Pair<View, String> ... elements) {
        if (this.mSharedElements == null) {
            this.mSharedElements = new ArrayList<Pair<View, String>>(elements.length);
        }
        this.mSharedElements.addAll(Arrays.asList(elements));
        return this;
    }

    public final FragmentRequest sharedElement(@NonNull View element, @NonNull String elementName) {
        if (this.mSharedElements == null) {
            this.mSharedElements = new ArrayList<Pair<View, String>>(1);
        }
        this.mSharedElements.add((Pair<View, String>)new Pair((Object)element, (Object)elementName));
        return this;
    }

    @Nullable
    public final List<Pair<View, String>> sharedElements() {
        return this.mSharedElements;
    }

    @Nullable
    public Pair<View, String> singleSharedElement() {
        return this.mSharedElements != null && !this.mSharedElements.isEmpty() ? this.mSharedElements.get(0) : null;
    }

    public FragmentRequest sharedElementEnterTransition(@Nullable Object transition) {
        this.mSpecifiedTransitions |= 0x10;
        this.mSharedElementEnterTransition = transition;
        return this;
    }

    @Nullable
    public Object sharedElementEnterTransition() {
        return this.mSharedElementEnterTransition;
    }

    public FragmentRequest sharedElementReturnTransition(@Nullable Object transition) {
        this.mSpecifiedTransitions |= 0x20;
        this.mSharedElementReturnTransition = transition;
        return this;
    }

    @Nullable
    public Object sharedElementReturnTransition() {
        return this.mSharedElementReturnTransition;
    }

    boolean hasTransition(int transitionFlag) {
        return (this.mSpecifiedTransitions & transitionFlag) != 0;
    }

    public final FragmentRequest replaceSame(boolean replace) {
        return this.setHasFlag(1, replace);
    }

    public final boolean replaceSame() {
        return this.hasFlag(1);
    }

    public final FragmentRequest addToBackStack(boolean add) {
        return this.setHasFlag(2, add);
    }

    public final boolean addToBackStack() {
        return this.hasFlag(2);
    }

    public final FragmentRequest executeAllowingStateLoss(boolean allowing) {
        return this.setHasFlag(16, allowing);
    }

    public final boolean executeAllowingStateLoss() {
        return this.hasFlag(16);
    }

    public FragmentRequest executeImmediate(boolean immediate) {
        return this.setHasFlag(32, immediate);
    }

    public boolean executeImmediate() {
        return this.hasFlag(32);
    }

    private FragmentRequest setHasFlag(int flag, boolean has) {
        this.mFlags = has ? (this.mFlags |= flag) : (this.mFlags &= ~flag);
        return this;
    }

    boolean hasFlag(int flag) {
        return (this.mFlags & flag) != 0;
    }

    @NonNull
    public Fragment execute() {
        this.assertNotExecuted();
        switch (this.mTransaction) {
            case 0: 
            case 1: {
                if (this.mViewContainerId != -1) break;
                throw new IllegalArgumentException("Cannot execute request for REPLACE|ADD transaction. No view container id specified!");
            }
        }
        return this.mController.executeRequest(this);
    }

    private void assertNotExecuted() {
        if (this.mExecuted) {
            throw new IllegalStateException("Already executed!");
        }
    }

    public boolean executed() {
        return this.mExecuted;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface TransitionFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Flag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Transaction {
    }
}

