/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.fragment.manage;

import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.util.Pair;
import android.util.Log;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.support.fragment.FragmentsConfig;
import universum.studios.android.support.fragment.manage.FragmentFactory;
import universum.studios.android.support.fragment.manage.FragmentRequest;
import universum.studios.android.support.fragment.manage.FragmentRequestInterceptor;

public class FragmentController {
    private static final String TAG = "FragmentController";
    public static final String FRAGMENT_TAG = "universum.studios.android.support.fragment.TAG.Fragment";
    public static final int NO_CONTAINER_ID = -1;
    private static final boolean CAN_ATTACH_TRANSITIONS = Build.VERSION.SDK_INT >= 4;
    private final FragmentManager.OnBackStackChangedListener mBackStackChangeListener = new BackStackListener();
    private final FragmentManager mManager;
    private int mViewContainerId = -1;
    private FragmentFactory mFactory;
    private FragmentRequestInterceptor mRequestInterceptor;
    private List<OnRequestListener> mRequestListeners;
    private List<OnBackStackChangeListener> mBackStackChangeListeners;
    private FragmentManager.BackStackEntry mTopBackStackEntry;
    private boolean mDestroyed;

    public FragmentController(@NonNull FragmentActivity parentActivity) {
        this(parentActivity.getSupportFragmentManager());
        if (parentActivity instanceof FragmentRequestInterceptor) {
            this.setRequestInterceptor((FragmentRequestInterceptor)parentActivity);
        }
        if (parentActivity instanceof OnRequestListener) {
            this.registerOnRequestListener((OnRequestListener)parentActivity);
        }
        if (parentActivity instanceof OnBackStackChangeListener) {
            this.registerOnBackStackChangeListener((OnBackStackChangeListener)parentActivity);
        }
    }

    public FragmentController(@NonNull Fragment parentFragment) {
        this(parentFragment.getFragmentManager());
        if (parentFragment instanceof FragmentRequestInterceptor) {
            this.setRequestInterceptor((FragmentRequestInterceptor)parentFragment);
        }
        if (parentFragment instanceof OnRequestListener) {
            this.registerOnRequestListener((OnRequestListener)parentFragment);
        }
        if (parentFragment instanceof OnBackStackChangeListener) {
            this.registerOnBackStackChangeListener((OnBackStackChangeListener)parentFragment);
        }
    }

    public FragmentController(@NonNull FragmentManager fragmentManager) {
        this.mManager = fragmentManager;
        this.mManager.addOnBackStackChangedListener(this.mBackStackChangeListener);
        int n = this.mManager.getBackStackEntryCount();
        if (n > 0) {
            this.mTopBackStackEntry = this.mManager.getBackStackEntryAt(n - 1);
        }
    }

    @NonNull
    public final FragmentManager getFragmentManager() {
        return this.mManager;
    }

    public final void setViewContainerId(@IdRes int containerId) {
        this.mViewContainerId = containerId;
    }

    @IdRes
    public final int getViewContainerId() {
        return this.mViewContainerId;
    }

    public void setFactory(@Nullable FragmentFactory factory) {
        this.mFactory = factory;
    }

    @Nullable
    public FragmentFactory getFactory() {
        return this.mFactory;
    }

    public boolean hasFactory() {
        return this.mFactory != null;
    }

    private void assertHasFactory() {
        if (this.mFactory == null) {
            throw new NullPointerException("No factory attached!");
        }
    }

    public void setRequestInterceptor(@Nullable FragmentRequestInterceptor interceptor) {
        this.mRequestInterceptor = interceptor;
    }

    public void registerOnRequestListener(@NonNull OnRequestListener listener) {
        if (this.mRequestListeners == null) {
            this.mRequestListeners = new ArrayList<OnRequestListener>(1);
        }
        if (!this.mRequestListeners.contains(listener)) {
            this.mRequestListeners.add(listener);
        }
    }

    public void unregisterOnRequestListener(@NonNull OnRequestListener listener) {
        if (this.mRequestListeners != null) {
            this.mRequestListeners.remove(listener);
        }
    }

    private void notifyRequestExecuted(FragmentRequest request) {
        if (this.mRequestListeners != null && !this.mRequestListeners.isEmpty()) {
            for (OnRequestListener listener : this.mRequestListeners) {
                listener.onRequestExecuted(request);
            }
        }
    }

    public void registerOnBackStackChangeListener(@NonNull OnBackStackChangeListener listener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList<OnBackStackChangeListener>(1);
        }
        if (!this.mBackStackChangeListeners.contains(listener)) {
            this.mBackStackChangeListeners.add(listener);
        }
    }

    public void unregisterOnBackStackChangeListener(@NonNull OnBackStackChangeListener listener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(listener);
        }
    }

    private void notifyBackStackEntryChange(FragmentManager.BackStackEntry changedEntry, boolean added) {
        if (this.mBackStackChangeListeners != null && !this.mBackStackChangeListeners.isEmpty()) {
            for (OnBackStackChangeListener listener : this.mBackStackChangeListeners) {
                listener.onFragmentsBackStackChanged(changedEntry, added);
            }
        }
    }

    @NonNull
    public final FragmentRequest newRequest(int factoryFragmentId) {
        this.assertNotDestroyed("NEW REQUEST");
        this.assertHasFactory();
        if (!this.mFactory.isFragmentProvided(factoryFragmentId)) {
            throw new IllegalArgumentException("Cannot create new request. Current factory(" + this.mFactory.getClass() + ") " + "does not provide fragment for the requested id(" + factoryFragmentId + ")!");
        }
        Fragment fragment = this.mFactory.createFragment(factoryFragmentId);
        if (fragment == null) {
            throw new NullPointerException("Cannot create new request. Current factory(" + this.mFactory.getClass() + ") is cheating. " + "FragmentFactory.isFragmentProvided() returned true, but FragmentFactory.createFragment(...) returned null!");
        }
        return this.newRequest(fragment).tag(this.mFactory.createFragmentTag(factoryFragmentId)).fragmentId(factoryFragmentId);
    }

    @NonNull
    public final FragmentRequest newRequest(@NonNull Fragment fragment) {
        this.assertNotDestroyed("NEW REQUEST");
        return new FragmentRequest(fragment, this).tag(FRAGMENT_TAG).viewContainerId(this.mViewContainerId);
    }

    final Fragment executeRequest(FragmentRequest request) {
        Fragment fragment;
        this.assertNotDestroyed("EXECUTE REQUEST");
        Fragment fragment2 = fragment = this.mRequestInterceptor != null ? this.mRequestInterceptor.interceptFragmentRequest(request) : null;
        if (fragment == null) {
            fragment = this.onExecuteRequest(request);
        }
        this.notifyRequestExecuted(request);
        return fragment;
    }

    @NonNull
    protected Fragment onExecuteRequest(@NonNull FragmentRequest request) {
        Fragment showingFragment;
        if (!request.hasFlag(1) && (showingFragment = this.mManager.findFragmentByTag(request.mTag)) != null) {
            if (FragmentsConfig.LOG_ENABLED) {
                Log.v((String)TAG, (String)("Fragment with tag(" + request.mTag + ") is already showing or it is in the back-stack."));
            }
            return showingFragment;
        }
        Fragment fragment = request.mFragment;
        FragmentTransaction transaction = this.createTransaction(request);
        if (request.hasFlag(2) && FragmentsConfig.DEBUG_LOG_ENABLED) {
            Log.d((String)TAG, (String)("Fragment(" + fragment + ") will be added to back-stack under the tag(" + fragment.getTag() + ")."));
        }
        if (request.hasFlag(16)) {
            transaction.commitAllowingStateLoss();
        } else {
            transaction.commit();
        }
        if (request.hasFlag(32)) {
            this.mManager.executePendingTransactions();
        }
        return fragment;
    }

    @NonNull
    public FragmentTransaction createTransaction(@NonNull FragmentRequest request) {
        this.assertNotDestroyed("CREATE TRANSACTION");
        FragmentTransaction transaction = this.mManager.beginTransaction();
        Fragment fragment = request.mFragment;
        if (request.mArguments != null) {
            fragment.setArguments(request.mArguments);
        }
        if (request.mTransition != null) {
            transaction.setCustomAnimations(request.mTransition.getIncomingAnimation(), request.mTransition.getOutgoingAnimation(), request.mTransition.getIncomingBackStackAnimation(), request.mTransition.getOutgoingBackStackAnimation());
        } else if (request.mTransitionStyle != -1) {
            transaction.setTransitionStyle(request.mTransitionStyle);
        }
        switch (request.mTransaction) {
            case 0: {
                if (request.mViewContainerId == -1) {
                    throw new IllegalArgumentException("Cannot create REPLACE transaction. No view container id specified!");
                }
                transaction.replace(request.mViewContainerId, fragment, request.mTag);
                break;
            }
            case 1: {
                if (request.mViewContainerId == -1) {
                    throw new IllegalArgumentException("Cannot create ADD transaction. No view container id specified!");
                }
                transaction.add(request.mViewContainerId, fragment, request.mTag);
                break;
            }
            case 2: {
                transaction.remove(fragment);
                break;
            }
            case 3: {
                transaction.show(fragment);
                break;
            }
            case 4: {
                transaction.hide(fragment);
                break;
            }
            case 5: {
                transaction.attach(fragment);
                break;
            }
            case 6: {
                transaction.detach(fragment);
            }
        }
        if (CAN_ATTACH_TRANSITIONS) {
            this.attachTransitionsToFragment(request, fragment);
            if (request.mSharedElements != null && !request.mSharedElements.isEmpty()) {
                List<Pair<View, String>> elements = request.mSharedElements;
                for (Pair<View, String> pair : elements) {
                    transaction.addSharedElement((View)pair.first, (String)pair.second);
                }
            }
        }
        if (request.hasFlag(2)) {
            transaction.addToBackStack(fragment.getTag());
        }
        return transaction;
    }

    private void attachTransitionsToFragment(FragmentRequest request, Fragment fragment) {
        if (request.hasTransition(1)) {
            fragment.setEnterTransition(request.mEnterTransition);
        }
        if (request.hasTransition(2)) {
            fragment.setExitTransition(request.mExitTransition);
        }
        if (request.hasTransition(4)) {
            fragment.setReenterTransition(request.mReenterTransition);
        }
        if (request.hasTransition(8)) {
            fragment.setReturnTransition(request.mReturnTransition);
        }
        if (request.hasTransition(16)) {
            fragment.setSharedElementEnterTransition(request.mSharedElementEnterTransition);
        }
        if (request.hasTransition(32)) {
            fragment.setSharedElementReturnTransition(request.mSharedElementReturnTransition);
        }
        if (request.mAllowEnterTransitionOverlap != null) {
            fragment.setAllowEnterTransitionOverlap(request.mAllowEnterTransitionOverlap.booleanValue());
        }
        if (request.mAllowReturnTransitionOverlap != null) {
            fragment.setAllowReturnTransitionOverlap(request.mAllowReturnTransitionOverlap.booleanValue());
        }
    }

    @Nullable
    public Fragment findCurrentFragment() {
        this.assertNotDestroyed("FIND CURRENT FRAGMENT");
        if (this.mViewContainerId == -1) {
            throw new UnsupportedOperationException("Cannot find current fragment. No fragment container id specified!");
        }
        return this.mManager.findFragmentById(this.mViewContainerId);
    }

    @Nullable
    public Fragment findFragmentByFactoryId(int factoryFragmentId) {
        this.assertNotDestroyed("FIND FRAGMENT BY FACTORY ID");
        this.assertHasFactory();
        if (!this.mFactory.isFragmentProvided(factoryFragmentId)) {
            throw new IllegalArgumentException("Cannot find fragment by factory id. Current factory(" + this.mFactory.getClass() + ") " + "does not provide fragment for the requested id(" + factoryFragmentId + ")!");
        }
        return this.mManager.findFragmentByTag(this.mFactory.createFragmentTag(factoryFragmentId));
    }

    public final boolean hasBackStackEntries() {
        return this.mManager.getBackStackEntryCount() > 0;
    }

    @Nullable
    public final FragmentManager.BackStackEntry getTopBackStackEntry() {
        return this.mTopBackStackEntry;
    }

    public void clearBackStack() {
        this.assertNotDestroyed("CLEAR BACK STACK");
        int n = this.mManager.getBackStackEntryCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.mManager.popBackStack();
            }
        }
    }

    public boolean clearBackStackImmediate() {
        this.assertNotDestroyed("CLEAR BACK STACK IMMEDIATE");
        int n = this.mManager.getBackStackEntryCount();
        if (n > 0) {
            boolean popped = false;
            for (int i = 0; i < n; ++i) {
                if (!this.mManager.popBackStackImmediate() || popped) continue;
                popped = true;
            }
            return popped;
        }
        return false;
    }

    public final void destroy() {
        if (!this.mDestroyed) {
            this.mDestroyed = true;
            this.mManager.removeOnBackStackChangedListener(this.mBackStackChangeListener);
            this.mRequestListeners = null;
            this.mBackStackChangeListeners = null;
        }
    }

    private void assertNotDestroyed(String forAction) {
        if (this.mDestroyed) {
            throw new IllegalStateException("Cannot perform " + forAction + " action. Controller is already destroyed!");
        }
    }

    final void handleBackStackChange(int backStackSize, int change) {
        if (backStackSize > 0) {
            FragmentManager.BackStackEntry entry = this.mManager.getBackStackEntryAt(backStackSize - 1);
            if (entry != null) {
                this.mTopBackStackEntry = entry;
                this.notifyBackStackEntryChange(this.mTopBackStackEntry, change == 0);
            }
        } else if (this.mTopBackStackEntry != null) {
            this.notifyBackStackEntryChange(this.mTopBackStackEntry, false);
            this.mTopBackStackEntry = null;
        }
    }

    private final class BackStackListener
    implements FragmentManager.OnBackStackChangedListener {
        static final int ADDED = 0;
        static final int REMOVED = 1;
        int backStackSize;

        private BackStackListener() {
        }

        public void onBackStackChanged() {
            int n = FragmentController.this.mManager.getBackStackEntryCount();
            if (n >= 0 && n != this.backStackSize) {
                FragmentController.this.handleBackStackChange(n, n > this.backStackSize ? 0 : 1);
                this.backStackSize = n;
            }
        }
    }

    public static interface OnBackStackChangeListener {
        public void onFragmentsBackStackChanged(@NonNull FragmentManager.BackStackEntry var1, boolean var2);
    }

    public static interface OnRequestListener {
        public void onRequestExecuted(@NonNull FragmentRequest var1);
    }
}

