/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.fragment.annotation.handler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import java.lang.reflect.Field;
import universum.studios.android.support.fragment.annotation.FactoryFragment;
import universum.studios.android.support.fragment.annotation.FactoryFragments;
import universum.studios.android.support.fragment.annotation.FragmentAnnotations;
import universum.studios.android.support.fragment.annotation.handler.AnnotationHandlers;
import universum.studios.android.support.fragment.annotation.handler.BaseAnnotationHandler;
import universum.studios.android.support.fragment.annotation.handler.FragmentFactoryAnnotationHandler;
import universum.studios.android.support.fragment.manage.BaseFragmentFactory;
import universum.studios.android.support.fragment.manage.FragmentItem;

public final class BaseManagementAnnotationHandlers
extends AnnotationHandlers {
    private BaseManagementAnnotationHandlers() {
    }

    @Nullable
    public static FragmentFactoryAnnotationHandler obtainFactoryHandler(@NonNull Class<?> classOfFactory) {
        return BaseManagementAnnotationHandlers.obtainHandler(FragmentFactoryHandler.class, classOfFactory);
    }

    static final class FragmentFactoryHandler
    extends BaseAnnotationHandler
    implements FragmentFactoryAnnotationHandler {
        private final SparseArray<FragmentItem> items;

        public FragmentFactoryHandler(@NonNull Class<?> annotatedClass) {
            super(annotatedClass, BaseFragmentFactory.class);
            int[] ids;
            final SparseArray items = new SparseArray();
            FactoryFragments fragments = this.findAnnotationRecursive(FactoryFragments.class);
            if (fragments != null && (ids = fragments.value()).length > 0) {
                for (int id2 : ids) {
                    items.put(id2, (Object)new FragmentItem(id2, Fragment.class, BaseFragmentFactory.createFragmentTag(this.mAnnotatedClass, Integer.toString(id2))));
                }
            }
            FragmentAnnotations.iterateFields(new FragmentAnnotations.FieldProcessor(){

                @Override
                public void onProcessField(@NonNull Field field, @NonNull String name) {
                    if (field.isAnnotationPresent(FactoryFragment.class) && Integer.TYPE.equals(field.getType())) {
                        FactoryFragment factoryFragment = field.getAnnotation(FactoryFragment.class);
                        try {
                            field.setAccessible(true);
                            int id2 = (Integer)field.get(null);
                            items.put(id2, (Object)new FragmentItem(id2, factoryFragment.value(), BaseFragmentFactory.createFragmentTag(FragmentFactoryHandler.this.mAnnotatedClass, TextUtils.isEmpty((CharSequence)factoryFragment.taggedName()) ? Integer.toString(id2) : factoryFragment.taggedName())));
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)FragmentFactoryAnnotationHandler.class.getSimpleName(), (String)("Failed to obtain id value from @FactoryFragment " + name + "!"), (Throwable)e);
                        }
                    }
                }
            }, this.mAnnotatedClass, this.mMaxSuperClass);
            this.items = items.size() > 0 ? items : null;
        }

        @Override
        @Nullable
        public SparseArray<FragmentItem> getFragmentItems() {
            return this.items;
        }
    }
}

