/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.fragment.annotation.handler;

import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import universum.studios.android.support.fragment.BaseFragment;
import universum.studios.android.support.fragment.annotation.ContentView;
import universum.studios.android.support.fragment.annotation.handler.AnnotationHandlers;
import universum.studios.android.support.fragment.annotation.handler.BaseAnnotationHandler;
import universum.studios.android.support.fragment.annotation.handler.FragmentAnnotationHandler;

public final class BaseAnnotationHandlers
extends AnnotationHandlers {
    private BaseAnnotationHandlers() {
    }

    @Nullable
    public static FragmentAnnotationHandler obtainFragmentHandler(@NonNull Class<?> classOfFragment) {
        return BaseAnnotationHandlers.obtainHandler(FragmentHandler.class, classOfFragment);
    }

    static class FragmentHandler
    extends BaseAnnotationHandler
    implements FragmentAnnotationHandler {
        private boolean attachContentViewToContainer;
        private int contentViewResource = 0;
        private int contentViewBackgroundResId = 0;

        public FragmentHandler(@NonNull Class<?> annotatedClass) {
            this(annotatedClass, BaseFragment.class);
        }

        FragmentHandler(Class<?> annotatedClass, Class<?> maxSuperClass) {
            super(annotatedClass, maxSuperClass);
            ContentView contentView = this.findAnnotationRecursive(ContentView.class);
            if (contentView != null) {
                this.attachContentViewToContainer = contentView.attachToContainer();
                this.contentViewResource = contentView.value();
                this.contentViewBackgroundResId = contentView.background();
            }
        }

        @Override
        public boolean shouldAttachContentViewToContainer() {
            return this.attachContentViewToContainer;
        }

        @Override
        @LayoutRes
        public int getContentViewResource(@LayoutRes int defaultViewResource) {
            return this.contentViewResource != 0 ? this.contentViewResource : defaultViewResource;
        }

        @Override
        @ColorRes
        @DrawableRes
        public int getContentViewBackgroundResId(int defaultResId) {
            return this.contentViewBackgroundResId != 0 ? this.contentViewBackgroundResId : defaultResId;
        }
    }
}

