/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.fragment.annotation.handler;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.MenuRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.view.ActionMode;
import android.view.Menu;
import universum.studios.android.support.fragment.ActionBarDelegate;
import universum.studios.android.support.fragment.ActionBarFragment;
import universum.studios.android.support.fragment.annotation.ActionBarOptions;
import universum.studios.android.support.fragment.annotation.ActionModeOptions;
import universum.studios.android.support.fragment.annotation.MenuOptions;
import universum.studios.android.support.fragment.annotation.handler.ActionBarFragmentAnnotationHandler;
import universum.studios.android.support.fragment.annotation.handler.AnnotationHandlers;
import universum.studios.android.support.fragment.annotation.handler.BaseAnnotationHandlers;

public final class ActionBarAnnotationHandlers
extends AnnotationHandlers {
    private ActionBarAnnotationHandlers() {
    }

    @Nullable
    public static ActionBarFragmentAnnotationHandler obtainActionBarFragmentHandler(@NonNull Class<?> classOfFragment) {
        return ActionBarAnnotationHandlers.obtainHandler(ActionBarFragmentHandler.class, classOfFragment);
    }

    static class ActionBarFragmentHandler
    extends BaseAnnotationHandlers.FragmentHandler
    implements ActionBarFragmentAnnotationHandler {
        private int homeAsUp = -1;
        private int homeAsUpVectorIndicator = -1;
        private int homeAsUpIndicator = -1;
        private int icon = -1;
        private int title = -1;
        private boolean hasOptionsMenu;
        private boolean clearOptionsMenu;
        private int optionsMenuResource = 0;
        private int optionsMenuFlags = -1;
        private int actionModeMenuResource = 0;

        public ActionBarFragmentHandler(@NonNull Class<?> annotatedClass) {
            this(annotatedClass, ActionBarFragment.class);
        }

        ActionBarFragmentHandler(Class<?> annotatedClass, Class<?> maxSuperClass) {
            super(annotatedClass, maxSuperClass);
            ActionModeOptions actionModeOptions;
            MenuOptions menuOptions;
            ActionBarOptions actionBarOptions = this.findAnnotationRecursive(ActionBarOptions.class);
            if (actionBarOptions != null) {
                this.homeAsUp = actionBarOptions.homeAsUp();
                this.homeAsUpVectorIndicator = actionBarOptions.homeAsUpVectorIndicator();
                this.homeAsUpIndicator = actionBarOptions.homeAsUpIndicator();
                this.icon = actionBarOptions.icon();
                this.title = actionBarOptions.title();
            }
            if ((menuOptions = this.findAnnotationRecursive(MenuOptions.class)) != null) {
                this.hasOptionsMenu = true;
                this.clearOptionsMenu = menuOptions.clear();
                this.optionsMenuFlags = menuOptions.flags();
                this.optionsMenuResource = menuOptions.value();
            }
            if ((actionModeOptions = this.findAnnotationRecursive(ActionModeOptions.class)) != null) {
                this.actionModeMenuResource = actionModeOptions.menu();
            }
        }

        @Override
        public void configureActionBar(@NonNull ActionBarDelegate actionBarDelegate) {
            switch (this.homeAsUp) {
                case 2: {
                    actionBarDelegate.setDisplayHomeAsUpEnabled(false);
                    break;
                }
                case 1: {
                    actionBarDelegate.setDisplayHomeAsUpEnabled(true);
                    this.hasOptionsMenu = true;
                }
            }
            if (this.homeAsUpVectorIndicator != -1) {
                switch (this.homeAsUpVectorIndicator) {
                    case 0: {
                        actionBarDelegate.setHomeAsUpIndicator((Drawable)new ColorDrawable(0));
                        break;
                    }
                    default: {
                        actionBarDelegate.setHomeAsUpVectorIndicator(this.homeAsUpVectorIndicator);
                        break;
                    }
                }
            } else if (this.homeAsUpIndicator != -1) {
                switch (this.homeAsUpIndicator) {
                    case 0: {
                        actionBarDelegate.setHomeAsUpIndicator((Drawable)new ColorDrawable(0));
                        break;
                    }
                    default: {
                        actionBarDelegate.setHomeAsUpIndicator(this.homeAsUpIndicator);
                    }
                }
            }
            switch (this.icon) {
                case -1: {
                    break;
                }
                case 0: {
                    actionBarDelegate.setIcon((Drawable)new ColorDrawable(0));
                    break;
                }
                default: {
                    actionBarDelegate.setIcon(this.icon);
                }
            }
            switch (this.title) {
                case -1: {
                    break;
                }
                case 0: {
                    actionBarDelegate.setTitle("");
                    break;
                }
                default: {
                    actionBarDelegate.setTitle(this.title);
                }
            }
        }

        @Override
        public boolean hasOptionsMenu() {
            return this.hasOptionsMenu;
        }

        @Override
        public boolean shouldClearOptionsMenu() {
            return this.clearOptionsMenu;
        }

        @Override
        @MenuRes
        public int getOptionsMenuFlags(@MenuRes int defaultFlags) {
            return this.optionsMenuFlags != -1 ? this.optionsMenuFlags : defaultFlags;
        }

        @Override
        public int getOptionsMenuResource(int defaultResource) {
            return this.optionsMenuResource != 0 ? this.optionsMenuResource : defaultResource;
        }

        @Override
        public boolean handleCreateActionMode(@NonNull ActionMode actionMode, @NonNull Menu menu) {
            if (this.actionModeMenuResource != 0) {
                actionMode.getMenuInflater().inflate(this.actionModeMenuResource, menu);
                return true;
            }
            return false;
        }
    }
}

