/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.fragment;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import universum.studios.android.support.fragment.ActionBarFragment;
import universum.studios.android.support.fragment.FragmentsConfig;
import universum.studios.android.support.fragment.annotation.FragmentAnnotations;
import universum.studios.android.support.fragment.annotation.handler.WebAnnotationHandlers;
import universum.studios.android.support.fragment.annotation.handler.WebFragmentAnnotationHandler;

public class WebFragment
extends ActionBarFragment {
    private static final String TAG = "WebFragment";
    private static final String BUNDLE_WEB_VIEW_CONTENT = "universum.studios.android.support.fragment.WebFragment.BUNDLE.Content";
    private static final String BUNDLE_PRIVATE_FLAGS = "universum.studios.android.support.fragment.WebFragment.BUNDLE.PrivateFlags";
    private static final String GOOD_IRI_CHAR = "a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef";
    private static final String TOP_LEVEL_DOMAIN_STR_FOR_WEB_URL = "(?:(?:aero|arpa|asia|a[cdefgilmnoqrstuwxz])|(?:biz|b[abdefghijmnorstvwyz])|(?:cat|com|coop|c[acdfghiklmnoruvxyz])|d[ejkmoz]|(?:edu|e[cegrstu])|f[ijkmor]|(?:gov|g[abdefghilmnpqrstuwy])|h[kmnrtu]|(?:info|int|i[delmnoqrst])|(?:jobs|j[emop])|k[eghimnprwyz]|l[abcikrstuvy]|(?:mil|mobi|museum|m[acdeghklmnopqrstuvwxyz])|(?:name|net|n[acefgilopruz])|(?:org|om)|(?:pro|p[aefghklmnrstwy])|qa|r[eosuw]|s[abcdeghijklmnortuvyz]|(?:tel|travel|t[cdfghjklmnoprtvwz])|u[agksyz]|v[aceginu]|w[fs]|(?:\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae|\u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435|\u0440\u0444|\u0441\u0440\u0431|\u05d8\u05e2\u05e1\u05d8|\u0622\u0632\u0645\u0627\u06cc\u0634\u06cc|\u0625\u062e\u062a\u0628\u0627\u0631|\u0627\u0644\u0627\u0631\u062f\u0646|\u0627\u0644\u062c\u0632\u0627\u0626\u0631|\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629|\u0627\u0644\u0645\u063a\u0631\u0628|\u0627\u0645\u0627\u0631\u0627\u062a|\u0628\u06be\u0627\u0631\u062a|\u062a\u0648\u0646\u0633|\u0633\u0648\u0631\u064a\u0629|\u0641\u0644\u0633\u0637\u064a\u0646|\u0642\u0637\u0631|\u0645\u0635\u0631|\u092a\u0930\u0940\u0915\u094d\u0937\u093e|\u092d\u093e\u0930\u0924|\u09ad\u09be\u09b0\u09a4|\u0a2d\u0a3e\u0a30\u0a24|\u0aad\u0abe\u0ab0\u0aa4|\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe|\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8|\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd|\u0baa\u0bb0\u0bbf\u0b9f\u0bcd\u0b9a\u0bc8|\u0c2d\u0c3e\u0c30\u0c24\u0c4d|\u0dbd\u0d82\u0d9a\u0dcf|\u0e44\u0e17\u0e22|\u30c6\u30b9\u30c8|\u4e2d\u56fd|\u4e2d\u570b|\u53f0\u6e7e|\u53f0\u7063|\u65b0\u52a0\u5761|\u6d4b\u8bd5|\u6e2c\u8a66|\u9999\u6e2f|\ud14c\uc2a4\ud2b8|\ud55c\uad6d|xn\\-\\-0zwm56d|xn\\-\\-11b5bs3a9aj6g|xn\\-\\-3e0b707e|xn\\-\\-45brj9c|xn\\-\\-80akhbyknj4f|xn\\-\\-90a3ac|xn\\-\\-9t4b11yi5a|xn\\-\\-clchc0ea0b2g2a9gcd|xn\\-\\-deba0ad|xn\\-\\-fiqs8s|xn\\-\\-fiqz9s|xn\\-\\-fpcrj9c3d|xn\\-\\-fzc2c9e2c|xn\\-\\-g6w251d|xn\\-\\-gecrj9c|xn\\-\\-h2brj9c|xn\\-\\-hgbk6aj7f53bba|xn\\-\\-hlcj6aya9esc7a|xn\\-\\-j6w193g|xn\\-\\-jxalpdlp|xn\\-\\-kgbechtv|xn\\-\\-kprw13d|xn\\-\\-kpry57d|xn\\-\\-lgbbat1ad8j|xn\\-\\-mgbaam7a8h|xn\\-\\-mgbayh7gpa|xn\\-\\-mgbbh1a71e|xn\\-\\-mgbc0a9azcg|xn\\-\\-mgberp4a5d4ar|xn\\-\\-o3cw4h|xn\\-\\-ogbpf8fl|xn\\-\\-p1ai|xn\\-\\-pgbs0dh|xn\\-\\-s9brj9c|xn\\-\\-wgbh1c|xn\\-\\-wgbl6a|xn\\-\\-xkc2al3hye2a|xn\\-\\-xkc2dl3a5ee0h|xn\\-\\-yfro4i67o|xn\\-\\-ygbi2ammx|xn\\-\\-zckzah|xxx)|y[et]|z[amw]))";
    private static final Matcher WEB_URL_MATCHER = Pattern.compile("((?:(http|https|Http|Https|rtsp|Rtsp):\\/\\/(?:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,64}(?:\\:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,25})?\\@)?)?((?:(?:[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef][a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,64}\\.)+(?:(?:aero|arpa|asia|a[cdefgilmnoqrstuwxz])|(?:biz|b[abdefghijmnorstvwyz])|(?:cat|com|coop|c[acdfghiklmnoruvxyz])|d[ejkmoz]|(?:edu|e[cegrstu])|f[ijkmor]|(?:gov|g[abdefghilmnpqrstuwy])|h[kmnrtu]|(?:info|int|i[delmnoqrst])|(?:jobs|j[emop])|k[eghimnprwyz]|l[abcikrstuvy]|(?:mil|mobi|museum|m[acdeghklmnopqrstuvwxyz])|(?:name|net|n[acefgilopruz])|(?:org|om)|(?:pro|p[aefghklmnrstwy])|qa|r[eosuw]|s[abcdeghijklmnortuvyz]|(?:tel|travel|t[cdfghjklmnoprtvwz])|u[agksyz]|v[aceginu]|w[fs]|(?:\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae|\u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435|\u0440\u0444|\u0441\u0440\u0431|\u05d8\u05e2\u05e1\u05d8|\u0622\u0632\u0645\u0627\u06cc\u0634\u06cc|\u0625\u062e\u062a\u0628\u0627\u0631|\u0627\u0644\u0627\u0631\u062f\u0646|\u0627\u0644\u062c\u0632\u0627\u0626\u0631|\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629|\u0627\u0644\u0645\u063a\u0631\u0628|\u0627\u0645\u0627\u0631\u0627\u062a|\u0628\u06be\u0627\u0631\u062a|\u062a\u0648\u0646\u0633|\u0633\u0648\u0631\u064a\u0629|\u0641\u0644\u0633\u0637\u064a\u0646|\u0642\u0637\u0631|\u0645\u0635\u0631|\u092a\u0930\u0940\u0915\u094d\u0937\u093e|\u092d\u093e\u0930\u0924|\u09ad\u09be\u09b0\u09a4|\u0a2d\u0a3e\u0a30\u0a24|\u0aad\u0abe\u0ab0\u0aa4|\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe|\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8|\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd|\u0baa\u0bb0\u0bbf\u0b9f\u0bcd\u0b9a\u0bc8|\u0c2d\u0c3e\u0c30\u0c24\u0c4d|\u0dbd\u0d82\u0d9a\u0dcf|\u0e44\u0e17\u0e22|\u30c6\u30b9\u30c8|\u4e2d\u56fd|\u4e2d\u570b|\u53f0\u6e7e|\u53f0\u7063|\u65b0\u52a0\u5761|\u6d4b\u8bd5|\u6e2c\u8a66|\u9999\u6e2f|\ud14c\uc2a4\ud2b8|\ud55c\uad6d|xn\\-\\-0zwm56d|xn\\-\\-11b5bs3a9aj6g|xn\\-\\-3e0b707e|xn\\-\\-45brj9c|xn\\-\\-80akhbyknj4f|xn\\-\\-90a3ac|xn\\-\\-9t4b11yi5a|xn\\-\\-clchc0ea0b2g2a9gcd|xn\\-\\-deba0ad|xn\\-\\-fiqs8s|xn\\-\\-fiqz9s|xn\\-\\-fpcrj9c3d|xn\\-\\-fzc2c9e2c|xn\\-\\-g6w251d|xn\\-\\-gecrj9c|xn\\-\\-h2brj9c|xn\\-\\-hgbk6aj7f53bba|xn\\-\\-hlcj6aya9esc7a|xn\\-\\-j6w193g|xn\\-\\-jxalpdlp|xn\\-\\-kgbechtv|xn\\-\\-kprw13d|xn\\-\\-kpry57d|xn\\-\\-lgbbat1ad8j|xn\\-\\-mgbaam7a8h|xn\\-\\-mgbayh7gpa|xn\\-\\-mgbbh1a71e|xn\\-\\-mgbc0a9azcg|xn\\-\\-mgberp4a5d4ar|xn\\-\\-o3cw4h|xn\\-\\-ogbpf8fl|xn\\-\\-p1ai|xn\\-\\-pgbs0dh|xn\\-\\-s9brj9c|xn\\-\\-wgbh1c|xn\\-\\-wgbl6a|xn\\-\\-xkc2al3hye2a|xn\\-\\-xkc2dl3a5ee0h|xn\\-\\-yfro4i67o|xn\\-\\-ygbi2ammx|xn\\-\\-zckzah|xxx)|y[et]|z[amw]))|(?:(?:25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(?:25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(?:25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(?:25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9])))(?:\\:\\d{1,5})?)(\\/(?:(?:[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\;\\/\\?\\:\\@\\&\\=\\#\\~\\-\\.\\+\\!\\*\\'\\(\\)\\,\\_])|(?:\\%[a-fA-F0-9]{2}))*)?(?:\\b|$)").matcher("");
    protected static final int CONTENT_EMPTY = 0;
    protected static final int CONTENT_HTML = 1;
    protected static final int CONTENT_URL = 2;
    protected static final int CONTENT_FILE = 3;
    private static final String DATA_ENCODING = "UTF-8";
    private static final String DATA_MIME_TYPE = "text/html";
    private static final int PFLAG_JAVA_SCRIPT_ENABLED = 1;
    private static final int PFLAG_CONTENT_CHANGED = 2;
    private static final int PFLAG_READY_TO_LOAD_CONTENT = 4;
    private static final int LOG_CONTENT_MAX_LENGTH = 256;
    private static final Matcher FILE_URL_MATCHER = Pattern.compile("file://(.*)").matcher("");
    private WebView mWebView;
    private String mContent;
    private int mContentType = 0;
    private OnWebContentLoadingListener mContentLoadingListener;
    private int mPrivateFlags;

    public static boolean isValidWebUrl(@Nullable String url) {
        return WEB_URL_MATCHER.reset(url).matches();
    }

    @NonNull
    public static WebFragment newInstance() {
        return new WebFragment();
    }

    @NonNull
    public static WebFragment newInstance(@NonNull WebOptions options) {
        WebFragment fragment = new WebFragment();
        Bundle args = new Bundle();
        args.putInt(BUNDLE_PRIVATE_FLAGS, options.javascriptEnabled ? 1 : 0);
        args.putString(BUNDLE_WEB_VIEW_CONTENT, options.content);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    @NonNull
    protected WebFragmentAnnotationHandler getAnnotationHandler() {
        FragmentAnnotations.checkIfEnabledOrThrow();
        return (WebFragmentAnnotationHandler)this.mAnnotationHandler;
    }

    @Override
    WebFragmentAnnotationHandler onCreateAnnotationHandler() {
        return WebAnnotationHandlers.obtainWebFragmentHandler(this.getClass());
    }

    private void updatePrivateFlags(int flag, boolean add) {
        this.mPrivateFlags = add ? (this.mPrivateFlags |= flag) : (this.mPrivateFlags &= ~flag);
    }

    private boolean hasPrivateFlag(int flag) {
        return (this.mPrivateFlags & flag) != 0;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mAnnotationHandler != null) {
            WebFragmentAnnotationHandler annotationHandler = (WebFragmentAnnotationHandler)this.mAnnotationHandler;
            int contentResId = annotationHandler.getWebContentResId(-1);
            this.mContent = contentResId != -1 ? this.getString(contentResId) : annotationHandler.getWebContent(null);
            this.updatePrivateFlags(2, true);
        }
        Bundle args = this.getArguments();
        if (savedInstanceState == null && args != null) {
            this.mPrivateFlags = args.getInt(BUNDLE_PRIVATE_FLAGS);
            this.mContent = args.getString(BUNDLE_WEB_VIEW_CONTENT);
            this.updatePrivateFlags(2, true);
        }
    }

    public void setOnWebContentLoadingListener(@Nullable OnWebContentLoadingListener listener) {
        this.mContentLoadingListener = listener;
    }

    protected void notifyLoadingStarted(@NonNull String webUrl) {
        if (this.mContentLoadingListener != null) {
            this.mContentLoadingListener.onLoadingStarted(webUrl);
        }
    }

    protected void notifyLoadingFinished(@NonNull String webUrl) {
        if (this.mContentLoadingListener != null) {
            this.mContentLoadingListener.onLoadingFinished(webUrl);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        WebChromeClient chromeClient;
        this.mWebView = new WebView(inflater.getContext());
        this.mWebView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mWebView.setScrollBarStyle(0);
        WebViewClient client = this.onCreateWebViewClient();
        if (client != null) {
            this.mWebView.setWebViewClient(client);
        }
        if ((chromeClient = this.onCreateWebChromeClient()) != null) {
            this.mWebView.setWebChromeClient(chromeClient);
        }
        return this.mWebView;
    }

    @Nullable
    protected WebViewClient onCreateWebViewClient() {
        return new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                WebFragment.this.notifyLoadingFinished(url);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                WebFragment.this.notifyLoadingStarted(url);
            }
        };
    }

    @Nullable
    protected WebChromeClient onCreateWebChromeClient() {
        return new WebChromeClient();
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            this.mPrivateFlags = savedInstanceState.getInt(BUNDLE_PRIVATE_FLAGS);
            this.mContent = savedInstanceState.getString(BUNDLE_WEB_VIEW_CONTENT);
            this.updatePrivateFlags(2, true);
        }
        if (this.mWebView != null) {
            this.mWebView.getSettings().setJavaScriptEnabled(this.hasPrivateFlag(1));
        }
    }

    @Nullable
    public WebView getWebView() {
        return this.mWebView;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.updatePrivateFlags(4, true);
        this.resolveContentType();
        if (savedInstanceState != null && this.mWebView != null && this.mContentType != 0 && this.mContentType != 1) {
            this.mWebView.restoreState(savedInstanceState);
        } else {
            this.onLoadContent(this.mContent, this.mContentType);
        }
    }

    public boolean loadContent(@Nullable String content) {
        this.mContent = content;
        this.updatePrivateFlags(2, true);
        if ((this.mPrivateFlags & 4) != 0) {
            this.onLoadContent(this.mContent, this.resolveContentType());
            return true;
        }
        return false;
    }

    private int resolveContentType() {
        if (this.hasPrivateFlag(2)) {
            this.mContentType = !TextUtils.isEmpty((CharSequence)this.mContent) ? (WEB_URL_MATCHER.reset(this.mContent).matches() ? 2 : (FILE_URL_MATCHER.reset(this.mContent).matches() ? 3 : 1)) : 0;
        }
        return this.mContentType;
    }

    protected void onLoadContent(@Nullable String content, int type) {
        if (this.mWebView != null) {
            if (FragmentsConfig.LOG_ENABLED && !TextUtils.isEmpty((CharSequence)content)) {
                if (content.length() > 256) {
                    Log.v((String)TAG, (String)("Loading content('" + content.substring(0, 256) + "') into web view."));
                } else {
                    Log.v((String)TAG, (String)("Loading content('" + content + "') into web view."));
                }
            }
            switch (type) {
                case 0: {
                    this.mWebView.loadDataWithBaseURL("", "", DATA_MIME_TYPE, DATA_ENCODING, "");
                    break;
                }
                case 2: 
                case 3: {
                    this.mWebView.loadUrl(content);
                    break;
                }
                case 1: {
                    this.mWebView.loadDataWithBaseURL("", content, DATA_MIME_TYPE, DATA_ENCODING, "");
                }
            }
        }
    }

    @Nullable
    public String getContent() {
        return this.mContent;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mWebView != null) {
            this.mWebView.saveState(outState);
        }
        outState.putInt(BUNDLE_PRIVATE_FLAGS, this.mPrivateFlags);
        outState.putString(BUNDLE_WEB_VIEW_CONTENT, this.mContent);
    }

    @Override
    protected boolean onBackPress() {
        if (this.mWebView != null && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return true;
        }
        return false;
    }

    public static class WebOptions {
        private String content = "";
        private boolean javascriptEnabled = true;

        public WebOptions content(@NonNull String content) {
            this.content = content;
            return this;
        }

        public WebOptions javaScriptEnabled(boolean enabled) {
            this.javascriptEnabled = enabled;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ContentType {
    }

    public static interface OnWebContentLoadingListener {
        public void onLoadingStarted(@NonNull String var1);

        public void onLoadingFinished(@NonNull String var1);
    }
}

