/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.support.fragment;

import android.app.ActionBar;
import android.app.Activity;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.ActionMode;

public abstract class ActivityDelegate {
    protected final Activity mActivity;

    protected ActivityDelegate(@NonNull Activity activity) {
        this.mActivity = activity;
    }

    @NonNull
    public static ActivityDelegate create(Activity activity) {
        if (activity instanceof AppCompatActivity) {
            return new AppCompatImpl((AppCompatActivity)activity);
        }
        return new Impl(activity);
    }

    public abstract boolean requestWindowFeature(int var1);

    public abstract void invalidateOptionsMenu();

    @Nullable
    public abstract ActionBar getActionBar();

    @Nullable
    public abstract android.support.v7.app.ActionBar getSupportActionBar();

    @Nullable
    public abstract ActionMode startActionMode(@NonNull ActionMode.Callback var1);

    private static final class AppCompatImpl
    extends Impl {
        private AppCompatImpl(AppCompatActivity activity) {
            super((Activity)activity);
        }

        @Override
        public boolean requestWindowFeature(int featureId) {
            return ((AppCompatActivity)this.mActivity).supportRequestWindowFeature(featureId);
        }

        @Override
        public void invalidateOptionsMenu() {
            ((AppCompatActivity)this.mActivity).supportInvalidateOptionsMenu();
        }

        @Override
        public android.support.v7.app.ActionBar getSupportActionBar() {
            return ((AppCompatActivity)this.mActivity).getSupportActionBar();
        }
    }

    private static class Impl
    extends ActivityDelegate {
        private Impl(Activity activity) {
            super(activity);
        }

        @Override
        public boolean requestWindowFeature(int featureId) {
            return this.mActivity.requestWindowFeature(featureId);
        }

        @Override
        public void invalidateOptionsMenu() {
            if (Build.VERSION.SDK_INT >= 11) {
                this.mActivity.invalidateOptionsMenu();
            }
        }

        @Override
        @Nullable
        public ActionBar getActionBar() {
            if (Build.VERSION.SDK_INT >= 11) {
                return this.mActivity.getActionBar();
            }
            return null;
        }

        @Override
        @Nullable
        public android.support.v7.app.ActionBar getSupportActionBar() {
            return null;
        }

        @Override
        @Nullable
        public ActionMode startActionMode(@NonNull ActionMode.Callback callback) {
            return null;
        }
    }
}

