/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import universum.studios.android.setting.R;

public class SettingColorView
extends View {
    @VisibleForTesting
    static final String ACCESSIBILITY_EVENT_CLASS_NAME = "universum.studios.android.setting.widget.ColorView";
    private final Paint paint = new Paint(1);
    private int rawCanvasColor;
    private int drawCanvasColor = this.rawCanvasColor = -1;
    private int rawColor;
    private int drawColor = this.rawColor = -1;
    private int maxWidth;
    private int mMaxHeight;
    private int width;
    private int height;
    private float radius;

    public SettingColorView(@NonNull Context context) {
        this(context, null);
    }

    public SettingColorView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.settingColorViewStyle);
    }

    public SettingColorView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public SettingColorView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    @SuppressLint(value={"CustomViewStyleable"})
    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mMaxHeight = Integer.MAX_VALUE;
        this.maxWidth = Integer.MAX_VALUE;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingColorView, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingColorView_android_color) {
                this.setColor(attributes.getColor(attrIndex, this.rawColor));
                continue;
            }
            if (attrIndex == R.styleable.SettingColorView_android_maxWidth) {
                this.maxWidth = attributes.getDimensionPixelSize(attrIndex, this.maxWidth);
                continue;
            }
            if (attrIndex != R.styleable.SettingColorView_android_maxHeight) continue;
            this.mMaxHeight = attributes.getDimensionPixelSize(attrIndex, this.mMaxHeight);
        }
        attributes.recycle();
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)ACCESSIBILITY_EVENT_CLASS_NAME);
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)ACCESSIBILITY_EVENT_CLASS_NAME);
    }

    public void setCanvasColor(@ColorInt int color) {
        if (this.rawCanvasColor != color || this.drawCanvasColor != color) {
            this.rawCanvasColor = this.drawCanvasColor = color;
            this.invalidate();
        }
    }

    @ColorInt
    public int getCanvasColor() {
        return this.drawCanvasColor;
    }

    public void setColor(@ColorInt int color) {
        if (this.rawColor != color || this.drawColor != color) {
            this.rawColor = this.drawColor = color;
            this.invalidate();
        }
    }

    @ColorInt
    public int getColor() {
        return this.drawColor;
    }

    protected boolean onSetAlpha(int alpha) {
        this.drawColor = this.rawColor << 8 >>> 8 | alpha << 24;
        this.drawCanvasColor = this.drawCanvasColor << 8 >>> 8 | alpha << 24;
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        width = Math.min(width, this.maxWidth);
        height = Math.min(height, this.mMaxHeight);
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.width = width;
        this.height = height;
        this.radius = (float)Math.min(this.width, this.height) / 2.0f;
    }

    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (this.drawCanvasColor >>> 24 != 0) {
            this.paint.setColor(this.rawCanvasColor);
            canvas.drawCircle((float)this.width / 2.0f, (float)this.height / 2.0f, this.radius, this.paint);
        }
        if (this.drawColor >>> 24 != 0) {
            this.paint.setColor(this.drawColor);
            canvas.drawCircle((float)this.width / 2.0f, (float)this.height / 2.0f, this.radius, this.paint);
        }
    }
}

