/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import universum.studios.android.dialog.Dialog;
import universum.studios.android.dialog.TimePickerDialog;
import universum.studios.android.setting.R;
import universum.studios.android.setting.SettingDateTimeDialogPreference;

public class SettingTimeDialogPreference
extends SettingDateTimeDialogPreference<TimePickerDialog.TimeOptions> {
    @VisibleForTesting
    static final String DEFAULT_FORMAT_PATTERN = "hh:mm a";

    public SettingTimeDialogPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingTimeDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.settingTimeDialogPreferenceStyle);
    }

    public SettingTimeDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public SettingTimeDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    private static Long parseTime(String timeString) {
        return TextUtils.isEmpty((CharSequence)timeString) ? null : TimePickerDialog.TimeParser.parse((String)timeString);
    }

    @Override
    @NonNull
    protected TimePickerDialog.TimeOptions onCreateDialogOptions(@NonNull Resources resources) {
        return new TimePickerDialog.TimeOptions(resources);
    }

    @Override
    protected void onConfigureDialogOptions(@NonNull TimePickerDialog.TimeOptions options, @NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super.onConfigureDialogOptions(options, context, attrs, defStyleAttr, defStyleRes);
        String formatPattern = DEFAULT_FORMAT_PATTERN;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingTimeDialogPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingTimeDialogPreference_settingDateFormat) {
                String dateFormat = attributes.getString(attrIndex);
                formatPattern = TextUtils.isEmpty((CharSequence)dateFormat) ? formatPattern : dateFormat;
                continue;
            }
            if (attrIndex == R.styleable.SettingTimeDialogPreference_dialogTime) {
                Long time = SettingTimeDialogPreference.parseTime(attributes.getString(attrIndex));
                if (time == null) continue;
                options.time(time.longValue());
                continue;
            }
            if (attrIndex == R.styleable.SettingTimeDialogPreference_dialogTimePickers) {
                options.timePickers(attributes.getInt(attrIndex, options.timePickers()));
                continue;
            }
            if (attrIndex != R.styleable.SettingTimeDialogPreference_dialogTimeQuantityText) continue;
            options.timeQuantityText(attributes.getResourceId(attrIndex, 0));
        }
        attributes.recycle();
        this.setFormat(new SimpleDateFormat(formatPattern, Locale.getDefault()));
    }

    @Override
    long onParseDefaultValue(@NonNull Object defaultValue) {
        Long time = SettingTimeDialogPreference.parseTime((String)defaultValue);
        return time == null ? 0L : time;
    }

    public void setTime(@Nullable Date time) {
        this.setTime(time == null ? 0L : time.getTime());
    }

    public void setTime(long timeInMillis) {
        this.setMilliseconds(timeInMillis);
    }

    @Nullable
    public Date getTime() {
        return this.areMillisecondsSet() ? new Date(this.getTimeInMillis()) : null;
    }

    public long getTimeInMillis() {
        return this.getMilliseconds();
    }

    @Override
    @NonNull
    public TimePickerDialog.TimeOptions getDialogOptions() {
        TimePickerDialog.TimeOptions options = (TimePickerDialog.TimeOptions)super.getDialogOptions();
        if (this.areMillisecondsSet()) {
            options.time(this.getTimeInMillis());
        }
        return options;
    }

    @Override
    protected boolean onHandleDialogButtonClick(@NonNull Dialog dialog, int button) {
        if (dialog instanceof TimePickerDialog) {
            switch (button) {
                case 1: {
                    long newTime = ((TimePickerDialog)dialog).getTime();
                    if (newTime != this.getTimeInMillis() && this.callChangeListener(newTime)) {
                        this.setTime(newTime);
                    }
                    return true;
                }
            }
            return true;
        }
        return super.onHandleDialogButtonClick(dialog, button);
    }
}

