/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.SeekBar;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.preference.PreferenceViewHolder;
import universum.studios.android.setting.R;
import universum.studios.android.setting.SettingPreference;

public class SettingSeekBarPreference
extends SettingPreference {
    @VisibleForTesting
    static final int DEFAULT_MAX_PROGRESS = 100;
    private final SeekBar.OnSeekBarChangeListener listener = new SeekBar.OnSeekBarChangeListener(){

        public void onProgressChanged(@NonNull SeekBar seekBar, int progress, boolean fromUser) {
        }

        public void onStartTrackingTouch(@NonNull SeekBar seekBar) {
        }

        public void onStopTrackingTouch(@NonNull SeekBar seekBar) {
            int newProgress = seekBar.getProgress();
            if (newProgress != SettingSeekBarPreference.this.getProgress() && SettingSeekBarPreference.this.callChangeListener(newProgress)) {
                SettingSeekBarPreference.this.setProgress(newProgress);
            }
        }
    };
    private int maxProgress = 100;
    private boolean progressSet;
    private int progress;

    public SettingSeekBarPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingSeekBarPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.settingSeekBarPreferenceStyle);
    }

    public SettingSeekBarPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public SettingSeekBarPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingSeekBarPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex != R.styleable.SettingSeekBarPreference_android_max) continue;
            this.maxProgress = attributes.getInt(attrIndex, this.maxProgress);
        }
        attributes.recycle();
    }

    protected Object onGetDefaultValue(@NonNull TypedArray attributes, int index) {
        return attributes.getInt(index, this.progress);
    }

    protected void onSetInitialValue(@Nullable Object defaultValue) {
        this.setProgress(this.getPersistedInt(defaultValue == null ? 0 : (Integer)defaultValue));
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setProgress(int progress) {
        boolean changed;
        boolean bl = changed = this.progress != progress;
        if (changed || !this.progressSet) {
            this.progress = Math.min(progress, this.maxProgress);
            this.progressSet = true;
            this.persistInt(this.progress);
            if (changed) {
                this.notifyChanged();
            }
        }
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public void onBindViewHolder(@NonNull PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        holder.itemView.setClickable(false);
        SeekBar seekBar = (SeekBar)holder.findViewById(R.id.setting_seek_bar);
        if (seekBar != null) {
            seekBar.setOnSeekBarChangeListener(null);
            seekBar.setMax(this.maxProgress);
            seekBar.setProgress(this.progress);
            seekBar.setOnSeekBarChangeListener(this.listener);
        }
    }
}

