/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.content.Context;
import android.content.res.Resources;
import android.preference.PreferenceActivity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import universum.studios.android.setting.R;
import universum.studios.android.setting.content.SettingsResourceUtils;

public class SettingHeadersAdapter
extends BaseAdapter {
    public static final int NO_POSITION = -1;
    public static final long NO_ID = -1L;
    private static final int VIEW_TYPES_COUNT = 3;
    public static final int VIEW_TYPE_CATEGORY = 0;
    public static final int VIEW_TYPE_CATEGORY_DIVIDER = 1;
    public static final int VIEW_TYPE_HEADER = 2;
    private final Context context;
    private final Resources resources;
    private final LayoutInflater layoutInflater;
    private boolean useVectorIcons;
    private List<PreferenceActivity.Header> headers;
    private List<Item> items;

    public SettingHeadersAdapter(@NonNull Context context) {
        this(context, new ArrayList<PreferenceActivity.Header>(0));
    }

    public SettingHeadersAdapter(@NonNull Context context, @NonNull PreferenceActivity.Header[] headers) {
        this(context, Arrays.asList(headers));
    }

    public SettingHeadersAdapter(@NonNull Context context, @NonNull List<PreferenceActivity.Header> headers) {
        this.context = context;
        this.resources = context.getResources();
        this.layoutInflater = LayoutInflater.from((Context)context);
        this.changeHeaders(headers);
    }

    public void setUseVectorIcons(boolean useVectorIcons) {
        if (this.useVectorIcons != useVectorIcons) {
            this.useVectorIcons = useVectorIcons;
            this.notifyDataSetChanged();
        }
    }

    public void changeHeaders(@Nullable List<PreferenceActivity.Header> headers) {
        this.swapHeaders(headers);
    }

    @Nullable
    public List<PreferenceActivity.Header> swapHeaders(@Nullable List<PreferenceActivity.Header> headers) {
        List<PreferenceActivity.Header> oldHeaders = this.headers;
        this.headers = headers;
        this.items = headers == null || headers.isEmpty() ? null : SettingHeadersAdapter.createItemsFromHeaders(headers);
        return oldHeaders;
    }

    private static List<Item> createItemsFromHeaders(List<PreferenceActivity.Header> headers) {
        ArrayList<Item> items = new ArrayList<Item>(headers.size());
        int headersCount = headers.size();
        for (int i = 0; i < headersCount; ++i) {
            PreferenceActivity.Header header = headers.get(i);
            if (SettingHeadersAdapter.isCategoryHeader(header)) {
                if (i > 0) {
                    items.add(new Item(1, null));
                }
                items.add(new Item(0, header));
                continue;
            }
            Item item = new Item(2, header);
            item.showDivider = i < headersCount - 1 && !SettingHeadersAdapter.isCategoryHeader(headers.get(i + 1));
            items.add(item);
        }
        items.add(new Item(1, null));
        return items;
    }

    public int getCount() {
        return this.items == null ? 0 : this.items.size();
    }

    public boolean hasItemAt(int position) {
        return position >= 0 && position < this.getCount();
    }

    @NonNull
    public Item getItem(int position) {
        if (!this.hasItemAt(position)) {
            throw new IndexOutOfBoundsException("Requested item at invalid position(" + position + "). Data set has items in count of(" + this.getCount() + ").");
        }
        return this.items.get(position);
    }

    public boolean hasStableIds() {
        return true;
    }

    public long getItemId(int position) {
        return this.hasItemAt(position) ? (long)position : -1L;
    }

    private static boolean isCategoryHeader(PreferenceActivity.Header header) {
        return TextUtils.isEmpty((CharSequence)header.fragment) && header.intent == null;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getItemViewType(int position) {
        if (this.isCategoryAt(position)) {
            return 0;
        }
        if (this.isCategoryDividerAt(position)) {
            return 1;
        }
        return 2;
    }

    public boolean isEnabled(int position) {
        return this.isHeaderAt(position);
    }

    public boolean isHeaderAt(int position) {
        return this.hasItemAtViewTypeOf(position, 2);
    }

    public boolean isCategoryAt(int position) {
        return this.hasItemAtViewTypeOf(position, 0);
    }

    public boolean isCategoryDividerAt(int position) {
        return this.hasItemAtViewTypeOf(position, 1);
    }

    private boolean hasItemAtViewTypeOf(int position, int viewType) {
        Item item = this.hasItemAt(position) ? this.getItem(position) : null;
        return item != null && item.viewType == viewType;
    }

    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        ViewHolder viewHolder;
        View view = convertView;
        if (view == null) {
            viewHolder = this.onCreateViewHolder(parent, this.getItemViewType(position));
            view = viewHolder.itemView;
            view.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)view.getTag();
        }
        viewHolder.updateAdapterPosition(position);
        this.onBindViewHolder(viewHolder, position);
        return view;
    }

    @NonNull
    protected ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                return new CategoryHolder(this.inflateView(R.layout.setting_category_header, parent));
            }
            case 1: {
                return new CategoryDividerHolder(this.inflateView(R.layout.setting_category_divider, parent));
            }
            case 2: {
                return new HeaderHolder(this.inflateView(R.layout.setting_header, parent));
            }
        }
        throw SettingHeadersAdapter.unknownViewTypeAtPositionException(viewType, -1);
    }

    @NonNull
    public View inflateView(@LayoutRes int resource, @Nullable ViewGroup parent) {
        return this.layoutInflater.inflate(resource, parent, false);
    }

    protected void onBindViewHolder(@NonNull ViewHolder viewHolder, int position) {
        switch (viewHolder.getItemViewType()) {
            case 0: {
                PreferenceActivity.Header categoryHeader = this.getItem((int)position).header;
                ((CategoryHolder)viewHolder).title.setText(categoryHeader.getTitle(this.resources));
                break;
            }
            case 1: {
                CategoryDividerHolder dividerHolder = (CategoryDividerHolder)viewHolder;
                dividerHolder.shadowBottom.setVisibility(position == this.getCount() - 1 ? 8 : 0);
                break;
            }
            case 2: {
                Item item = this.getItem(position);
                HeaderHolder headerHolder = (HeaderHolder)viewHolder;
                if (item.header.iconRes == 0) {
                    headerHolder.iconFrame.setVisibility(8);
                } else {
                    headerHolder.iconFrame.setVisibility(0);
                    if (this.useVectorIcons) {
                        headerHolder.icon.setImageDrawable(SettingsResourceUtils.getVectorDrawable(this.resources, item.header.iconRes, this.context.getTheme()));
                    } else {
                        headerHolder.icon.setImageResource(item.header.iconRes);
                    }
                }
                headerHolder.title.setText(item.header.getTitle(this.resources));
                CharSequence summary = item.header.getSummary(this.resources);
                if (TextUtils.isEmpty((CharSequence)summary)) {
                    headerHolder.summary.setVisibility(8);
                } else {
                    headerHolder.summary.setVisibility(0);
                    headerHolder.summary.setText(summary);
                }
                headerHolder.divider.setVisibility(item.showDivider ? 0 : 8);
                break;
            }
            default: {
                throw SettingHeadersAdapter.unknownViewTypeAtPositionException(viewHolder.getItemViewType(), position);
            }
        }
    }

    private static IllegalArgumentException unknownViewTypeAtPositionException(int viewType, int position) {
        return new IllegalArgumentException("Unknown view type(" + viewType + ") at(" + (position == -1 ? "UNSPECIFIED" : Integer.valueOf(position)) + ")!");
    }

    public static class HeaderHolder
    extends ViewHolder {
        public final View iconFrame;
        public final ImageView icon;
        public final TextView title;
        public final TextView summary;
        public final View divider;

        public HeaderHolder(@NonNull View itemView) {
            super(itemView, 2);
            this.iconFrame = itemView.findViewById(R.id.setting_icon_frame);
            this.icon = (ImageView)itemView.findViewById(16908294);
            this.title = (TextView)itemView.findViewById(16908310);
            this.summary = (TextView)itemView.findViewById(0x1020010);
            this.divider = itemView.findViewById(R.id.setting_divider);
        }
    }

    public static class CategoryDividerHolder
    extends ViewHolder {
        public final View shadowTop;
        public final View shadowBottom;

        public CategoryDividerHolder(@NonNull View itemView) {
            super(itemView, 1);
            this.shadowTop = itemView.findViewById(R.id.setting_category_divider_shadow_top);
            this.shadowBottom = itemView.findViewById(R.id.setting_category_divider_shadow_bottom);
        }
    }

    public static class CategoryHolder
    extends ViewHolder {
        public final TextView title;

        public CategoryHolder(@NonNull View itemView) {
            super(itemView, 0);
            this.title = (TextView)itemView.findViewById(16908310);
        }
    }

    public static abstract class ViewHolder {
        public static final int BASIC_TYPE = 0;
        @NonNull
        public final View itemView;
        final int mItemViewType;
        int mAdapterPosition = -1;

        public ViewHolder(@NonNull View itemView) {
            this(itemView, 0);
        }

        public ViewHolder(@NonNull View itemView, int itemViewType) {
            this.itemView = itemView;
            this.mItemViewType = itemViewType;
        }

        public final int getItemViewType() {
            return this.mItemViewType;
        }

        final void updateAdapterPosition(int position) {
            this.mAdapterPosition = position;
        }

        public final int getAdapterPosition() {
            return this.mAdapterPosition;
        }
    }

    public static final class Item {
        final int viewType;
        final PreferenceActivity.Header header;
        boolean showDivider;

        Item(int viewType, PreferenceActivity.Header header) {
            this.viewType = viewType;
            this.header = header;
        }

        @NonNull
        public PreferenceActivity.Header getHeader() {
            return this.header;
        }
    }
}

