/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.preference.Preference;
import androidx.preference.PreferenceCategory;
import androidx.preference.PreferenceScreen;
import universum.studios.android.dialog.Dialog;
import universum.studios.android.dialog.manage.DialogController;
import universum.studios.android.dialog.manage.DialogFactory;
import universum.studios.android.dialog.manage.DialogXmlFactory;
import universum.studios.android.setting.R;
import universum.studios.android.setting.SettingDialogPreference;

@SuppressLint(value={"LongLogTag"})
public class SettingDialogPreferenceManager
implements SettingDialogPreference.OnClickListener {
    private static final String TAG = "SettingDialogPreferenceManager";
    private DialogController dialogController;
    private DialogFactory dialogFactory;
    private boolean attachedToPreferenceScreen;
    private SparseArray<SettingDialogPreference> dialogPreferences;

    public SettingDialogPreferenceManager() {
        this(null, null);
    }

    public SettingDialogPreferenceManager(@NonNull FragmentActivity activity) {
        this(DialogController.create((FragmentActivity)activity), (DialogFactory)new DialogXmlFactory((Context)activity, R.xml.setting_dialogs));
    }

    public SettingDialogPreferenceManager(@NonNull Fragment fragment) {
        this(DialogController.create((Fragment)fragment), (DialogFactory)new DialogXmlFactory(fragment.requireContext(), R.xml.setting_dialogs));
    }

    public SettingDialogPreferenceManager(@NonNull FragmentManager fragmentManager) {
        this(new DialogController(fragmentManager), null);
    }

    private SettingDialogPreferenceManager(DialogController dialogController, DialogFactory dialogFactory) {
        this.dialogController = dialogController;
        this.dialogFactory = dialogFactory;
        if (this.dialogController != null && this.dialogFactory != null) {
            this.dialogController.setFactory(this.dialogFactory);
        }
    }

    public void setDialogController(@NonNull DialogController dialogController) {
        this.dialogController = dialogController;
        if (!this.dialogController.hasFactory()) {
            this.dialogController.setFactory(this.dialogFactory);
        }
    }

    @Nullable
    public DialogController getDialogController() {
        return this.dialogController;
    }

    public void setDialogFactory(@Nullable DialogFactory factory) {
        this.dialogFactory = factory;
        if (this.dialogController != null) {
            this.dialogController.setFactory(factory);
        }
    }

    @Nullable
    public DialogFactory getDialogFactory() {
        return this.dialogFactory;
    }

    public void attachToPreferenceScreen(@NonNull PreferenceScreen screen) {
        if (this.attachedToPreferenceScreen) {
            throw new IllegalStateException("Already attached to preference screen! Detach via detachFromPreferenceScreen(...) first.");
        }
        int preferenceCount = screen.getPreferenceCount();
        this.dialogPreferences = new SparseArray(preferenceCount);
        for (int i = 0; i < preferenceCount; ++i) {
            this.attachToPreference(screen.getPreference(i));
        }
        this.attachedToPreferenceScreen = true;
    }

    private void attachToPreference(Preference preference) {
        if (preference instanceof SettingDialogPreference) {
            SettingDialogPreference dialogPreference = (SettingDialogPreference)preference;
            int dialogId = dialogPreference.getDialogId();
            if (dialogId != -1) {
                this.dialogPreferences.put(dialogId, (Object)dialogPreference);
                dialogPreference.setOnClickListener(this);
                this.onAttachedToPreference(dialogPreference);
            } else {
                Log.w((String)TAG, (String)("Found preference(" + ((Object)((Object)dialogPreference)).getClass().getSimpleName() + ") without dialog id!"));
            }
        } else if (preference instanceof PreferenceCategory) {
            PreferenceCategory preferenceCategory = (PreferenceCategory)preference;
            int preferenceCount = preferenceCategory.getPreferenceCount();
            for (int i = 0; i < preferenceCount; ++i) {
                this.attachToPreference(preferenceCategory.getPreference(i));
            }
        }
    }

    protected void onAttachedToPreference(@NonNull SettingDialogPreference preference) {
    }

    @Nullable
    public SettingDialogPreference findDialogPreference(int dialogId) {
        return this.dialogPreferences == null ? null : (SettingDialogPreference)((Object)this.dialogPreferences.get(dialogId));
    }

    public void detachFromPreferenceScreen(@NonNull PreferenceScreen screen) {
        if (this.attachedToPreferenceScreen) {
            for (int i = 0; i < this.dialogPreferences.size(); ++i) {
                SettingDialogPreference preference = (SettingDialogPreference)((Object)this.dialogPreferences.get(this.dialogPreferences.keyAt(i)));
                preference.setOnClickListener(null);
                this.onDetachedFromPreference(preference);
            }
            this.dialogPreferences = null;
            this.attachedToPreferenceScreen = false;
        }
    }

    protected void onDetachedFromPreference(@NonNull SettingDialogPreference preference) {
    }

    @Override
    public boolean onDialogPreferenceClick(@NonNull SettingDialogPreference preference) {
        int dialogId = preference.getDialogId();
        if (dialogId != -1) {
            if (this.dialogController == null) {
                throw new IllegalStateException("No dialog controller specified!");
            }
            DialogFactory dialogFactory = this.dialogController.getFactory();
            if (dialogFactory == null) {
                throw new IllegalStateException("No dialog factory specified to provide dialogs for preferences!");
            }
            if (!dialogFactory.isDialogProvided(dialogId)) {
                Log.w((String)TAG, (String)("Clicked preference(" + ((Object)((Object)preference)).getClass().getSimpleName() + ") with dialog id(" + dialogId + ") but the current dialog factory does not provide dialog with such id!"));
                return false;
            }
            return this.onShowPreferenceDialog(this.dialogController, preference);
        }
        Log.w((String)TAG, (String)("Clicked preference(" + ((Object)((Object)preference)).getClass().getSimpleName() + ") with not specified dialog id!"));
        return false;
    }

    protected boolean onShowPreferenceDialog(@NonNull DialogController dialogController, @NonNull SettingDialogPreference preference) {
        return dialogController.newRequest(preference.getDialogId()).options(preference.getDialogOptions()).execute() != null;
    }

    public boolean handlePreferenceDialogButtonClick(@NonNull Dialog dialog, int button) {
        if (this.attachedToPreferenceScreen) {
            int dialogId = dialog.getDialogId();
            SettingDialogPreference dialogPreference = this.findDialogPreference(dialogId);
            if (dialogPreference == null) {
                Log.w((String)TAG, (String)("No preference found for the clicked button of dialog with id(" + dialogId + ")!"));
                return false;
            }
            return dialogPreference.handleDialogButtonClick(dialog, button);
        }
        return false;
    }
}

