/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import universum.studios.android.dialog.DatePickerDialog;
import universum.studios.android.dialog.Dialog;
import universum.studios.android.setting.R;
import universum.studios.android.setting.SettingDateTimeDialogPreference;

public final class SettingDateDialogPreference
extends SettingDateTimeDialogPreference<DatePickerDialog.DateOptions> {
    @VisibleForTesting
    static final String DEFAULT_FORMAT_PATTERN = "MMM dd, yyyy";

    public SettingDateDialogPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingDateDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.settingDateDialogPreferenceStyle);
    }

    public SettingDateDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public SettingDateDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    private static Long parseDate(String dateString) {
        return TextUtils.isEmpty((CharSequence)dateString) ? null : DatePickerDialog.DateParser.parse((String)dateString);
    }

    @Override
    @NonNull
    protected DatePickerDialog.DateOptions onCreateDialogOptions(@NonNull Resources resources) {
        return new DatePickerDialog.DateOptions(resources);
    }

    @Override
    protected void onConfigureDialogOptions(@NonNull DatePickerDialog.DateOptions options, @NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super.onConfigureDialogOptions(options, context, attrs, defStyleAttr, defStyleRes);
        String formatPattern = DEFAULT_FORMAT_PATTERN;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingDateDialogPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            Long date;
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingDateDialogPreference_settingDateFormat) {
                String dateFormat = attributes.getString(attrIndex);
                formatPattern = TextUtils.isEmpty((CharSequence)dateFormat) ? formatPattern : dateFormat;
                continue;
            }
            if (attrIndex == R.styleable.SettingDateDialogPreference_dialogDate) {
                date = SettingDateDialogPreference.parseDate(attributes.getString(attrIndex));
                if (date == null) continue;
                options.date(date.longValue());
                continue;
            }
            if (attrIndex == R.styleable.SettingDateDialogPreference_dialogDateMin) {
                date = SettingDateDialogPreference.parseDate(attributes.getString(attrIndex));
                if (date == null) continue;
                options.minDate(date.longValue());
                continue;
            }
            if (attrIndex != R.styleable.SettingDateDialogPreference_dialogDateMax || (date = SettingDateDialogPreference.parseDate(attributes.getString(attrIndex))) == null) continue;
            options.maxDate(date.longValue());
        }
        attributes.recycle();
        this.setFormat(new SimpleDateFormat(formatPattern, Locale.getDefault()));
    }

    @Override
    long onParseDefaultValue(@NonNull Object defaultValue) {
        Long date = SettingDateDialogPreference.parseDate((String)defaultValue);
        return date == null ? 0L : date;
    }

    public void setDate(@Nullable Date date) {
        this.setDate(date == null ? 0L : date.getTime());
    }

    public void setDate(long dateInMillis) {
        this.setMilliseconds(dateInMillis);
    }

    @Nullable
    public Date getDate() {
        return this.areMillisecondsSet() ? new Date(this.getDateInMillis()) : null;
    }

    public long getDateInMillis() {
        return this.getMilliseconds();
    }

    @Override
    @NonNull
    public DatePickerDialog.DateOptions getDialogOptions() {
        DatePickerDialog.DateOptions options = (DatePickerDialog.DateOptions)super.getDialogOptions();
        if (this.areMillisecondsSet()) {
            options.date(this.getDateInMillis());
        }
        return options;
    }

    @Override
    protected boolean onHandleDialogButtonClick(@NonNull Dialog dialog, int button) {
        if (dialog instanceof DatePickerDialog) {
            switch (button) {
                case 1: {
                    long newDate = ((DatePickerDialog)dialog).getDate();
                    if (newDate != this.getDateInMillis() && this.callChangeListener(newDate)) {
                        this.setDate(newDate);
                    }
                    return true;
                }
            }
            return true;
        }
        return super.onHandleDialogButtonClick(dialog, button);
    }
}

