/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.preference.CheckBoxPreference;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import universum.studios.android.setting.PreferenceDecorator;

public class SettingCheckBoxPreference
extends CheckBoxPreference {
    private PreferenceDecorator decorator;

    public SettingCheckBoxPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingCheckBoxPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 16842895);
    }

    public SettingCheckBoxPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.ensureDecorator();
    }

    @TargetApi(value=21)
    public SettingCheckBoxPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.ensureDecorator();
    }

    private void ensureDecorator() {
        if (this.decorator == null) {
            this.decorator = new PreferenceDecorator((Preference)this){

                @Override
                @Nullable
                Object onGetDefaultValue(@NonNull TypedArray attributes, int index) {
                    return SettingCheckBoxPreference.this.onGetDefaultValue(attributes, index);
                }

                @Override
                void onUpdateInitialValue(@Nullable Object defaultValue) {
                    SettingCheckBoxPreference.this.onSetInitialValue(defaultValue);
                }
            };
        }
    }

    public void setKey(@NonNull String key) {
        boolean changed = !key.equals(this.getKey());
        super.setKey(key);
        if (changed) {
            this.ensureDecorator();
            this.decorator.handleKeyChange();
        }
    }

    public void onBindViewHolder(@NonNull PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        this.ensureDecorator();
        this.decorator.onBindViewHolder(holder);
    }
}

