/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.content.Context;
import android.os.Build;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.XmlRes;
import androidx.core.app.ActivityCompat;
import androidx.preference.PreferenceFragmentCompat;

public abstract class SettingsBaseFragment
extends PreferenceFragmentCompat {
    private boolean pendingBindPreferencesRequest;
    private boolean preferencesAdded;

    @CheckResult
    protected int checkSelfPermission(@NonNull String permission) {
        return ActivityCompat.checkSelfPermission((Context)this.requireContext(), (String)permission);
    }

    @CheckResult
    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        return Build.VERSION.SDK_INT >= 23 && super.shouldShowRequestPermissionRationale(permission);
    }

    protected void supportRequestPermissions(@NonNull String[] permissions, int requestCode) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(permissions, requestCode);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void addPreferencesFromResource(@XmlRes int preferencesResId) {
        super.addPreferencesFromResource(preferencesResId);
        this.handlePreferencesAdded();
    }

    private void handlePreferencesAdded() {
        this.preferencesAdded = true;
        this.onPreferencesAdded();
    }

    protected void onPreferencesAdded() {
        if (this.pendingBindPreferencesRequest) {
            this.pendingBindPreferencesRequest = false;
            this.onBindPreferences();
        }
    }

    protected void requestBindPreferences() {
        if (this.preferencesAdded) {
            this.onBindPreferences();
        } else {
            this.pendingBindPreferencesRequest = true;
        }
    }

    protected void onBindPreferences() {
    }
}

