/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.annotation.ArrayRes;
import androidx.annotation.AttrRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.preference.PreferenceViewHolder;
import java.util.Arrays;
import universum.studios.android.setting.R;
import universum.studios.android.setting.SettingPreference;

public class SettingSpinnerPreference
extends SettingPreference {
    private final AdapterView.OnItemSelectedListener listener = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(@NonNull AdapterView<?> parent, @NonNull View view, int position, long id2) {
            SettingSpinnerPreference.this.setValueIndex(position);
        }

        public void onNothingSelected(@NonNull AdapterView<?> parent) {
        }
    };
    private CharSequence[] entries;
    private String[] entryValues;
    private boolean valueSet;
    private String value;
    private EntriesAdapter adapter;
    private Spinner spinner;

    public SettingSpinnerPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingSpinnerPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.settingSpinnerPreferenceStyle);
    }

    public SettingSpinnerPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public SettingSpinnerPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.adapter = new EntriesAdapter(context);
        this.adapter.setTitle(this.getTitle());
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingSpinnerPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingSpinnerPreference_android_entries) {
                this.setEntries(attributes.getTextArray(attrIndex));
                continue;
            }
            if (attrIndex == R.styleable.SettingSpinnerPreference_android_entryValues) {
                int valuesResId = attributes.getResourceId(attrIndex, -1);
                if (valuesResId == -1) continue;
                this.setEntryValues(valuesResId);
                continue;
            }
            if (attrIndex == R.styleable.SettingSpinnerPreference_settingSpinnerViewLayout) {
                this.adapter.setViewLayoutResource(attributes.getResourceId(attrIndex, R.layout.setting_spinner_view));
                continue;
            }
            if (attrIndex != R.styleable.SettingSpinnerPreference_settingSpinnerDropDownViewLayout) continue;
            this.adapter.setDropDownViewLayoutResource(attributes.getResourceId(attrIndex, R.layout.setting_spinner_drop_down_view));
        }
        attributes.recycle();
    }

    protected Object onGetDefaultValue(@NonNull TypedArray attributes, int index) {
        return attributes.getString(index);
    }

    protected void onSetInitialValue(@Nullable Object defaultValue) {
        this.setValue(this.getPersistedString((String)defaultValue));
    }

    public void setTitle(@Nullable CharSequence title) {
        super.setTitle(title);
        this.adapter.setTitle(title);
    }

    public void setEntries(@ArrayRes int resId) {
        this.setEntries(this.getContext().getResources().getTextArray(resId));
    }

    public void setEntries(@Nullable CharSequence[] entries) {
        this.entries = entries;
        this.adapter.setNotifyOnChange(false);
        this.adapter.clear();
        if (entries != null) {
            this.adapter.addAll(Arrays.asList(entries));
        }
        this.adapter.setNotifyOnChange(true);
        this.adapter.notifyDataSetChanged();
    }

    @Nullable
    public CharSequence[] getEntries() {
        return this.entries;
    }

    public void setEntryValues(@ArrayRes int resId) {
        this.setEntryValues(this.getContext().getResources().getStringArray(resId));
    }

    public void setEntryValues(@Nullable String[] entryValues) {
        this.entryValues = entryValues;
    }

    @Nullable
    public String[] getEntryValues() {
        return this.entryValues;
    }

    void setValueIndex(int index) {
        if (this.entryValues != null && index < this.entryValues.length) {
            String newValue = this.entryValues[index];
            if (index != this.getValueIndex() && this.callChangeListener(newValue)) {
                this.setValue(newValue);
            }
        }
    }

    @VisibleForTesting
    int getValueIndex() {
        if (TextUtils.isEmpty((CharSequence)this.value) || this.entryValues == null || this.entryValues.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.entryValues.length; ++i) {
            if (!TextUtils.equals((CharSequence)this.value, (CharSequence)this.entryValues[i])) continue;
            return i;
        }
        return -1;
    }

    public void setValue(@Nullable String value) {
        boolean changed;
        boolean bl = changed = !TextUtils.equals((CharSequence)this.value, (CharSequence)value);
        if (changed || !this.valueSet) {
            this.value = value;
            this.valueSet = true;
            this.persistString(this.value);
            if (changed) {
                this.notifyChanged();
            }
        }
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @Override
    public void onBindViewHolder(@NonNull PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        Spinner spinner = (Spinner)holder.findViewById(R.id.setting_spinner);
        if (spinner != null) {
            spinner.setOnItemSelectedListener(null);
            spinner.setAdapter((SpinnerAdapter)this.adapter);
            int valueIndex = this.getValueIndex();
            if (valueIndex != -1) {
                spinner.setSelection(valueIndex, false);
            }
            spinner.setOnItemSelectedListener(this.listener);
            this.spinner = spinner;
        }
    }

    protected void onClick() {
        super.onClick();
        if (this.spinner != null) {
            this.spinner.performClick();
        }
    }

    protected void onPrepareForRemoval() {
        super.onPrepareForRemoval();
        if (this.spinner != null) {
            this.spinner.setOnItemSelectedListener(null);
        }
        this.spinner = null;
    }

    private static final class EntryDropDownViewHolder
    extends ViewHolder {
        final TextView textView;

        EntryDropDownViewHolder(@NonNull View itemView) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(16908308);
        }
    }

    private static final class EntryViewHolder
    extends ViewHolder {
        final TextView titleView;
        final TextView summaryView;

        EntryViewHolder(@NonNull View itemView) {
            super(itemView);
            this.titleView = (TextView)itemView.findViewById(16908310);
            this.summaryView = (TextView)itemView.findViewById(0x1020010);
        }
    }

    private static abstract class ViewHolder {
        final View itemView;

        ViewHolder(@NonNull View itemView) {
            this.itemView = itemView;
        }
    }

    @VisibleForTesting
    static final class EntriesAdapter
    extends ArrayAdapter<CharSequence> {
        static final int NO_POSITION = -1;
        private final LayoutInflater layoutInflater;
        private CharSequence title;
        private int viewLayoutResource = R.layout.setting_spinner_view;
        private int dropDownViewLayoutResource = R.layout.setting_spinner_drop_down_view;

        EntriesAdapter(Context context) {
            super(context, 17367048);
            this.layoutInflater = LayoutInflater.from((Context)context);
        }

        void setTitle(@Nullable CharSequence title) {
            if (!TextUtils.equals((CharSequence)this.title, (CharSequence)title)) {
                this.title = title;
                this.notifyDataSetChanged();
            }
        }

        void setViewLayoutResource(@LayoutRes int layoutResource) {
            this.viewLayoutResource = layoutResource;
            if (!this.isEmpty()) {
                this.notifyDataSetChanged();
            }
        }

        void setDropDownViewLayoutResource(@LayoutRes int layoutResource) {
            this.dropDownViewLayoutResource = layoutResource;
            if (!this.isEmpty()) {
                this.notifyDataSetChanged();
            }
        }

        @NonNull
        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            EntryViewHolder viewHolder;
            View view = convertView;
            if (view == null) {
                viewHolder = new EntryViewHolder(this.inflateView(this.viewLayoutResource, parent));
                view = viewHolder.itemView;
                view.setTag((Object)viewHolder);
            } else {
                viewHolder = (EntryViewHolder)view.getTag();
            }
            viewHolder.titleView.setText(this.title);
            viewHolder.summaryView.setText((CharSequence)this.getItem(position));
            return view;
        }

        public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            EntryDropDownViewHolder viewHolder;
            View view = convertView;
            if (view == null) {
                viewHolder = new EntryDropDownViewHolder(this.inflateView(this.dropDownViewLayoutResource, parent));
                view = viewHolder.itemView;
                view.setTag((Object)viewHolder);
            } else {
                viewHolder = (EntryDropDownViewHolder)view.getTag();
            }
            viewHolder.textView.setText((CharSequence)this.getItem(position));
            return view;
        }

        private View inflateView(@LayoutRes int resource, @Nullable ViewGroup parent) {
            return this.layoutInflater.inflate(resource, parent, false);
        }
    }
}

