/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.ArrayRes;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.preference.PreferenceViewHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import universum.studios.android.dialog.Dialog;
import universum.studios.android.dialog.SelectionDialog;
import universum.studios.android.dialog.adapter.DialogSelectionAdapter;
import universum.studios.android.setting.R;
import universum.studios.android.setting.SettingDialogPreference;

public class SettingSelectionDialogPreference
extends SettingDialogPreference<SelectionDialog.SelectionOptions> {
    private static final String SUMMARY_ENTRIES_SEPARATOR = ", ";
    private CharSequence[] entries;
    private String[] entryValues;
    private boolean selectionSet;
    private long[] selection;
    private List<DialogSelectionAdapter.Item> dialogItems;
    private SummaryTextBuilder summaryTextBuilder;

    public SettingSelectionDialogPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingSelectionDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.settingSelectionDialogPreferenceStyle);
    }

    public SettingSelectionDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public SettingSelectionDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    @Nullable
    public static String[] createEntryValuesFromPersistedValues(@NonNull String persistedValues) {
        try {
            JSONArray persistedArray = new JSONArray(persistedValues);
            String[] selectedValues = new String[persistedArray.length()];
            for (int i = 0; i < persistedArray.length(); ++i) {
                selectedValues[i] = persistedArray.getString(i);
            }
            return selectedValues;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.summaryTextBuilder = new DefaultSummaryTextBuilder(SUMMARY_ENTRIES_SEPARATOR);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingSelectionDialogPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int valuesResId;
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingSelectionDialogPreference_android_entries) {
                this.setEntries(attributes.getTextArray(attrIndex));
                continue;
            }
            if (attrIndex != R.styleable.SettingSelectionDialogPreference_android_entryValues || (valuesResId = attributes.getResourceId(attrIndex, -1)) == -1) continue;
            this.setEntryValues(valuesResId);
        }
        attributes.recycle();
    }

    protected Object onGetDefaultValue(@NonNull TypedArray typedArray, int index) {
        return typedArray.getString(index);
    }

    protected void onSetInitialValue(@Nullable Object defaultValue) {
        String persistedValues = this.getPersistedString((String)defaultValue);
        if (persistedValues != null) {
            this.setSelection(this.createSelectionFromPersistedValues(persistedValues));
        }
    }

    @Override
    @NonNull
    protected SelectionDialog.SelectionOptions onCreateDialogOptions(@NonNull Resources resources) {
        return ((SelectionDialog.SelectionOptions)new SelectionDialog.SelectionOptions(resources).title(this.getTitle())).selectionMode(1).emptySelectionAllowed(true);
    }

    @Override
    protected void onConfigureDialogOptions(@NonNull SelectionDialog.SelectionOptions options, @NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super.onConfigureDialogOptions(options, context, attrs, defStyleAttr, defStyleRes);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingSelectionDialogPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingSelectionDialogPreference_dialogSelectionMode) {
                options.selectionMode(attributes.getInt(attrIndex, options.selectionMode()));
                continue;
            }
            if (attrIndex != R.styleable.SettingSelectionDialogPreference_dialogEmptySelectionAllowed) continue;
            options.emptySelectionAllowed(attributes.getBoolean(attrIndex, options.shouldAllowEmptySelection()));
        }
        attributes.recycle();
    }

    public void setSummaryTextBuilder(@Nullable SummaryTextBuilder textBuilder) {
        this.summaryTextBuilder = textBuilder == null ? new DefaultSummaryTextBuilder(SUMMARY_ENTRIES_SEPARATOR) : textBuilder;
    }

    public void setEntries(@ArrayRes int resId) {
        this.setEntries(this.getContext().getResources().getTextArray(resId));
    }

    public void setEntries(@Nullable CharSequence[] entries) {
        this.entries = entries;
        if (entries == null) {
            this.dialogItems = null;
        } else {
            this.dialogItems = new ArrayList<DialogSelectionAdapter.Item>(entries.length);
            for (int i = 0; i < entries.length; ++i) {
                CharSequence entry = entries[i];
                this.dialogItems.add((DialogSelectionAdapter.Item)new SelectionDialog.TextItem(i, entry));
            }
        }
    }

    @Nullable
    public CharSequence[] getEntries() {
        return this.entries;
    }

    public void setEntryValues(@ArrayRes int resId) {
        this.setEntryValues(this.getContext().getResources().getStringArray(resId));
    }

    public void setEntryValues(@Nullable String[] entryValues) {
        this.entryValues = entryValues;
    }

    @Nullable
    public String[] getEntryValues() {
        return this.entryValues;
    }

    private long[] createSelectionFromPersistedValues(String persistedValues) {
        try {
            JSONArray persistedArray = new JSONArray(persistedValues);
            long[] selection = new long[persistedArray.length()];
            block2: for (int i = 0; i < persistedArray.length(); ++i) {
                String selectedValue = persistedArray.getString(i);
                for (int j = 0; j < this.entryValues.length; ++j) {
                    if (!this.entryValues[j].equals(selectedValue)) continue;
                    selection[i] = j;
                    continue block2;
                }
            }
            return selection;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String createPersistableValuesFromSelection(long[] selection) {
        JSONArray persistableArray = new JSONArray();
        if (selection != null && selection.length > 0) {
            for (long itemIndex : selection) {
                if ((int)itemIndex >= this.entryValues.length) continue;
                persistableArray.put((Object)this.entryValues[(int)itemIndex]);
            }
        }
        return persistableArray.toString();
    }

    public void setSelection(@Nullable long[] selection) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(this.selection, selection);
        if (changed || !this.selectionSet) {
            this.selection = selection;
            this.selectionSet = true;
            this.persistString(this.createPersistableValuesFromSelection(selection));
            if (changed) {
                this.notifyChanged();
            }
        }
    }

    @Nullable
    public long[] getSelection() {
        return this.selection;
    }

    @Nullable
    public String[] getSelectedEntryValues() {
        if (this.selectionSet) {
            String[] selectedValues = new String[this.selection.length];
            for (int i = 0; i < this.selection.length; ++i) {
                selectedValues[i] = this.entryValues[(int)this.selection[i]];
            }
            return selectedValues;
        }
        return null;
    }

    @Override
    public void onBindViewHolder(@NonNull PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        this.synchronizeSummaryView(holder);
    }

    @Override
    @Nullable
    protected CharSequence onGetSummaryText() {
        if (this.selectionSet && this.selection.length > 0) {
            this.summaryTextBuilder.clear();
            for (long itemIndex : this.selection) {
                this.summaryTextBuilder.appendEntry(this.entries[(int)itemIndex]);
            }
            return this.summaryTextBuilder.build();
        }
        return super.onGetSummaryText();
    }

    @Override
    @NonNull
    public SelectionDialog.SelectionOptions getDialogOptions() {
        SelectionDialog.SelectionOptions options = (SelectionDialog.SelectionOptions)super.getDialogOptions();
        options.items(this.dialogItems);
        if (this.selectionSet) {
            options.selection(this.selection);
        }
        return options;
    }

    @Override
    protected boolean onHandleDialogButtonClick(@NonNull Dialog dialog, int button) {
        if (dialog instanceof SelectionDialog) {
            switch (button) {
                case 1: {
                    long[] newSelection = ((SelectionDialog)dialog).getSelection();
                    String[] newValues = SettingSelectionDialogPreference.createEntryValuesFromPersistedValues(this.createPersistableValuesFromSelection(newSelection));
                    if (this.callChangeListener(newValues)) {
                        this.setSelection(newSelection);
                    }
                    return true;
                }
            }
            return true;
        }
        return super.onHandleDialogButtonClick(dialog, button);
    }

    private static final class DefaultSummaryTextBuilder
    implements SummaryTextBuilder {
        private final StringBuilder builder = new StringBuilder(64);
        private final String separator;

        DefaultSummaryTextBuilder(@NonNull String separator) {
            this.separator = separator;
        }

        @Override
        public SummaryTextBuilder clear() {
            this.builder.setLength(0);
            return this;
        }

        @Override
        public SummaryTextBuilder appendEntry(@NonNull CharSequence entry) {
            if (this.builder.length() > 0) {
                this.builder.append(this.separator);
            }
            this.builder.append(entry);
            return this;
        }

        @Override
        @NonNull
        public CharSequence build() {
            return this.builder.toString();
        }
    }

    public static interface SummaryTextBuilder {
        public SummaryTextBuilder clear();

        public SummaryTextBuilder appendEntry(@NonNull CharSequence var1);

        @NonNull
        public CharSequence build();
    }
}

