/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import universum.studios.android.setting.PreferenceDecorator;

public class SettingPreference
extends Preference {
    private PreferenceDecorator decorator;

    public SettingPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 16842894);
    }

    public SettingPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public SettingPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.ensureDecorator();
        this.decorator.processAttributes(context, attrs, defStyleAttr, defStyleRes);
    }

    private void ensureDecorator() {
        if (this.decorator == null) {
            this.decorator = new PreferenceDecorator(this){

                @Override
                @Nullable
                Object onGetDefaultValue(@NonNull TypedArray attributes, int index) {
                    return SettingPreference.this.onGetDefaultValue(attributes, index);
                }

                @Override
                void onUpdateInitialValue(@Nullable Object defaultValue) {
                    SettingPreference.this.onSetInitialValue(defaultValue);
                }
            };
        }
    }

    public void setKey(@NonNull String key) {
        boolean changed = !key.equals(this.getKey());
        super.setKey(key);
        if (changed) {
            this.decorator.handleKeyChange();
        }
    }

    public void onBindViewHolder(@NonNull PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        this.ensureDecorator();
        this.decorator.onBindViewHolder(holder);
    }
}

