/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import universum.studios.android.dialog.Dialog;
import universum.studios.android.dialog.DialogOptions;
import universum.studios.android.setting.R;
import universum.studios.android.setting.SettingPreference;

public class SettingDialogPreference<O extends DialogOptions<O>>
extends SettingPreference {
    public static final int NO_DIALOG_ID = -1;
    private int dialogId = -1;
    private O dialogOptions;

    public SettingDialogPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0x1010091);
    }

    public SettingDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public SettingDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.dialogOptions = this.onCreateDialogOptions(context.getResources());
        this.onConfigureDialogOptions(this.dialogOptions, context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onConfigureDialogOptions(@NonNull O options, @NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingDialogPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingDialogPreference_dialogId) {
                this.dialogId = attributes.getResourceId(attrIndex, -1);
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogIcon) {
                options.icon(attributes.getResourceId(attrIndex, options.icon()));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogVectorIcon) {
                options.vectorIcon(attributes.getResourceId(attrIndex, options.vectorIcon()));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogTitle) {
                options.title(attributes.getText(attrIndex));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogContent) {
                options.content(attributes.getText(attrIndex));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogPositiveButton) {
                options.positiveButton(attributes.getText(attrIndex));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogNeutralButton) {
                options.neutralButton(attributes.getText(attrIndex));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogNegativeButton) {
                options.negativeButton(attributes.getText(attrIndex));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogButtonsWidthMode) {
                options.buttonsWidthMode(attributes.getInt(attrIndex, options.buttonsWidthMode()));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogCancelable) {
                options.cancelable(attributes.getBoolean(attrIndex, options.shouldBeCancelable()));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogDismissOnRestore) {
                options.dismissOnRestore(attributes.getBoolean(attrIndex, options.shouldDismissOnRestore()));
                continue;
            }
            if (attrIndex == R.styleable.SettingDialogPreference_dialogRemain) {
                options.remain(attributes.getBoolean(attrIndex, options.shouldRemain()));
                continue;
            }
            if (attrIndex != R.styleable.SettingDialogPreference_dialogTheme) continue;
            options.theme(attributes.getResourceId(attrIndex, options.theme()));
        }
        attributes.recycle();
    }

    @NonNull
    protected O onCreateDialogOptions(@NonNull Resources resources) {
        return (O)new DialogOptions(resources);
    }

    public void setOnClickListener(final @Nullable OnClickListener listener) {
        this.setOnPreferenceClickListener(listener == null ? null : new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(@NonNull Preference preference) {
                return listener.onDialogPreferenceClick((SettingDialogPreference)preference);
            }
        });
    }

    protected void synchronizeSummaryView(@NonNull PreferenceViewHolder holder) {
        TextView summaryView = (TextView)holder.findViewById(0x1020010);
        if (summaryView != null) {
            CharSequence summaryText = this.onGetSummaryText();
            if (TextUtils.isEmpty((CharSequence)summaryText)) {
                summaryView.setVisibility(8);
            } else {
                summaryView.setText(summaryText);
                summaryView.setVisibility(0);
            }
        }
    }

    @Nullable
    protected CharSequence onGetSummaryText() {
        return this.getSummary();
    }

    public void setDialogId(int dialogId) {
        this.dialogId = dialogId;
    }

    public int getDialogId() {
        return this.dialogId;
    }

    @NonNull
    public O getDialogOptions() {
        return this.dialogOptions;
    }

    public boolean handleDialogButtonClick(@NonNull Dialog dialog, int button) {
        return dialog.getDialogId() == this.dialogId && this.onHandleDialogButtonClick(dialog, button);
    }

    protected boolean onHandleDialogButtonClick(@NonNull Dialog dialog, int button) {
        return false;
    }

    public static interface OnClickListener {
        public boolean onDialogPreferenceClick(@NonNull SettingDialogPreference var1);
    }
}

