/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.preference.PreferenceViewHolder;
import java.text.SimpleDateFormat;
import universum.studios.android.dialog.DialogOptions;
import universum.studios.android.setting.SettingDialogPreference;

public abstract class SettingDateTimeDialogPreference<O extends DialogOptions<O>>
extends SettingDialogPreference<O> {
    private SimpleDateFormat format;
    private boolean millisecondsSet;
    private long milliseconds;

    SettingDateTimeDialogPreference(@NonNull Context context) {
        this(context, null);
    }

    SettingDateTimeDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0x1010091);
    }

    SettingDateTimeDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    SettingDateTimeDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected Object onGetDefaultValue(@NonNull TypedArray attributes, int index) {
        return attributes.getString(index);
    }

    protected void onSetInitialValue(@Nullable Object defaultValue) {
        this.setMilliseconds(this.getPersistedLong(defaultValue == null ? System.currentTimeMillis() : this.onParseDefaultValue(defaultValue)));
    }

    abstract long onParseDefaultValue(@NonNull Object var1);

    public void setFormat(@NonNull SimpleDateFormat format) {
        this.format = format;
    }

    void setMilliseconds(long milliseconds) {
        boolean changed;
        boolean bl = changed = this.milliseconds != milliseconds;
        if (changed || !this.millisecondsSet) {
            this.milliseconds = milliseconds;
            this.millisecondsSet = true;
            this.persistLong(this.milliseconds);
            if (changed) {
                this.notifyChanged();
            }
        }
    }

    boolean areMillisecondsSet() {
        return this.millisecondsSet;
    }

    long getMilliseconds() {
        return this.milliseconds;
    }

    @Override
    public void onBindViewHolder(@NonNull PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        this.synchronizeSummaryView(holder);
    }

    @Override
    @Nullable
    protected CharSequence onGetSummaryText() {
        return this.millisecondsSet && this.format != null ? this.format.format(this.milliseconds) : super.onGetSummaryText();
    }
}

