/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.XmlRes;
import androidx.core.app.ActivityCompat;
import androidx.preference.PreferenceFragmentCompat;

public abstract class SettingsBaseFragment
extends PreferenceFragmentCompat {
    private static final int NO_POSITION = -1;
    private static final String SAVED_STATE_KEY_BASE = SettingsBaseFragment.class.getName() + ".SAVED_STATE.";
    @VisibleForTesting
    static final String SAVED_STATE_FIRST_VISIBLE_ITEM_POSITION = SAVED_STATE_KEY_BASE + "FirstVisibleItemPosition";
    @VisibleForTesting
    static final String SAVED_STATE_FIRST_VISIBLE_ITEM_TOP = SAVED_STATE_KEY_BASE + "FirstVisibleItemTop";
    private boolean pendingBindPreferencesRequest;
    private boolean preferencesAdded;
    private int savedFirstVisibleItemPosition = -1;
    private int savedFirstVisibleItemTop;

    @CheckResult
    protected int checkSelfPermission(@NonNull String permission) {
        return ActivityCompat.checkSelfPermission((Context)this.requireContext(), (String)permission);
    }

    @CheckResult
    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        return Build.VERSION.SDK_INT >= 23 && super.shouldShowRequestPermissionRationale(permission);
    }

    protected void supportRequestPermissions(@NonNull String[] permissions, int requestCode) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(permissions, requestCode);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void addPreferencesFromResource(@XmlRes int preferencesResId) {
        super.addPreferencesFromResource(preferencesResId);
        this.handlePreferencesAdded();
    }

    private void handlePreferencesAdded() {
        this.preferencesAdded = true;
        this.onPreferencesAdded();
    }

    protected void onPreferencesAdded() {
        if (this.pendingBindPreferencesRequest) {
            this.pendingBindPreferencesRequest = false;
            this.onBindPreferences();
        }
    }

    protected void requestBindPreferences() {
        if (this.preferencesAdded) {
            this.onBindPreferences();
        } else {
            this.pendingBindPreferencesRequest = true;
        }
    }

    protected void onBindPreferences() {
    }

    public void onSaveInstanceState(@NonNull Bundle state) {
        super.onSaveInstanceState(state);
        state.putInt(SAVED_STATE_FIRST_VISIBLE_ITEM_POSITION, this.savedFirstVisibleItemPosition);
        state.putInt(SAVED_STATE_FIRST_VISIBLE_ITEM_TOP, this.savedFirstVisibleItemTop);
    }
}

