/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.Switch;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import androidx.preference.SwitchPreference;
import universum.studios.android.setting.PreferenceDecorator;
import universum.studios.android.setting.R;

public class SettingSwitchPreference
extends SwitchPreference {
    private PreferenceDecorator decorator;

    public SettingSwitchPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingSwitchPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 16843629);
    }

    public SettingSwitchPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.ensureDecorator();
    }

    @TargetApi(value=21)
    public SettingSwitchPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.ensureDecorator();
    }

    private void ensureDecorator() {
        if (this.decorator == null) {
            this.decorator = new PreferenceDecorator((Preference)this){

                @Override
                @Nullable
                Object onGetDefaultValue(@NonNull TypedArray attributes, int index) {
                    return SettingSwitchPreference.this.onGetDefaultValue(attributes, index);
                }

                @Override
                void onUpdateInitialValue(boolean restorePersistedValue, @Nullable Object defaultValue) {
                    SettingSwitchPreference.this.onSetInitialValue(restorePersistedValue, defaultValue);
                }
            };
        }
    }

    public void setKey(@NonNull String key) {
        boolean changed = !key.equals(this.getKey());
        super.setKey(key);
        if (changed) {
            this.ensureDecorator();
            this.decorator.handleKeyChange();
        }
    }

    public void onBindViewHolder(@NonNull PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        this.ensureDecorator();
        this.decorator.onBindViewHolder(holder);
        View checkableView = holder.findViewById(R.id.setting_switch);
        if (checkableView instanceof Checkable) {
            if (checkableView instanceof Switch) {
                Switch switchView = (Switch)checkableView;
                switchView.setOnCheckedChangeListener(null);
            }
            ((Checkable)checkableView).setChecked(this.isChecked());
        }
    }
}

