/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.preference.PreferenceViewHolder;
import universum.studios.android.dialog.Dialog;
import universum.studios.android.dialog.EditDialog;
import universum.studios.android.dialog.view.InputConfig;
import universum.studios.android.setting.R;
import universum.studios.android.setting.SettingDialogPreference;

public class SettingEditDialogPreference
extends SettingDialogPreference<EditDialog.EditOptions> {
    private boolean inputSet;
    private String input;

    public SettingEditDialogPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingEditDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.settingEditDialogPreferenceStyle);
    }

    public SettingEditDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public SettingEditDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onConfigureDialogOptions(@NonNull EditDialog.EditOptions options, @NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super.onConfigureDialogOptions(options, context, attrs, defStyleAttr, defStyleRes);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingEditDialogPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingEditDialogPreference_dialogHint) {
                options.hint(attributes.getText(attrIndex));
                continue;
            }
            if (attrIndex == R.styleable.SettingEditDialogPreference_dialogInputStyle) {
                options.inputConfig(InputConfig.fromStyle((Context)context, (int)attributes.getResourceId(attrIndex, 0)));
                continue;
            }
            if (attrIndex != R.styleable.SettingEditDialogPreference_dialogShowSoftKeyboard) continue;
            options.showSoftKeyboard(attributes.getBoolean(attrIndex, options.shouldShowSoftKeyboard()));
        }
        attributes.recycle();
    }

    @Override
    @NonNull
    protected EditDialog.EditOptions onCreateDialogOptions(@NonNull Resources resources) {
        return (EditDialog.EditOptions)new EditDialog.EditOptions(resources).title(this.getTitle());
    }

    protected Object onGetDefaultValue(@NonNull TypedArray typedArray, int index) {
        return typedArray.getString(index);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, @Nullable Object defaultValue) {
        this.setInput(restorePersistedValue ? this.getPersistedString(this.input) : (String)defaultValue);
    }

    public void setInput(@Nullable String input) {
        boolean changed;
        boolean bl = changed = !TextUtils.equals((CharSequence)this.input, (CharSequence)input);
        if (changed || !this.inputSet) {
            this.input = input;
            this.inputSet = true;
            this.persistString(this.input);
            if (changed) {
                this.notifyChanged();
            }
        }
    }

    @Nullable
    public String getInput() {
        return this.input;
    }

    @Override
    public void onBindViewHolder(@NonNull PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        this.synchronizeSummaryView(holder);
    }

    @Override
    @Nullable
    protected CharSequence onGetSummaryText() {
        return this.inputSet ? this.input : super.onGetSummaryText();
    }

    @Override
    @NonNull
    public EditDialog.EditOptions getDialogOptions() {
        EditDialog.EditOptions options = (EditDialog.EditOptions)super.getDialogOptions();
        if (this.inputSet) {
            options.content((CharSequence)this.input);
        }
        return options;
    }

    @Override
    protected boolean onHandleDialogButtonClick(@NonNull Dialog dialog, int button) {
        if (dialog instanceof EditDialog) {
            switch (button) {
                case 1: {
                    String newInput = ((EditDialog)dialog).getInput().toString();
                    if (this.callChangeListener(newInput)) {
                        this.setInput(newInput);
                    }
                    return true;
                }
            }
            return true;
        }
        return super.onHandleDialogButtonClick(dialog, button);
    }
}

