/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.preference.PreferenceViewHolder;
import universum.studios.android.dialog.ColorPickerDialog;
import universum.studios.android.dialog.Dialog;
import universum.studios.android.setting.R;
import universum.studios.android.setting.SettingDialogPreference;
import universum.studios.android.setting.widget.SettingColorView;

public final class SettingColorDialogPreference
extends SettingDialogPreference<ColorPickerDialog.ColorOptions> {
    private boolean colorSet;
    private int color = 0;

    public SettingColorDialogPreference(@NonNull Context context) {
        this(context, null);
    }

    public SettingColorDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.settingColorDialogPreferenceStyle);
    }

    public SettingColorDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public SettingColorDialogPreference(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    @NonNull
    protected ColorPickerDialog.ColorOptions onCreateDialogOptions(@NonNull Resources resources) {
        return new ColorPickerDialog.ColorOptions(resources);
    }

    @Override
    protected void onConfigureDialogOptions(@NonNull ColorPickerDialog.ColorOptions options, @NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super.onConfigureDialogOptions(options, context, attrs, defStyleAttr, defStyleRes);
        int canvasColor = options.canvasColor();
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingColorDialogPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingColorDialogPreference_dialogColor) {
                options.color(attributes.getColor(attrIndex, options.color()));
                continue;
            }
            if (attrIndex != R.styleable.SettingColorDialogPreference_dialogColorCanvas) continue;
            canvasColor = attributes.getColor(attrIndex, canvasColor);
        }
        attributes.recycle();
        options.canvasColor(canvasColor);
    }

    protected Object onGetDefaultValue(@NonNull TypedArray attributes, int index) {
        return attributes.getColor(index, this.color);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, @Nullable Object defaultValue) {
        this.setColor(restorePersistedValue ? this.getPersistedInt(this.color) : ((Integer)defaultValue).intValue());
    }

    public void setColor(@ColorInt int color) {
        boolean changed;
        boolean bl = changed = this.color != color;
        if (changed || !this.colorSet) {
            this.color = color;
            this.colorSet = true;
            this.persistInt(this.color);
            if (changed) {
                this.notifyChanged();
            }
        }
    }

    @ColorInt
    public int getColor() {
        return this.color;
    }

    @Override
    public void onBindViewHolder(@NonNull PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        SettingColorView colorView = (SettingColorView)holder.findViewById(R.id.setting_color_view);
        if (colorView != null) {
            colorView.setCanvasColor(this.getDialogOptions().canvasColor());
            colorView.setColor(this.color);
        }
    }

    @Override
    @NonNull
    public ColorPickerDialog.ColorOptions getDialogOptions() {
        ColorPickerDialog.ColorOptions options = (ColorPickerDialog.ColorOptions)super.getDialogOptions();
        if (this.colorSet) {
            options.color(this.color);
        }
        return options;
    }

    @Override
    protected boolean onHandleDialogButtonClick(@NonNull Dialog dialog, int button) {
        if (dialog instanceof ColorPickerDialog) {
            switch (button) {
                case 1: {
                    int newColor = ((ColorPickerDialog)dialog).getColor();
                    if (newColor != this.getColor() && this.callChangeListener(newColor)) {
                        this.setColor(newColor);
                    }
                    return true;
                }
            }
            return true;
        }
        return super.onHandleDialogButtonClick(dialog, button);
    }
}

