/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.setting;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import universum.studios.android.setting.R;
import universum.studios.android.setting.content.SettingsResourceUtils;

abstract class PreferenceDecorator {
    private final Preference preference;
    @VisibleForTesting
    Object defaultValue;

    PreferenceDecorator(Preference preference) {
        this.preference = preference;
    }

    void processAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SettingPreference, defStyleAttr, defStyleRes);
        int attributeCount = attributes.getIndexCount();
        for (int i = 0; i < attributeCount; ++i) {
            int attrIndex = attributes.getIndex(i);
            if (attrIndex == R.styleable.SettingPreference_android_defaultValue) {
                this.defaultValue = this.onGetDefaultValue(attributes, attrIndex);
                continue;
            }
            if (attrIndex != R.styleable.SettingPreference_settingVectorIcon) continue;
            this.setVectorIcon(attributes.getResourceId(attrIndex, 0));
        }
        attributes.recycle();
    }

    @Nullable
    abstract Object onGetDefaultValue(@NonNull TypedArray var1, int var2);

    void handleKeyChange() {
        this.updateInitialValue();
    }

    private void updateInitialValue() {
        boolean shouldPersist = this.shouldPersist();
        SharedPreferences preferences = this.preference.getSharedPreferences();
        if (shouldPersist && preferences != null && preferences.contains(this.preference.getKey())) {
            this.onUpdateInitialValue(true, null);
        } else if (this.defaultValue != null) {
            this.onUpdateInitialValue(false, this.defaultValue);
        }
    }

    private boolean shouldPersist() {
        return this.preference.getPreferenceManager() != null && this.preference.isPersistent() && this.preference.hasKey();
    }

    abstract void onUpdateInitialValue(boolean var1, @Nullable Object var2);

    @Nullable
    final Object getDefaultValue() {
        return this.defaultValue;
    }

    void setVectorIcon(@DrawableRes int resId) {
        Context context = this.preference.getContext();
        this.preference.setIcon(SettingsResourceUtils.getVectorDrawable(context.getResources(), resId, context.getTheme()));
    }

    void onBindViewHolder(@NonNull PreferenceViewHolder viewHolder) {
        View iconFrameView = viewHolder.findViewById(R.id.setting_icon_frame);
        if (iconFrameView != null) {
            iconFrameView.setVisibility(this.preference.getIcon() == null ? 8 : 0);
        }
    }
}

