/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.samples.ui;

import android.app.Activity;
import android.app.Fragment;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.NavigationView;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import java.util.LinkedList;
import universum.studios.android.samples.R;
import universum.studios.android.samples.ui.SamplesActivity;
import universum.studios.android.samples.ui.SamplesMainFragment;

public abstract class SamplesNavigationActivity
extends SamplesActivity
implements NavigationView.OnNavigationItemSelectedListener {
    private final LinkedList<Runnable> mWaitingNavigationActions = new LinkedList();
    private DrawerLayout mDrawerLayout;
    private NavigationToggle mNavigationToggle;
    private NavigationView mNavigationView;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.requestFeature(3);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.samples_activity_navigation);
        if (savedInstanceState == null) {
            this.getFragmentManager().beginTransaction().add(R.id.samples_container, (Fragment)new SamplesMainFragment(), SamplesMainFragment.FRAGMENT_TAG).commitAllowingStateLoss();
        }
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        this.mToolbar.setNavigationIcon((Drawable)VectorDrawableCompat.create((Resources)this.getResources(), (int)R.drawable.samples_vc_menu_24dp, (Resources.Theme)this.getTheme()));
        this.mDrawerLayout = (DrawerLayout)this.findViewById(R.id.samples_navigation_drawer);
        this.mNavigationToggle = new NavigationToggle((Activity)this, this.mDrawerLayout, this.mToolbar);
        this.mDrawerLayout.addDrawerListener((DrawerLayout.DrawerListener)this.mNavigationToggle);
        this.mNavigationView = (NavigationView)this.mDrawerLayout.findViewById(R.id.samples_navigation);
        int navigationMenuRes = 0;
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 129);
            navigationMenuRes = activityInfo.metaData.getInt("universum.studios.android.samples.SamplesMetaData.NAVIGATION_MENU");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        View navigationHeaderView = this.mNavigationView.getHeaderView(0);
        ((TextView)navigationHeaderView.findViewById(R.id.navigation_header_title)).setText(this.getApplicationInfo().labelRes);
        if (navigationMenuRes != 0) {
            this.mNavigationView.inflateMenu(navigationMenuRes);
            this.mNavigationView.setNavigationItemSelectedListener((NavigationView.OnNavigationItemSelectedListener)this);
        }
    }

    @NonNull
    public final DrawerLayout getNavigationLayout() {
        return this.mDrawerLayout;
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.mNavigationToggle.syncState();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mNavigationToggle.onConfigurationChanged(newConfig);
    }

    protected boolean toggleNavigation() {
        if (this.isNavigationOpen()) {
            this.closeNavigation();
            return false;
        }
        this.openNavigation();
        return true;
    }

    protected boolean closeNavigation() {
        if (this.isNavigationOpen()) {
            this.mDrawerLayout.closeDrawer(3);
            return true;
        }
        return false;
    }

    protected boolean openNavigation() {
        if (!this.isNavigationOpen()) {
            this.mDrawerLayout.openDrawer(3);
            return true;
        }
        return false;
    }

    protected boolean isNavigationOpen() {
        return this.mDrawerLayout != null && this.mDrawerLayout.isDrawerOpen(3);
    }

    public boolean onNavigationItemSelected(@NonNull MenuItem item) {
        if (this.onHandleNavigationItemSelected(item)) {
            this.closeNavigation();
            return true;
        }
        return false;
    }

    protected boolean onHandleNavigationItemSelected(@NonNull MenuItem item) {
        return false;
    }

    protected void onNavigationOpened() {
    }

    protected void onNavigationClosed() {
        if (this.hasWaitingNavigationActions()) {
            this.runAllWaitingNavigationActions();
        }
    }

    public void setNavigationAccessible(boolean accessible) {
        if (this.mNavigationToggle != null) {
            this.mNavigationToggle.setDrawerIndicatorEnabled(accessible);
        }
        if (this.mDrawerLayout != null) {
            this.closeNavigation();
            this.mDrawerLayout.setEnabled(accessible);
        }
    }

    protected final void scheduleNavigationAction(@NonNull Runnable action) {
        if (this.isNavigationOpen()) {
            this.registerNavigationAction(action);
            this.closeNavigation();
        } else {
            action.run();
        }
    }

    protected final void registerNavigationAction(@NonNull Runnable action) {
        this.mWaitingNavigationActions.add(action);
    }

    protected final boolean hasWaitingNavigationActions() {
        return !this.mWaitingNavigationActions.isEmpty();
    }

    protected final void runWaitingNavigationAction() {
        if (this.hasWaitingNavigationActions()) {
            this.mWaitingNavigationActions.removeFirst().run();
        }
    }

    protected final void runAllWaitingNavigationActions() {
        if (this.hasWaitingNavigationActions()) {
            while (!this.mWaitingNavigationActions.isEmpty()) {
                this.mWaitingNavigationActions.removeFirst().run();
            }
        }
    }

    private final class NavigationToggle
    extends ActionBarDrawerToggle {
        NavigationToggle(Activity activity, DrawerLayout drawerLayout, Toolbar toolbar) {
            super(activity, drawerLayout, toolbar, R.string.samples_content_navigation_opened, R.string.samples_content_navigation_closed);
            this.setHomeAsUpIndicator((Drawable)VectorDrawableCompat.create((Resources)SamplesNavigationActivity.this.getResources(), (int)R.drawable.samples_vc_arrow_back_24dp, (Resources.Theme)SamplesNavigationActivity.this.getTheme()));
            this.setToolbarNavigationClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!SamplesNavigationActivity.this.onToolbarNavigationIconClick()) {
                        SamplesNavigationActivity.this.onBackPressed();
                    }
                }
            });
        }

        public void onDrawerOpened(View drawerView) {
            drawerView.bringToFront();
            SamplesNavigationActivity.this.onNavigationOpened();
        }

        public void onDrawerClosed(View drawerView) {
            SamplesNavigationActivity.this.onNavigationClosed();
        }
    }
}

