/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.samples.ui;

import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.view.View;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import junit.framework.Assert;
import universum.studios.android.samples.ui.SamplesFragment;
import universum.studios.android.widget.adapter.DataSetAdapter;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;

public abstract class SamplesCollectionViewFragment<A, CV extends View, EV extends View>
extends SamplesFragment
implements OnDataSetListener,
OnDataSetActionListener {
    private static final String TAG = "SamplesCollectionViewFragment";
    protected static final int FEATURE_DATA_SET_LISTENER = 65536;
    protected static final int FEATURE_DATA_SET_ACTION_LISTENER = 131072;
    protected static final int FEATURES_DATA_SET = 196608;
    protected static final int NO_POSITION = -1;
    protected CV collectionView;
    protected EV emptyView;
    protected A adapter;

    @Override
    protected int requestFeature(int feature) {
        return super.requestFeature(feature);
    }

    @Override
    protected boolean hasFeature(int feature) {
        return super.hasFeature(feature);
    }

    @Override
    protected void removeFeature(int feature) {
        super.removeFeature(feature);
    }

    public void setAdapter(@Nullable A adapter) {
        this.detachAdapter();
        this.adapter = adapter;
        this.attachAdapter();
    }

    private void attachAdapter() {
        if (this.adapter != null) {
            this.onAttachAdapter(this.adapter);
        }
    }

    @CallSuper
    protected void onAttachAdapter(@NonNull A adapter) {
        if (adapter instanceof DataSetAdapter) {
            DataSetAdapter dataSetAdapter = (DataSetAdapter)adapter;
            if (this.hasFeature(65536)) {
                dataSetAdapter.registerOnDataSetListener((OnDataSetListener)this);
            }
            if (this.hasFeature(131072)) {
                dataSetAdapter.registerOnDataSetActionListener((OnDataSetActionListener)this);
            }
        }
    }

    @Nullable
    public A getAdapter() {
        return this.adapter;
    }

    private void detachAdapter() {
        if (this.adapter != null) {
            this.onDetachAdapter(this.adapter);
        }
    }

    @CallSuper
    protected void onDetachAdapter(@NonNull A adapter) {
        if (adapter instanceof DataSetAdapter) {
            DataSetAdapter dataSetAdapter = (DataSetAdapter)adapter;
            dataSetAdapter.unregisterOnDataSetListener((OnDataSetListener)this);
            dataSetAdapter.unregisterOnDataSetActionListener((OnDataSetActionListener)this);
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.collectionView = view.findViewById(16908298);
        Assert.assertNotNull((String)("No collection view found within the current view hierarchy of fragment(" + ((Object)((Object)this)).getClass().getSimpleName() + ")!"), (Object)this.collectionView);
        this.emptyView = view.findViewById(16908292);
        this.updateEmptyViewVisibility();
    }

    @NonNull
    public CV getCollectionView() {
        Assert.assertNotNull((String)("View for fragment(" + ((Object)((Object)this)).getClass().getSimpleName() + ") is not created yet!"), this.collectionView);
        return this.collectionView;
    }

    @IntRange(from=-1L)
    protected int findFirstVisibleItemPosition() {
        return -1;
    }

    @IntRange(from=-1L)
    protected int findLastVisibleItemPosition() {
        return -1;
    }

    protected abstract boolean isAdapterEmpty();

    protected void setEmptyText(@StringRes int resId) {
        this.setEmptyText(resId != 0 ? this.getText(resId) : "");
    }

    protected void setEmptyText(@Nullable CharSequence text) {
        if (this.emptyView instanceof TextView) {
            ((TextView)this.emptyView).setText(text);
        }
    }

    protected void updateEmptyViewVisibility() {
        this.setEmptyViewVisible(this.shouldBeEmptyViewVisible());
    }

    protected boolean shouldBeEmptyViewVisible() {
        return this.isAdapterEmpty();
    }

    protected void setEmptyViewVisible(boolean visible) {
        if (this.emptyView != null) {
            this.emptyView.setVisibility(visible ? 0 : 8);
        }
    }

    public void onDataSetChanged() {
    }

    public void onDataSetInvalidated() {
    }

    public boolean onDataSetActionSelected(int action, int position, long id2, @Nullable Object payload) {
        return false;
    }

    public void onDestroy() {
        super.onDestroy();
        this.detachAdapter();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    protected static @interface DataSetFeature {
    }
}

