/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.samples.ui;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import butterknife.ButterKnife;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import junit.framework.Assert;
import universum.studios.android.samples.R;

public class SamplesActivity
extends AppCompatActivity {
    protected static final int FEATURE_DEPENDENCIES_INJECTION = 1;
    protected static final int FEATURE_TOOLBAR = 2;
    private int mFeatures;
    Toolbar mToolbar;

    public int requestFeature(int feature) {
        this.mFeatures |= feature;
        return feature;
    }

    public boolean hasFeature(int feature) {
        return (this.mFeatures & feature) == feature;
    }

    public void removeFeature(int feature) {
        this.mFeatures &= ~feature;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onContentChanged() {
        super.onContentChanged();
        if (this.hasFeature(1)) {
            ButterKnife.bind((Activity)this);
        }
        if (this.hasFeature(2)) {
            this.mToolbar = (Toolbar)this.findViewById(R.id.samples_toolbar);
            if (this.mToolbar == null) {
                throw new NullPointerException("No toolbar found within the view hierarchy!");
            }
            this.setSupportActionBar(this.mToolbar);
            ActionBar actionBar = this.getSupportActionBar();
            actionBar.setDisplayHomeAsUpEnabled(true);
            if (this.handlesToolbarNavigationIconClick()) {
                this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (!SamplesActivity.this.onToolbarNavigationIconClick()) {
                            SamplesActivity.this.onBackPressed();
                        }
                    }
                });
            }
        }
    }

    protected boolean handlesToolbarNavigationIconClick() {
        return true;
    }

    protected boolean onToolbarNavigationIconClick() {
        return false;
    }

    @NonNull
    public Toolbar getToolbar() {
        Assert.assertNotNull((String)("Activity(" + ((Object)((Object)this)).getClass().getSimpleName() + ") does not have toolbar presented!"), (Object)this.mToolbar);
        return this.mToolbar;
    }

    public void setTitle(@Nullable CharSequence title) {
        if (this.mToolbar != null) {
            this.mToolbar.setTitle(title);
        } else {
            super.setTitle(title);
        }
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (!this.onBackPress()) {
            super.onBackPressed();
        }
    }

    protected boolean onBackPress() {
        return this.dispatchBackPressToCurrentFragment();
    }

    private boolean dispatchBackPressToCurrentFragment() {
        return false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    protected static @interface ActivityFeature {
    }
}

