/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.samples.model;

import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;

public class SampleItem {
    private final long mId;
    private final CharSequence mTitle;
    private final CharSequence mSubtitle;

    protected SampleItem(@NonNull Builder builder) {
        this.mId = builder.id;
        this.mTitle = builder.title;
        this.mSubtitle = builder.subtitle;
    }

    public final long getId() {
        return this.mId;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @NonNull
    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public static class Builder {
        private final Resources resources;
        private long id = -1L;
        CharSequence title = "";
        CharSequence subtitle = "";

        public Builder(@NonNull Resources resources) {
            this.resources = resources;
        }

        public Builder reset() {
            this.id = -1L;
            this.subtitle = "";
            this.title = "";
            return this;
        }

        public Builder id(long id2) {
            this.id = id2;
            return this;
        }

        public Builder title(@StringRes int resId) {
            return this.title(this.resources.getText(resId));
        }

        public Builder title(@NonNull CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder subtitle(@StringRes int resId) {
            return this.subtitle(this.resources.getText(resId));
        }

        public Builder subtitle(@NonNull CharSequence subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @NonNull
        public SampleItem build() {
            return new SampleItem(this);
        }
    }
}

